/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.base.exception.BizException;
import com.geoway.ns.zyfx.domain.ZyfxToolCenterGroup;
import com.geoway.ns.zyfx.domain.ZyfxToolCenterGroupRel;
import com.geoway.ns.zyfx.domain.ZyfxToolCenterScheme;
import com.geoway.ns.zyfx.mapper.ZyfxToolCenterSchemeMapper;
import com.geoway.ns.zyfx.service.ZyfxToolCenterGroupRelService;
import com.geoway.ns.zyfx.service.ZyfxToolCenterGroupService;
import com.geoway.ns.zyfx.service.ZyfxToolCenterSchemeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class ZyfxToolCenterSchemeServiceImpl
extends ServiceImpl<ZyfxToolCenterSchemeMapper, ZyfxToolCenterScheme>
implements ZyfxToolCenterSchemeService {
    @Autowired
    private ZyfxToolCenterGroupService groupService;
    @Autowired
    private ZyfxToolCenterGroupRelService groupRelService;

    @Override
    public ZyfxToolCenterScheme findDefault() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ZyfxToolCenterScheme::getIsdefault, (Object)1)).orderByDesc(ZyfxToolCenterScheme::getCreatetime)).last("LIMIT 1");
        return (ZyfxToolCenterScheme)this.getOne((Wrapper)wrapper);
    }

    @Override
    public ZyfxToolCenterScheme findByKey(String key) {
        if (!StringUtils.hasText((String)key)) {
            return null;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ZyfxToolCenterScheme::getKey, (Object)key);
        return (ZyfxToolCenterScheme)this.getOne((Wrapper)wrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOne(ZyfxToolCenterScheme scheme) throws BizException {
        if (!StringUtils.hasText((String)scheme.getName())) {
            throw new BizException("\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (scheme.getIsdefault() != null && scheme.getIsdefault() == 1) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(ZyfxToolCenterScheme::getIsdefault, (Object)1);
            if (StringUtils.hasText((String)scheme.getId())) {
                wrapper.ne(ZyfxToolCenterScheme::getId, (Object)scheme.getId());
            }
            List defaultSchemes = this.list((Wrapper)wrapper);
            for (ZyfxToolCenterScheme s : defaultSchemes) {
                s.setIsdefault(0);
                s.setUpdatetime(new Date());
                this.updateById(s);
            }
        }
        if (StringUtils.hasText((String)scheme.getId())) {
            scheme.setUpdatetime(new Date());
            this.updateById(scheme);
        } else {
            scheme.setCreatetime(new Date());
            this.save(scheme);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteOne(String id) throws BizException {
        if (!StringUtils.hasText((String)id)) {
            throw new BizException("\u65b9\u6848ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ZyfxToolCenterScheme scheme = (ZyfxToolCenterScheme)this.getById((Serializable)((Object)id));
        if (scheme != null && scheme.getIsdefault() != null && scheme.getIsdefault() == 1) {
            throw new BizException("\u9ed8\u8ba4\u65b9\u6848\u4e0d\u80fd\u5220\u9664");
        }
        List<ZyfxToolCenterGroup> groups = this.groupService.listBySchemeId(id);
        for (ZyfxToolCenterGroup group : groups) {
            this.groupService.deleteOne(group.getId());
        }
        this.removeById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ZyfxToolCenterScheme copyScheme(String id, String newName) throws BizException {
        if (!StringUtils.hasText((String)id)) {
            throw new BizException("\u65b9\u6848ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)newName)) {
            throw new BizException("\u65b0\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ZyfxToolCenterScheme sourceScheme = (ZyfxToolCenterScheme)this.getById((Serializable)((Object)id));
        if (sourceScheme == null) {
            throw new BizException("\u6e90\u65b9\u6848\u4e0d\u5b58\u5728");
        }
        ZyfxToolCenterScheme newScheme = new ZyfxToolCenterScheme();
        BeanUtils.copyProperties((Object)sourceScheme, (Object)newScheme);
        newScheme.setId(null);
        newScheme.setName(newName);
        newScheme.setIsdefault(0);
        newScheme.setCreatetime(new Date());
        newScheme.setUpdatetime(null);
        this.save(newScheme);
        List<ZyfxToolCenterGroup> sourceGroups = this.groupService.listBySchemeId(id);
        for (ZyfxToolCenterGroup sourceGroup : sourceGroups) {
            ZyfxToolCenterGroup newGroup = new ZyfxToolCenterGroup();
            BeanUtils.copyProperties((Object)sourceGroup, (Object)newGroup);
            newGroup.setId(null);
            newGroup.setSchemeId(newScheme.getId());
            newGroup.setCreatetime(new Date());
            newGroup.setUpdatetime(null);
            this.groupService.save(newGroup);
            List<String> toolsetIds = this.groupRelService.getToolsetIdsByGroupId(sourceGroup.getId());
            if (toolsetIds.isEmpty()) continue;
            ArrayList<ZyfxToolCenterGroupRel> rels = new ArrayList<ZyfxToolCenterGroupRel>();
            for (int i = 0; i < toolsetIds.size(); ++i) {
                ZyfxToolCenterGroupRel rel = new ZyfxToolCenterGroupRel();
                rel.setGroupId(newGroup.getId());
                rel.setToolsetId(toolsetIds.get(i));
                rel.setSort(i);
                rel.setCreatetime(new Date());
                rels.add(rel);
            }
            this.groupRelService.saveBatch(rels);
        }
        return newScheme;
    }

    @Override
    public List<ZyfxToolCenterScheme> listAllWithDetails() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.orderByAsc(ZyfxToolCenterScheme::getSort)).orderByDesc(ZyfxToolCenterScheme::getCreatetime);
        List schemes = this.list((Wrapper)wrapper);
        if (schemes == null || schemes.isEmpty()) {
            return new ArrayList<ZyfxToolCenterScheme>();
        }
        for (ZyfxToolCenterScheme scheme : schemes) {
            if (scheme == null || scheme.getId() == null) continue;
            List<ZyfxToolCenterGroup> groups = this.groupService.listBySchemeIdWithToolsets(scheme.getId());
            scheme.setGroups(groups);
        }
        return schemes;
    }

    @Override
    public ZyfxToolCenterScheme getDetailById(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        ZyfxToolCenterScheme scheme = (ZyfxToolCenterScheme)this.getById((Serializable)((Object)id));
        if (scheme != null && scheme.getId() != null) {
            ArrayList groups = this.groupService.listBySchemeIdWithToolsets(scheme.getId());
            scheme.setGroups(groups != null ? groups : new ArrayList());
        }
        return scheme;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setDefault(String id) throws BizException {
        if (!StringUtils.hasText((String)id)) {
            throw new BizException("\u65b9\u6848ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ZyfxToolCenterScheme scheme = (ZyfxToolCenterScheme)this.getById((Serializable)((Object)id));
        if (scheme == null) {
            throw new BizException("\u65b9\u6848\u4e0d\u5b58\u5728");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ZyfxToolCenterScheme::getIsdefault, (Object)1);
        List defaultSchemes = this.list((Wrapper)wrapper);
        for (ZyfxToolCenterScheme s : defaultSchemes) {
            s.setIsdefault(0);
            s.setUpdatetime(new Date());
            this.updateById(s);
        }
        scheme.setIsdefault(1);
        scheme.setUpdatetime(new Date());
        this.updateById(scheme);
    }
}

