CREATE TABLE tb_zyfx_serviceset_api (
	f_id varchar(50) NOT NULL,
	f_objectid varchar(50) NULL,
	f_servicetype varchar NULL,
	f_source int2 NULL,
	f_name varchar NULL,
	f_desc varchar NULL,
	f_url text NULL,
	f_virtualurl text NULL,
	f_method varchar NULL,
	f_inputparams text NULL,
	f_outputparams text NULL,
	f_requestexample text NULL,
	f_reponseexample text NULL,
	f_otherparams text NULL,
	f_order int2 NULL,
	f_istest varchar NULL,
	f_createtime timestamp NULL,
	f_updatetime timestamp NULL
);

-- Column comments

COMMENT ON COLUMN tb_zyfx_serviceset_api.f_id IS '主键';
COMMENT ON COLUMN tb_zyfx_serviceset_api.f_objectid IS '服务资源id';
COMMENT ON COLUMN tb_zyfx_serviceset_api.f_servicetype IS '服务类型二级类';
COMMENT ON COLUMN tb_zyfx_serviceset_api.f_source IS '接口来源：1手动注册；2自动获取；';
COMMENT ON COLUMN tb_zyfx_serviceset_api.f_name IS '接口中文名称';
COMMENT ON COLUMN tb_zyfx_serviceset_api.f_desc IS '接口中文描述';
COMMENT ON COLUMN tb_zyfx_serviceset_api.f_url IS '接口地址';
COMMENT ON COLUMN tb_zyfx_serviceset_api.f_virtualurl IS '虚拟接口地址';
COMMENT ON COLUMN tb_zyfx_serviceset_api.f_method IS '支持的方法，多个通过逗号隔开';
COMMENT ON COLUMN tb_zyfx_serviceset_api.f_inputparams IS '接口参数(json存储）';
COMMENT ON COLUMN tb_zyfx_serviceset_api.f_outputparams IS '输出参数';
COMMENT ON COLUMN tb_zyfx_serviceset_api.f_requestexample IS '请求示例';
COMMENT ON COLUMN tb_zyfx_serviceset_api.f_reponseexample IS '返回示例';
COMMENT ON COLUMN tb_zyfx_serviceset_api.f_otherparams IS '预留扩展参数';
COMMENT ON COLUMN tb_zyfx_serviceset_api.f_order IS '排序';
COMMENT ON COLUMN tb_zyfx_serviceset_api.f_istest IS '是否支持测试';
COMMENT ON COLUMN tb_zyfx_serviceset_api.f_createtime IS '创建时间';
COMMENT ON COLUMN tb_zyfx_serviceset_api.f_updatetime IS '更新时间';
ALTER TABLE tb_zyfx_serviceset_api ADD CONSTRAINT tb_zyfx_serviceset_api_pk PRIMARY KEY (f_id);
-- tb_zyfx_serviceset
ALTER TABLE tb_zyfx_serviceset ADD f_servicetype1 varchar NULL;
COMMENT ON COLUMN tb_zyfx_serviceset.f_servicetype1 IS '服务类型：分析服务ANALY和地图服务MAP';
ALTER TABLE tb_zyfx_serviceset ADD f_servicetype varchar NULL;
COMMENT ON COLUMN tb_zyfx_serviceset.f_servicetype IS '服务类型到详细类型：wmts、wfs等等';