/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.monitor.utils;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.ns.sys.utils.EsUtils;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedLongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ParsedMax;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EsUtilMonitor
extends EsUtils {
    private static final Logger log = LoggerFactory.getLogger(EsUtilMonitor.class);
    @Value(value="${es.monitorIndex:}")
    private String index;

    public <T> Page<T> searchPage(SearchSourceBuilder builder, Class<T> c, Integer page, Integer size) {
        SearchRequest request = new SearchRequest(new String[]{this.index});
        builder.from((page - 1) * size);
        builder.size(size.intValue());
        request.source(builder);
        Page res = new Page();
        if (client == null) {
            System.out.println("\u6ca1\u6709\u914d\u7f6ees\u670d\u52a1\u4fe1\u606f\uff0c\u5ba2\u6237\u7aef\u4e0d\u53ef\u7528\uff01");
            return res;
        }
        try {
            SearchResponse response = client.search(request, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            res.setRecords(this.convertList(hits.getHits(), c));
            res.setTotal(hits.getTotalHits().value);
            res.setCurrent((long)page.intValue());
            res.setSize((long)size.intValue());
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return res;
        }
    }

    protected <T> List<T> convertList(SearchHit[] hits, Class<T> target) throws Exception {
        ArrayList<Object> res = new ArrayList<Object>(hits.length);
        for (SearchHit hit : hits) {
            String sourceAsString = hit.getSourceAsString();
            Object t = JSON.parseObject((String)hit.getSourceAsString(), target);
            BeanUtil.setProperty((Object)t, (String)"logId", (Object)hit.getId());
            res.add(t);
        }
        return res;
    }

    public String groupCounts(SearchSourceBuilder builder, String group) {
        String result = "";
        if (client == null) {
            System.out.println("\u6ca1\u6709\u914d\u7f6ees\u670d\u52a1\u4fe1\u606f\uff0c\u5ba2\u6237\u7aef\u4e0d\u53ef\u7528\uff01");
            return result;
        }
        SearchRequest request = new SearchRequest(new String[]{this.index});
        request.source(builder);
        try {
            SearchResponse search = client.search(request, RequestOptions.DEFAULT);
            Aggregations aggregations = search.getAggregations();
            Aggregation aggregation = aggregations.get(group);
            result = JSON.toJSONString((Object)aggregation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<String, List> queryExceptionByIds(List<String> ids, String queryId, Integer type) {
        HashMap<String, List> result = new HashMap<String, List>();
        if (client == null) {
            System.out.println("\u6ca1\u6709\u914d\u7f6ees\u670d\u52a1\u4fe1\u606f\uff0c\u5ba2\u6237\u7aef\u4e0d\u53ef\u7528\uff01");
            return result;
        }
        SearchRequest request = new SearchRequest(new String[]{this.index});
        SearchSourceBuilder builder = new SearchSourceBuilder();
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        query.filter((QueryBuilder)(type == 0 ? QueryBuilders.termsQuery((String)"serviceId", ids) : QueryBuilders.termsQuery((String)"userId.keyword", ids)));
        if (StrUtil.isNotBlank((CharSequence)queryId)) {
            query.filter((QueryBuilder)(type == 0 ? QueryBuilders.matchQuery((String)"userId.keyword", (Object)queryId) : QueryBuilders.matchQuery((String)"serviceId.keyword", (Object)queryId)));
        }
        query.filter((QueryBuilder)QueryBuilders.matchQuery((String)"exception", (Object)1));
        builder.query((QueryBuilder)query);
        TermsAggregationBuilder aggres = type == 0 ? ((TermsAggregationBuilder)AggregationBuilders.terms((String)"group").field("serviceId.keyword")).size(99999999) : ((TermsAggregationBuilder)AggregationBuilders.terms((String)"group").field("userId.keyword")).size(99999999);
        aggres.subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_exception").field("code")).size(999));
        builder.aggregation((AggregationBuilder)aggres);
        request.source(builder);
        try {
            SearchResponse search = client.search(request, RequestOptions.DEFAULT);
            Aggregations aggregations = search.getAggregations();
            ParsedStringTerms aggregation = (ParsedStringTerms)aggregations.get("group");
            if (ObjectUtils.isNotEmpty((Object)aggregation) && aggregation.getBuckets().size() > 0) {
                for (Terms.Bucket bucket : aggregation.getBuckets()) {
                    String id = bucket.getKeyAsString();
                    ParsedLongTerms groupServiceException = (ParsedLongTerms)bucket.getAggregations().get("group_exception");
                    ArrayList exceptionList = new ArrayList();
                    if (ObjectUtils.isNotEmpty((Object)groupServiceException) && groupServiceException.getBuckets().size() > 0) {
                        for (Terms.Bucket exceptionBucket : groupServiceException.getBuckets()) {
                            HashMap<String, Object> excepitonMap = new HashMap<String, Object>();
                            excepitonMap.put("name", exceptionBucket.getKeyAsString());
                            excepitonMap.put("count", exceptionBucket.getDocCount());
                            exceptionList.add(excepitonMap);
                        }
                    }
                    result.put(id, exceptionList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List serviceMonitorGroup(SearchSourceBuilder builder) {
        ArrayList result = new ArrayList();
        if (client == null) {
            System.out.println("\u6ca1\u6709\u914d\u7f6ees\u670d\u52a1\u4fe1\u606f\uff0c\u5ba2\u6237\u7aef\u4e0d\u53ef\u7528\uff01");
            return result;
        }
        SearchRequest request = new SearchRequest(new String[]{this.index});
        TermsAggregationBuilder aggres = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_service").field("serviceId.keyword")).size(99999999);
        aggres.subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_service_name").field("serviceName.keyword")).size(1));
        aggres.subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_service_type").field("serviceType.keyword")).size(1));
        aggres.subAggregation((AggregationBuilder)AggregationBuilders.max((String)"group_service_time").field("accessTime"));
        aggres.subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_service_code").field("code")).size(10));
        builder.aggregation((AggregationBuilder)aggres);
        request.source(builder);
        try {
            SearchResponse search = client.search(request, RequestOptions.DEFAULT);
            Aggregations aggregations = search.getAggregations();
            ParsedStringTerms aggregation = (ParsedStringTerms)aggregations.get("group_service");
            if (ObjectUtils.isNotEmpty((Object)aggregation) && aggregation.getBuckets().size() > 0) {
                for (Terms.Bucket bucket : aggregation.getBuckets()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    String serviceId = bucket.getKeyAsString();
                    ParsedStringTerms groupServiceName = (ParsedStringTerms)bucket.getAggregations().get("group_service_name");
                    String serviceName = null;
                    if (groupServiceName.getBuckets() != null && groupServiceName.getBuckets().size() > 0) {
                        serviceName = ((Terms.Bucket)groupServiceName.getBuckets().get(0)).getKeyAsString();
                    }
                    ParsedStringTerms groupServiceType = (ParsedStringTerms)bucket.getAggregations().get("group_service_type");
                    String serviceType = null;
                    if (groupServiceType.getBuckets() != null && groupServiceType.getBuckets().size() > 0) {
                        serviceType = ((Terms.Bucket)groupServiceType.getBuckets().get(0)).getKeyAsString();
                    }
                    ParsedMax groupServiceTime = (ParsedMax)bucket.getAggregations().get("group_service_time");
                    String accessTime = new DecimalFormat("0").format(groupServiceTime.getValue());
                    LocalDateTime time = Instant.ofEpochMilli(Long.valueOf(accessTime)).atZone(ZoneOffset.ofHours(8)).toLocalDateTime();
                    DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    accessTime = df.format(time);
                    ParsedLongTerms groupServiceException = (ParsedLongTerms)bucket.getAggregations().get("group_service_code");
                    ArrayList exceptionList = new ArrayList();
                    if (ObjectUtils.isNotEmpty((Object)groupServiceException) && groupServiceException.getBuckets().size() > 0) {
                        for (Terms.Bucket exceptionBucket : groupServiceException.getBuckets()) {
                            HashMap<String, Number> excepitonMap = new HashMap<String, Number>();
                            excepitonMap.put("value", Integer.valueOf(exceptionBucket.getKeyAsString()));
                            excepitonMap.put("count", exceptionBucket.getDocCount());
                            exceptionList.add(excepitonMap);
                        }
                    }
                    map.put("serviceId", serviceId);
                    map.put("serviceName", serviceName);
                    map.put("accessTime", accessTime);
                    map.put("exception", exceptionList);
                    map.put("serviceType", serviceType);
                    result.add(map);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

