/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.dto.RowsResponse;
import com.geoway.ns.sys.utils.MyRequestUtil;
import com.geoway.ns.zyfx.domain.ZyfxCatalog;
import com.geoway.ns.zyfx.domain.ZyfxCatalogScheme;
import com.geoway.ns.zyfx.domain.ZyfxObject;
import com.geoway.ns.zyfx.dto.ZyfxCatalogDTO;
import com.geoway.ns.zyfx.dto.ZyfxCatalogDetail;
import com.geoway.ns.zyfx.service.SyncRsCatalogService;
import com.geoway.ns.zyfx.service.ZyfxCatalogObjectService;
import com.geoway.ns.zyfx.service.ZyfxCatalogSchemeService;
import com.geoway.ns.zyfx.service.ZyfxCatalogService;
import com.geoway.ns.zyfx.service.ZyfxObjectService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u76ee\u5f55\u63a5\u53e3"})
@RestController
@RequestMapping(value={"zyfx/catalog"})
public class ZyfxCatalogController {
    private static final Logger log = LoggerFactory.getLogger(ZyfxCatalogController.class);
    @Autowired
    ZyfxCatalogSchemeService zyfxCatalogSchemeService;
    @Autowired
    ZyfxCatalogService zyfxCatalogService;
    @Autowired
    ZyfxCatalogObjectService zyfxCatalogObjectService;
    @Autowired
    ZyfxObjectService zyfxObjectService;
    @Autowired
    SyncRsCatalogService syncRsCatalogService;

    @ApiOperation(value="\u67e5\u8be2\u76ee\u5f55\u6811")
    @GetMapping(value={"listTree"}, produces={"application/json;charset=UTF-8"})
    public RowsResponse queryDataCatalogList(HttpServletRequest request, @RequestParam(value="keyword", required=false, defaultValue="") String keyword, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(value="groupType", required=true) Integer groupType, @RequestParam(value="schemeId", required=false) String schemeId, @RequestParam(value="isApplication", required=false) Integer isApplication, @RequestParam(value="needDataNode", defaultValue="false", required=false) boolean needDataNode) {
        RowsResponse response = new RowsResponse();
        try {
            if (StrUtil.isEmpty((CharSequence)sortParam)) {
                sortParam = "SORT_sort_ASC";
            }
            if (StrUtil.isBlank((CharSequence)schemeId)) {
                ZyfxCatalogScheme zyfxCatalogScheme = this.zyfxCatalogSchemeService.findDefault();
                schemeId = zyfxCatalogScheme != null ? zyfxCatalogScheme.getId() : "";
            }
            List<ZyfxCatalog> catalogList = this.zyfxCatalogService.queryTree(filterParam, sortParam, groupType, schemeId, isApplication, needDataNode, keyword);
            response.setRows(catalogList);
            response.setTotal(Long.valueOf(catalogList.size()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5220\u9664\u76ee\u5f55\u8282\u70b9")
    @PostMapping(value={"delete"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse deleteCatalog(HttpServletRequest request, String id) {
        BaseResponse response = new BaseResponse();
        if (StrUtil.isNotEmpty((CharSequence)id)) {
            try {
                this.zyfxCatalogService.deleteNode(id);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage(), (Throwable)e);
                response.markFailure(e.getMessage());
            }
        }
        return response;
    }

    @ApiOperation(value="\u4fdd\u5b58\u76ee\u5f55\u8282\u70b9")
    @PostMapping(value={"save"}, consumes={"multipart/form-data"}, produces={"application/json;charset=UTF-8"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="otherfiles", value="\u6587\u4ef6\u6d41\u5bf9\u8c61,\u63a5\u6536\u6570\u7ec4\u683c\u5f0f", required=false, allowMultiple=true)})
    public BaseResponse saveCatalog(HttpServletRequest request, @ModelAttribute ZyfxCatalogDTO catalogNode, @RequestPart(value="otherfiles", required=false) MultipartFile[] otherfiles, @RequestPart(value="file", required=false) MultipartFile file, @RequestPart(value="logofile", required=false) MultipartFile logofile) {
        BaseResponse response = new BaseResponse();
        try {
            InputStream inputStream = null;
            if (file != null) {
                inputStream = file.getInputStream();
            }
            ZyfxCatalog catalog = new ZyfxCatalog();
            BeanUtils.copyProperties((Object)catalogNode, (Object)catalog);
            this.zyfxCatalogService.saveCatalogNode(catalog, file, logofile, otherfiles);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u76ee\u5f55\u91cd\u547d\u540d")
    @PostMapping(value={"rename"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse rename(HttpServletRequest request, String id, String name) {
        BaseResponse response = new BaseResponse();
        this.zyfxCatalogService.updateName(id, name);
        return response;
    }

    @ApiOperation(value="\u6ce8\u518c\u8d44\u6e90\u96c6")
    @PostMapping(value={"regObjectSets"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse regSets(HttpServletRequest request, @RequestParam(value="nodeId") String nodeId, @RequestParam(value="ids") String ids, @RequestParam(value="groupType") Integer groupType) {
        BaseResponse response = new BaseResponse();
        try {
            this.zyfxCatalogService.regObjectSets(nodeId, ids, groupType);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6279\u91cf\u6ce8\u518c\u670d\u52a1")
    @PostMapping(value={"regServerBatch"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse regServerBatch(HttpServletRequest request, @RequestParam(value="serverJson") String serverJson, @RequestParam(value="groupType") Integer groupType) {
        BaseResponse response = new BaseResponse();
        try {
            this.zyfxCatalogService.regServerBatch(serverJson, groupType);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        return response;
    }

    @ApiOperation(value="\u6ce8\u518c\u670d\u52a1\u8fc7\u6ee4")
    @GetMapping(value={"serviceFiltering"}, produces={"application/json;charset=UTF-8"})
    public DataResponse<Object> serviceFiltering(HttpServletRequest request, @RequestParam(value="url") String url, @RequestParam(value="type") String type) {
        DataResponse response = new DataResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            JSONObject jsonObject = this.zyfxCatalogService.serviceFiltering(token, url, type);
            response.setResult(jsonObject.get((Object)"Results"));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6ce8\u9500\u8d44\u6e90\u96c6")
    @PostMapping(value={"unRegObjectSets"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse unRegObjectSets(HttpServletRequest request, @RequestParam(value="nodeId") String nodeId, @RequestParam(value="ids") String ids, @RequestParam(value="groupType") Integer groupType) {
        BaseResponse response = new BaseResponse();
        try {
            this.zyfxCatalogService.unRegObjectSets(nodeId, ids, groupType);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u67e5\u8be2\u76ee\u5f55\u6811\u8282\u70b9\u5173\u8054\u7684\u5bf9\u8c61\u96c6")
    @GetMapping(value={"listObjectSets"}, produces={"application/json;charset=UTF-8"})
    public RowsResponse listObjectSets(HttpServletRequest request, @RequestParam(value="filterParam", required=false, defaultValue="") String filterParam, @RequestParam(value="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(value="nodeId", required=false, defaultValue="") String nodeId, @RequestParam(value="schemeId", required=false, defaultValue="") String schemeId, @RequestParam(value="groupType", required=false, defaultValue="-1") Integer groupType, @RequestParam(value="favorite", defaultValue="2", required=false) Integer favorite, @RequestParam(value="inCart", defaultValue="2", required=false) Integer inCart, @RequestParam(value="isApplication", required=false) Integer isApplication, @RequestParam(value="page", required=true) Integer page, @RequestParam(value="size", required=true) Integer size, @RequestParam(value="haveDetail", defaultValue="false", required=false) boolean haveDetail) {
        RowsResponse response = new RowsResponse();
        try {
            if (StrUtil.isEmpty((CharSequence)sortParam)) {
                sortParam = "SORT_createtime_DESC";
            }
            IPage<ZyfxObject> objectList = this.zyfxObjectService.queryCatalogPageByFilter(nodeId, schemeId, groupType, favorite, inCart, isApplication, filterParam, sortParam, haveDetail, page, size);
            response.setRows(objectList.getRecords());
            response.setTotal(Long.valueOf(objectList.getTotal()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u76ee\u5f55\u8be6\u60c5\u63a5\u53e3")
    @RequestMapping(value={"/detail"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public DataResponse<ZyfxCatalogDetail> catalogDetail(HttpServletRequest request, @RequestParam(value="id") String id) {
        DataResponse detailDataResponse = new DataResponse();
        try {
            ZyfxCatalogDetail detail = this.zyfxCatalogService.queryCatalogDetail(id);
            detailDataResponse.setResult((Object)detail);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            detailDataResponse.markFailure(e.getMessage());
        }
        return detailDataResponse;
    }

    @ApiOperation(value="\u540c\u6b65\u8d44\u6e90\u76ee\u5f55")
    @PostMapping(value={"syncRscatalog"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse syncRscatalog(HttpServletRequest request, @RequestParam(value="schemeId") String schemeId, @RequestParam(value="catalogId") String catalogId, @RequestParam(value="groupType", required=false) Integer groupType) {
        BaseResponse response = new BaseResponse();
        try {
            this.syncRsCatalogService.syncRscatalog(catalogId, schemeId, groupType);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u540c\u6b65\u5e94\u7528\u76ee\u5f55")
    @PostMapping(value={"syncAPPcatalog"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse syncAPPcatalog(HttpServletRequest request, @RequestParam(value="schemeId") String schemeId, @RequestParam(value="catalogId") String catalogId, @RequestParam(value="groupType", required=false) Integer groupType) {
        BaseResponse response = new BaseResponse();
        try {
            this.syncRsCatalogService.syncAppCatalog(catalogId, schemeId, groupType);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u670d\u52a1\u5143\u6570\u636e\u76ee\u5f55\u6302\u63a5")
    @GetMapping(value={"bindMetadata"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse bindMetadata(HttpServletRequest request) {
        BaseResponse response = new BaseResponse();
        try {
            this.zyfxCatalogService.bindMetadata();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u6392\u5e8f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u76ee\u5f55id", required=true), @ApiImplicitParam(name="sortType", value="\u6392\u5e8f\u6761\u4ef6,\u91c7\u7528\u6570\u5b57(1.\u7f6e\u9876 2.\u4e0a\u79fb\u4e00\u4f4d  3.\u4e0b\u79fb\u4e00\u4f4d  4.\u7f6e\u5e95)", required=true), @ApiImplicitParam(name="dataId", value="\u6570\u636eid", required=false)})
    @RequestMapping(value={"/sort"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse sort(HttpServletRequest request, @RequestParam(value="id") String id, @RequestParam(value="sortType") Integer sortType, @RequestParam(value="dataId", required=false) String dataId) {
        BaseResponse response = new BaseResponse();
        try {
            if (StringUtils.isEmpty((String)dataId)) {
                this.zyfxCatalogService.sortCatalog(id, sortType);
            } else {
                this.zyfxCatalogService.sortData(id, sortType, dataId);
            }
        }
        catch (Exception ex) {
            return BaseResponse.buildFailuaResponse((Exception)ex);
        }
        return response;
    }

    @ApiOperation(value="\u5e94\u7528\u76ee\u5f55\u5bfc\u51fa")
    @GetMapping(value={"appCatalogExport"}, produces={"application/json;charset=UTF-8"})
    public void appCatalogExport(HttpServletRequest request, HttpServletResponse response) {
        try {
            Map<String, Object> appCatalogMap = this.zyfxCatalogService.appCatalogExport();
            XSSFWorkbook workbook = new XSSFWorkbook();
            for (String appkey : appCatalogMap.keySet()) {
                List appCatalog = (List)appCatalogMap.get(appkey);
                Sheet sheet = workbook.createSheet(appkey);
                Map firstRow = (Map)appCatalog.get(0);
                int columnIndex = 0;
                int rowIndex = 0;
                for (Map rowData : appCatalog) {
                    Row row = sheet.createRow(rowIndex++);
                    columnIndex = (Integer)rowData.get("level");
                    Cell cell = row.createCell(columnIndex++);
                    Object value = rowData.get("node_name");
                    cell.setCellValue(value.toString());
                    cell = row.createCell(columnIndex++);
                    value = rowData.get("path");
                    cell.setCellValue(value.toString());
                }
            }
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            LocalDateTime currentDateTime = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss");
            String formattedDateTime = currentDateTime.format(formatter);
            String fileName = URLEncoder.encode("\u5e94\u7528\u76ee\u5f55" + formattedDateTime + ".xlsx", "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName);
            ServletOutputStream outputStream = response.getOutputStream();
            workbook.write((OutputStream)outputStream);
            workbook.close();
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

