/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.controller;

import com.alibaba.fastjson.JSON;
import com.geoway.ns.sys.annotation.WhiteRequest;
import com.geoway.ns.sys.dto.BaseObjectResponse;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.sys.dto.FileUploadResponse;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.dto.UploadedFileInfo;
import com.geoway.ns.sys.dto.UploadingFileInfo;
import com.geoway.ns.sys.service.FileServerService;
import com.geoway.ns.sys.service.RedisLockService;
import com.geoway.ns.sys.service.impl.TokenServiceImpl;
import com.geoway.ns.sys.utils.MyRequestUtil;
import com.google.gson.Gson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6587\u4ef6\u4e0a\u4f20\uff08\u652f\u6301\u5206\u6bb5\u4e0a\u4f20\u80fd\u529b\uff09"})
@RestController
@RequestMapping(value={"fileupload"})
public class FileUploadController {
    private static final Logger log = LoggerFactory.getLogger(FileUploadController.class);
    @Resource
    private FileServerService fileServerService;
    @Autowired
    private TokenServiceImpl tokenService;
    @Autowired
    RedisLockService redisLockService;
    @Autowired
    private RedisTemplate redisTemplate;

    @WhiteRequest(value=true)
    @ApiOperation(value="\u83b7\u53d6ueditor\u53c2\u6570")
    @GetMapping(value={"/ueditor"})
    public String ueditorGet(@RequestParam Map<String, Object> params) {
        String callback = (String)params.get("callback");
        if (StringUtils.isNotEmpty((CharSequence)callback)) {
            return callback + "(" + "{\n    // \u6267\u884c\u4e0a\u4f20\u56fe\u7247\u7684action\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1auploadimage\n    \"imageActionName\": \"image\",\n    // \u63d0\u4ea4\u7684\u56fe\u7247\u8868\u5355\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1aupfile\n    \"imageFieldName\": \"file\",\n    // \u4e0a\u4f20\u5927\u5c0f\u9650\u5236\uff0c\u5355\u4f4dB\uff0c\u9ed8\u8ba4\u503c\uff1a2048000\n    \"imageMaxSize\": 10485760,\n    // \u4e0a\u4f20\u56fe\u7247\u683c\u5f0f\u663e\u793a\uff0c\u9ed8\u8ba4\u503c\uff1a[\".png\", \".jpg\", \".jpeg\", \".gif\", \".bmp\"]\n    \"imageAllowFiles\": [\n        \".jpg\",\n        \".png\",\n        \".jpeg\"\n    ],\n    // \u662f\u5426\u538b\u7f29\u56fe\u7247,\u9ed8\u8ba4\u662ftrue\n    \"imageCompressEnable\": true,\n    // \u56fe\u7247\u538b\u7f29\u6700\u957f\u8fb9\u9650\u5236\uff0c\u9ed8\u8ba4\u503c\uff1a1600\n    \"imageCompressBorder\": 5000,\n    // \u63d2\u5165\u7684\u56fe\u7247\u6d6e\u52a8\u65b9\u5f0f\uff0c\u9ed8\u8ba4\u503c\uff1anone\n    \"imageInsertAlign\": \"none\",\n    // \u56fe\u7247\u8bbf\u95ee\u8def\u5f84\u524d\u7f00\uff0c\u9ed8\u8ba4\u503c\uff1a\u7a7a\n    \"imageUrlPrefix\": \"\",\n    \n    // \u6267\u884c\u4e0a\u4f20\u6d82\u9e26\u7684action\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1auploadscrawl\n    \"scrawlActionName\": \"crawl\",\n    // \u63d0\u4ea4\u7684\u56fe\u7247\u8868\u5355\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1aupfile\n    \"scrawlFieldName\": \"base64File\",\n    // \u4e0a\u4f20\u5927\u5c0f\u9650\u5236\uff0c\u5355\u4f4dB\uff0c\u9ed8\u8ba4\u503c\uff1a2048000\n    \"scrawlMaxSize\": 10485760,\n    // \u56fe\u7247\u8bbf\u95ee\u8def\u5f84\u524d\u7f00\uff0c\u9ed8\u8ba4\u503c\uff1a\u7a7a\n    \"scrawlUrlPrefix\": \"\",\n    // \u63d2\u5165\u7684\u56fe\u7247\u6d6e\u52a8\u65b9\u5f0f\uff0c\u9ed8\u8ba4\u503c\uff1anone\n    \"scrawlInsertAlign\": \"none\",\n\n    // \u6267\u884c\u4e0a\u4f20\u622a\u56fe\u7684action\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1auploadimage\n    \"snapscreenActionName\": \"snap\",\n    // \u56fe\u7247\u8bbf\u95ee\u8def\u5f84\u524d\u7f00\n    \"snapscreenUrlPrefix\": \"\",\n    // \u63d2\u5165\u7684\u56fe\u7247\u6d6e\u52a8\u65b9\u5f0f\uff0c\u9ed8\u8ba4\u503c\uff1anone\n    \"snapscreenInsertAlign\": \"none\",\n    \n    // \u4f8b\u5916\u7684\u56fe\u7247\u6293\u53d6\u57df\u540d\n    \"catcherLocalDomain\": [\n        \"127.0.0.1\",\n        \"localhost\"\n    ],\n    // \u6267\u884c\u6293\u53d6\u8fdc\u7a0b\u56fe\u7247\u7684action\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1acatchimage\n    \"catcherActionName\": \"catch\",\n    // \u63d0\u4ea4\u7684\u56fe\u7247\u5217\u8868\u8868\u5355\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1asource\n    \"catcherFieldName\": \"source\",\n    // \u56fe\u7247\u8bbf\u95ee\u8def\u5f84\u524d\u7f00\uff0c\u9ed8\u8ba4\u503c\uff1a\u7a7a\n    \"catcherUrlPrefix\": \"\",\n    // \u4e0a\u4f20\u4fdd\u5b58\u8def\u5f84,\u53ef\u4ee5\u81ea\u5b9a\u4e49\u4fdd\u5b58\u8def\u5f84\u548c\u6587\u4ef6\u540d\u683c\u5f0f\uff0c\u9ed8\u8ba4\u503c\uff1a{filename}{rand:6}\n    \"catcherMaxSize\": 10485760,\n    // \u6293\u53d6\u56fe\u7247\u683c\u5f0f\u663e\u793a\uff0c\u9ed8\u8ba4\u503c\uff1a[\".png\", \".jpg\", \".jpeg\", \".gif\", \".bmp\"]\n    \"catcherAllowFiles\": [\n        \".jpg\",\n        \".png\",\n        \".jpeg\"\n    ],\n    \n    // \u6267\u884c\u4e0a\u4f20\u89c6\u9891\u7684action\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1auploadvideo\n    \"videoActionName\": \"video\",\n    // \u63d0\u4ea4\u7684\u89c6\u9891\u8868\u5355\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1aupfile\n    \"videoFieldName\": \"file\",\n    // \u89c6\u9891\u8bbf\u95ee\u8def\u5f84\u524d\u7f00\n    \"videoUrlPrefix\": \"\",\n    // \u4e0a\u4f20\u5927\u5c0f\u9650\u5236\uff0c\u5355\u4f4dB\uff0c\u9ed8\u8ba4\u503c\uff1a102400000\n    \"videoMaxSize\": 104857600,\n    // \u4e0a\u4f20\u89c6\u9891\u683c\u5f0f\u663e\u793a\n    \"videoAllowFiles\": [\n        \".mp4\"\n    ],\n\n    // \u6267\u884c\u4e0a\u4f20\u6587\u4ef6\u7684action\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1auploadfile\n    \"fileActionName\": \"file\",\n    // \u63d0\u4ea4\u7684\u6587\u4ef6\u8868\u5355\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1aupfile\n    \"fileFieldName\": \"file\",\n    // \u6587\u4ef6\u8bbf\u95ee\u8def\u5f84\u524d\u7f00\n    \"fileUrlPrefix\": \"\",\n    // \u4e0a\u4f20\u4fdd\u5b58\u8def\u5f84,\u53ef\u4ee5\u81ea\u5b9a\u4e49\u4fdd\u5b58\u8def\u5f84\u548c\u6587\u4ef6\u540d\u683c\u5f0f\uff0c\u9ed8\u8ba4\u503c\uff1a{filename}{rand:6}\n    \"fileMaxSize\": 104857600,\n    // \u4e0a\u4f20\u6587\u4ef6\u683c\u5f0f\u663e\u793a\n    \"fileAllowFiles\": [\n        \".zip\",\n        \".pdf\",\n        \".doc\",\n        \".docx\",\n        \".xlsx\",\n        \".xls\",\n        \".csv\"\n    ],\n\n    // \u6267\u884c\u56fe\u7247\u7ba1\u7406\u7684action\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1alistimage\n    \"imageManagerActionName\": \"listImage\",\n    // \u6bcf\u6b21\u5217\u51fa\u6587\u4ef6\u6570\u91cf\n    \"imageManagerListSize\": 20,\n    // \u56fe\u7247\u8bbf\u95ee\u8def\u5f84\u524d\u7f00\n    \"imageManagerUrlPrefix\": \"\",\n    // \u63d2\u5165\u7684\u56fe\u7247\u6d6e\u52a8\u65b9\u5f0f\uff0c\u9ed8\u8ba4\u503c\uff1anone\n    \"imageManagerInsertAlign\": \"none\",\n    // \u5217\u51fa\u7684\u6587\u4ef6\u7c7b\u578b\n    \"imageManagerAllowFiles\": [\n        \".jpg\",\n        \".png\",\n        \".jpeg\"\n    ],\n    \n    // \u6267\u884c\u6587\u4ef6\u7ba1\u7406\u7684action\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1alistfile\n    \"fileManagerActionName\": \"listFile\",\n    // \u6307\u5b9a\u8981\u5217\u51fa\u6587\u4ef6\u7684\u76ee\u5f55\n    \"fileManagerUrlPrefix\": \"\",\n    // \u6bcf\u6b21\u5217\u51fa\u6587\u4ef6\u6570\u91cf\n    \"fileManagerListSize\": 20,\n    // \u5217\u51fa\u7684\u6587\u4ef6\u7c7b\u578b\n    \"fileManagerAllowFiles\": [\n        \".zip\",\n        \".pdf\",\n        \".doc\",\n        \".docx\",\n        \".xlsx\",\n        \".xls\",\n        \".csv\"\n    ],\n    \n    // \u6267\u884c\u4e0a\u4f20\u97f3\u9891\u7684action\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1auploadaudio\n    \"audioActionName\": \"audio\",\n    // \u63d0\u4ea4\u7684\u89c6\u9891\u8868\u5355\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1aupfile\n    \"audioFieldName\": \"file\",\n    // \u89c6\u9891\u8bbf\u95ee\u8def\u5f84\u524d\u7f00\n    \"audioUrlPrefix\": \"\",\n    // \u4e0a\u4f20\u5927\u5c0f\u9650\u5236\uff0c\u5355\u4f4dB\uff0c\u9ed8\u8ba4\u503c\uff1a102400000\n    \"audioMaxSize\": 104857600,\n    // \u4e0a\u4f20\u89c6\u9891\u683c\u5f0f\u663e\u793a\n    \"audioAllowFiles\": [\n        \".mp3\"\n    ],\n    \n    // \u516c\u5f0f\u914d\u7f6e\n    \"formulaConfig\": {\n        // \u516c\u5f0f\u6e32\u67d3\u7684\u8def\u5f84\n        \"imageUrlTemplate\": \"https://latex.codecogs.com/svg.image?{}\"\n    }\n}" + ")";
        }
        return "{\n    // \u6267\u884c\u4e0a\u4f20\u56fe\u7247\u7684action\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1auploadimage\n    \"imageActionName\": \"image\",\n    // \u63d0\u4ea4\u7684\u56fe\u7247\u8868\u5355\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1aupfile\n    \"imageFieldName\": \"file\",\n    // \u4e0a\u4f20\u5927\u5c0f\u9650\u5236\uff0c\u5355\u4f4dB\uff0c\u9ed8\u8ba4\u503c\uff1a2048000\n    \"imageMaxSize\": 10485760,\n    // \u4e0a\u4f20\u56fe\u7247\u683c\u5f0f\u663e\u793a\uff0c\u9ed8\u8ba4\u503c\uff1a[\".png\", \".jpg\", \".jpeg\", \".gif\", \".bmp\"]\n    \"imageAllowFiles\": [\n        \".jpg\",\n        \".png\",\n        \".jpeg\"\n    ],\n    // \u662f\u5426\u538b\u7f29\u56fe\u7247,\u9ed8\u8ba4\u662ftrue\n    \"imageCompressEnable\": true,\n    // \u56fe\u7247\u538b\u7f29\u6700\u957f\u8fb9\u9650\u5236\uff0c\u9ed8\u8ba4\u503c\uff1a1600\n    \"imageCompressBorder\": 5000,\n    // \u63d2\u5165\u7684\u56fe\u7247\u6d6e\u52a8\u65b9\u5f0f\uff0c\u9ed8\u8ba4\u503c\uff1anone\n    \"imageInsertAlign\": \"none\",\n    // \u56fe\u7247\u8bbf\u95ee\u8def\u5f84\u524d\u7f00\uff0c\u9ed8\u8ba4\u503c\uff1a\u7a7a\n    \"imageUrlPrefix\": \"\",\n    \n    // \u6267\u884c\u4e0a\u4f20\u6d82\u9e26\u7684action\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1auploadscrawl\n    \"scrawlActionName\": \"crawl\",\n    // \u63d0\u4ea4\u7684\u56fe\u7247\u8868\u5355\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1aupfile\n    \"scrawlFieldName\": \"base64File\",\n    // \u4e0a\u4f20\u5927\u5c0f\u9650\u5236\uff0c\u5355\u4f4dB\uff0c\u9ed8\u8ba4\u503c\uff1a2048000\n    \"scrawlMaxSize\": 10485760,\n    // \u56fe\u7247\u8bbf\u95ee\u8def\u5f84\u524d\u7f00\uff0c\u9ed8\u8ba4\u503c\uff1a\u7a7a\n    \"scrawlUrlPrefix\": \"\",\n    // \u63d2\u5165\u7684\u56fe\u7247\u6d6e\u52a8\u65b9\u5f0f\uff0c\u9ed8\u8ba4\u503c\uff1anone\n    \"scrawlInsertAlign\": \"none\",\n\n    // \u6267\u884c\u4e0a\u4f20\u622a\u56fe\u7684action\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1auploadimage\n    \"snapscreenActionName\": \"snap\",\n    // \u56fe\u7247\u8bbf\u95ee\u8def\u5f84\u524d\u7f00\n    \"snapscreenUrlPrefix\": \"\",\n    // \u63d2\u5165\u7684\u56fe\u7247\u6d6e\u52a8\u65b9\u5f0f\uff0c\u9ed8\u8ba4\u503c\uff1anone\n    \"snapscreenInsertAlign\": \"none\",\n    \n    // \u4f8b\u5916\u7684\u56fe\u7247\u6293\u53d6\u57df\u540d\n    \"catcherLocalDomain\": [\n        \"127.0.0.1\",\n        \"localhost\"\n    ],\n    // \u6267\u884c\u6293\u53d6\u8fdc\u7a0b\u56fe\u7247\u7684action\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1acatchimage\n    \"catcherActionName\": \"catch\",\n    // \u63d0\u4ea4\u7684\u56fe\u7247\u5217\u8868\u8868\u5355\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1asource\n    \"catcherFieldName\": \"source\",\n    // \u56fe\u7247\u8bbf\u95ee\u8def\u5f84\u524d\u7f00\uff0c\u9ed8\u8ba4\u503c\uff1a\u7a7a\n    \"catcherUrlPrefix\": \"\",\n    // \u4e0a\u4f20\u4fdd\u5b58\u8def\u5f84,\u53ef\u4ee5\u81ea\u5b9a\u4e49\u4fdd\u5b58\u8def\u5f84\u548c\u6587\u4ef6\u540d\u683c\u5f0f\uff0c\u9ed8\u8ba4\u503c\uff1a{filename}{rand:6}\n    \"catcherMaxSize\": 10485760,\n    // \u6293\u53d6\u56fe\u7247\u683c\u5f0f\u663e\u793a\uff0c\u9ed8\u8ba4\u503c\uff1a[\".png\", \".jpg\", \".jpeg\", \".gif\", \".bmp\"]\n    \"catcherAllowFiles\": [\n        \".jpg\",\n        \".png\",\n        \".jpeg\"\n    ],\n    \n    // \u6267\u884c\u4e0a\u4f20\u89c6\u9891\u7684action\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1auploadvideo\n    \"videoActionName\": \"video\",\n    // \u63d0\u4ea4\u7684\u89c6\u9891\u8868\u5355\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1aupfile\n    \"videoFieldName\": \"file\",\n    // \u89c6\u9891\u8bbf\u95ee\u8def\u5f84\u524d\u7f00\n    \"videoUrlPrefix\": \"\",\n    // \u4e0a\u4f20\u5927\u5c0f\u9650\u5236\uff0c\u5355\u4f4dB\uff0c\u9ed8\u8ba4\u503c\uff1a102400000\n    \"videoMaxSize\": 104857600,\n    // \u4e0a\u4f20\u89c6\u9891\u683c\u5f0f\u663e\u793a\n    \"videoAllowFiles\": [\n        \".mp4\"\n    ],\n\n    // \u6267\u884c\u4e0a\u4f20\u6587\u4ef6\u7684action\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1auploadfile\n    \"fileActionName\": \"file\",\n    // \u63d0\u4ea4\u7684\u6587\u4ef6\u8868\u5355\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1aupfile\n    \"fileFieldName\": \"file\",\n    // \u6587\u4ef6\u8bbf\u95ee\u8def\u5f84\u524d\u7f00\n    \"fileUrlPrefix\": \"\",\n    // \u4e0a\u4f20\u4fdd\u5b58\u8def\u5f84,\u53ef\u4ee5\u81ea\u5b9a\u4e49\u4fdd\u5b58\u8def\u5f84\u548c\u6587\u4ef6\u540d\u683c\u5f0f\uff0c\u9ed8\u8ba4\u503c\uff1a{filename}{rand:6}\n    \"fileMaxSize\": 104857600,\n    // \u4e0a\u4f20\u6587\u4ef6\u683c\u5f0f\u663e\u793a\n    \"fileAllowFiles\": [\n        \".zip\",\n        \".pdf\",\n        \".doc\",\n        \".docx\",\n        \".xlsx\",\n        \".xls\",\n        \".csv\"\n    ],\n\n    // \u6267\u884c\u56fe\u7247\u7ba1\u7406\u7684action\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1alistimage\n    \"imageManagerActionName\": \"listImage\",\n    // \u6bcf\u6b21\u5217\u51fa\u6587\u4ef6\u6570\u91cf\n    \"imageManagerListSize\": 20,\n    // \u56fe\u7247\u8bbf\u95ee\u8def\u5f84\u524d\u7f00\n    \"imageManagerUrlPrefix\": \"\",\n    // \u63d2\u5165\u7684\u56fe\u7247\u6d6e\u52a8\u65b9\u5f0f\uff0c\u9ed8\u8ba4\u503c\uff1anone\n    \"imageManagerInsertAlign\": \"none\",\n    // \u5217\u51fa\u7684\u6587\u4ef6\u7c7b\u578b\n    \"imageManagerAllowFiles\": [\n        \".jpg\",\n        \".png\",\n        \".jpeg\"\n    ],\n    \n    // \u6267\u884c\u6587\u4ef6\u7ba1\u7406\u7684action\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1alistfile\n    \"fileManagerActionName\": \"listFile\",\n    // \u6307\u5b9a\u8981\u5217\u51fa\u6587\u4ef6\u7684\u76ee\u5f55\n    \"fileManagerUrlPrefix\": \"\",\n    // \u6bcf\u6b21\u5217\u51fa\u6587\u4ef6\u6570\u91cf\n    \"fileManagerListSize\": 20,\n    // \u5217\u51fa\u7684\u6587\u4ef6\u7c7b\u578b\n    \"fileManagerAllowFiles\": [\n        \".zip\",\n        \".pdf\",\n        \".doc\",\n        \".docx\",\n        \".xlsx\",\n        \".xls\",\n        \".csv\"\n    ],\n    \n    // \u6267\u884c\u4e0a\u4f20\u97f3\u9891\u7684action\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1auploadaudio\n    \"audioActionName\": \"audio\",\n    // \u63d0\u4ea4\u7684\u89c6\u9891\u8868\u5355\u540d\u79f0\uff0c\u9ed8\u8ba4\u503c\uff1aupfile\n    \"audioFieldName\": \"file\",\n    // \u89c6\u9891\u8bbf\u95ee\u8def\u5f84\u524d\u7f00\n    \"audioUrlPrefix\": \"\",\n    // \u4e0a\u4f20\u5927\u5c0f\u9650\u5236\uff0c\u5355\u4f4dB\uff0c\u9ed8\u8ba4\u503c\uff1a102400000\n    \"audioMaxSize\": 104857600,\n    // \u4e0a\u4f20\u89c6\u9891\u683c\u5f0f\u663e\u793a\n    \"audioAllowFiles\": [\n        \".mp3\"\n    ],\n    \n    // \u516c\u5f0f\u914d\u7f6e\n    \"formulaConfig\": {\n        // \u516c\u5f0f\u6e32\u67d3\u7684\u8def\u5f84\n        \"imageUrlTemplate\": \"https://latex.codecogs.com/svg.image?{}\"\n    }\n}";
    }

    @PostMapping(value={"/ueditor"})
    public Map<String, String> ueditorPost(@RequestParam Map<String, Object> params, @RequestParam(value="file", required=false) MultipartFile multipartFile, @RequestParam(value="action") String action, @RequestParam(value="base64File", required=false) String base64File) {
        if (multipartFile == null && StringUtils.isEmpty((CharSequence)base64File) && ("image".equalsIgnoreCase(action) || "crawl".equalsIgnoreCase(action) || "snap".equalsIgnoreCase(action) || "catch".equalsIgnoreCase(action) || "video".equalsIgnoreCase(action) || "file".equalsIgnoreCase(action) || "audio".equalsIgnoreCase(action))) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("state", "FAILURE");
            map.put("message", "\u6ca1\u6709\u68c0\u6d4b\u5230\u9700\u54df\u4e0a\u4f20\u7684\u6570\u636e");
            return map;
        }
        String name = (String)params.get("name");
        String type = (String)params.get("type");
        String size = (String)params.get("size");
        try {
            FileServerResponse fileServerResponse = null;
            HashMap<String, String> map = new HashMap<String, String>();
            if (multipartFile != null) {
                String contentType = multipartFile.getContentType();
                fileServerResponse = this.fileServerService.sendFileToServer(multipartFile, contentType.toLowerCase().contains("image"));
                map.put("original", multipartFile.getOriginalFilename());
                map.put("title", name);
                map.put("type", type);
                map.put("size", size);
            } else {
                byte[] data = Base64Utils.decodeFromString((String)base64File);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
                fileServerResponse = this.fileServerService.sendFileToServerByStream((InputStream)byteArrayInputStream, null, "image/png");
                map.put("original", "\u6d82\u9e26\u56fe\u7247");
                map.put("title", "\u6d82\u9e26\u56fe\u7247");
                map.put("type", "image");
                map.put("size", data.length + "");
            }
            map.put("state", "SUCCESS");
            map.put("url", fileServerResponse.getViewURL());
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("state", "FAILURE");
            map.put("message", e.getMessage());
            return map;
        }
    }

    @ApiOperation(value="\u7b80\u5355\u6587\u4ef6\u4e0a\u4f20")
    @PostMapping(value={"/uploadFile"})
    public BaseResponse uploadFile(@RequestParam(value="file") MultipartFile multipartFile) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            String contentType = multipartFile.getContentType();
            System.out.println("\u6587\u4ef6\u7c7b\u578b\uff08MIME\u7c7b\u578b\uff09: " + contentType);
            FileServerResponse fileServerResponse = this.fileServerService.sendFileToServer(multipartFile, contentType.toLowerCase().contains("image"));
            response.setData((Object)fileServerResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseObjectResponse.buildFailuaResponse((String)e.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/upLoadFileByChunk"})
    public BaseResponse upLoadFileByChunk(HttpServletRequest request, @RequestParam(value="chunk") MultipartFile chunk, @RequestParam(value="filename") String fileName, @RequestParam(value="originalFileName") String originalFileName, @RequestParam(value="md5") String md5, @RequestParam(value="chunkIndex") Integer chunkIndex, @RequestParam(value="chunkCount") Integer chunkCount, @RequestParam(value="chunkSize") Long chunkSize, @RequestParam(value="fileSize") Long fileSize, @RequestParam(value="isParallel") Boolean isParallel) {
        BaseResponse response = new BaseResponse();
        try {
            String uploadInfoOldStr = (String)this.redisTemplate.opsForHash().get((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName));
            UploadingFileInfo uploadingFileInfo = new UploadingFileInfo();
            if (StringUtils.isNotEmpty((CharSequence)uploadInfoOldStr)) {
                Gson gson = new Gson();
                uploadingFileInfo = (UploadingFileInfo)gson.fromJson(uploadInfoOldStr, UploadingFileInfo.class);
            }
            uploadingFileInfo.setIsParallelParallel(isParallel);
            uploadingFileInfo.setFileName(fileName);
            uploadingFileInfo.setOriginalFileName(originalFileName);
            uploadingFileInfo.setMd5(md5);
            uploadingFileInfo.setChunkIndex(chunkIndex);
            uploadingFileInfo.setChunkCount(chunkCount);
            uploadingFileInfo.setChunkSize(chunkSize);
            uploadingFileInfo.setFileSize(fileSize);
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            String code = "010001001";
            if (sysUser != null && StringUtils.isNotEmpty((CharSequence)sysUser.getXzqdm())) {
                code = sysUser.getXzqdm();
            }
            this.fileServerService.upLoadFileByChunk(code, originalFileName, chunk, uploadingFileInfo, isParallel);
            response.setMessage("\u5206\u7247\u4e0a\u4f20\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.redisLockService.unlock("UploadingFilesMD5" + md5, chunkIndex + "");
            return BaseResponse.buildFailuaResponse((String)e.getMessage(), (Integer)500);
        }
        return response;
    }

    @GetMapping(value={"/upLoadFileCompleteWithMerge"})
    public BaseResponse upLoadFileCompleteWithMerge(@RequestParam(value="filename") String fileName, @RequestParam(value="originalFileName") String originalFileName, @RequestParam(value="md5") String md5) {
        BaseObjectResponse response = new BaseObjectResponse();
        String uploadInfoOldStr = (String)this.redisTemplate.opsForHash().get((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName));
        try {
            Gson gson;
            UploadingFileInfo uploadInfoOld;
            if (StringUtils.isNotEmpty((CharSequence)uploadInfoOldStr) && (uploadInfoOld = (UploadingFileInfo)(gson = new Gson()).fromJson(uploadInfoOldStr, UploadingFileInfo.class)) != null) {
                FileUploadResponse fileUploadResponse = this.fileServerService.upLoadFileCompleteWithMerge(uploadInfoOld);
                if (StringUtils.isNotEmpty((CharSequence)originalFileName)) {
                    UploadedFileInfo uploadInfo = new UploadedFileInfo();
                    uploadInfo.setMd5(md5);
                    uploadInfo.setFileSize(uploadInfoOld.getFileSize());
                    uploadInfo.setOriginalFileName(originalFileName);
                    uploadInfo.setFileurl(fileUploadResponse.getObjectUrl());
                    uploadInfo.setFileInfo(fileUploadResponse);
                    this.redisTemplate.opsForHash().put((Object)"UploadedFilesMD5", (Object)(md5 + "=" + originalFileName), (Object)gson.toJson((Object)uploadInfo));
                    this.redisTemplate.opsForHash().delete((Object)"UploadingFilesMD5", new Object[]{md5 + "=" + originalFileName});
                }
                response.setData((Object)fileUploadResponse);
            }
            response.setMessage("\u6570\u636e\u4e0a\u4f20\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @GetMapping(value={"/upLoadFileWithBeforeCheck"})
    public BaseResponse upLoadFileWithBeforeCheck(@RequestParam(value="md5") String md5, @RequestParam(value="originalFileName") String originalFileName) {
        BaseObjectResponse baseObjectResponse = new BaseObjectResponse();
        if (!this.redisTemplate.opsForHash().hasKey((Object)"UploadedFilesMD5", (Object)(md5 + "=" + originalFileName)).booleanValue()) {
            if (this.redisTemplate.opsForHash().hasKey((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName)).booleanValue()) {
                String uploadInfoString = (String)this.redisTemplate.opsForHash().get((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName));
                BaseObjectResponse objectResponse = new BaseObjectResponse();
                objectResponse.setData((Object)JSON.parseObject((String)uploadInfoString));
                objectResponse.setCode(Integer.valueOf(100));
                return objectResponse;
            }
            return BaseResponse.buildFailuaResponse((String)"\u670d\u52a1\u7aef\u4e0d\u5b58\u5728\u8be5\u6587\u4ef6", (Integer)404);
        }
        String uploadInfoOldStr = (String)this.redisTemplate.opsForHash().get((Object)"UploadedFilesMD5", (Object)(md5 + "=" + originalFileName));
        Gson gson = new Gson();
        UploadedFileInfo uploadInfoOld = (UploadedFileInfo)gson.fromJson(uploadInfoOldStr, UploadedFileInfo.class);
        if (StringUtils.isNotEmpty((CharSequence)md5) && md5.equalsIgnoreCase(uploadInfoOld.getMd5())) {
            baseObjectResponse.setData((Object)uploadInfoOld);
            baseObjectResponse.setMessage("\u670d\u52a1\u7aef\u5df2\u7ecf\u5b58\u5728\u8be5\u6587\u4ef6\uff01");
            return baseObjectResponse;
        }
        return BaseResponse.buildFailuaResponse((String)"\u670d\u52a1\u7aef\u4e0d\u5b58\u5728\u8be5\u6587\u4ef6", (Integer)404);
    }

    @GetMapping(value={"/listUpLoadFileParts"})
    public BaseResponse listUpLoadFileParts(@RequestParam(value="originalFileName") String originalFileName, @RequestParam(value="md5") String md5) {
        BaseObjectResponse response = new BaseObjectResponse();
        String uploadInfoOldStr = (String)this.redisTemplate.opsForHash().get((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName));
        try {
            Gson gson;
            UploadingFileInfo uploadInfoOld;
            if (StringUtils.isNotEmpty((CharSequence)uploadInfoOldStr) && (uploadInfoOld = (UploadingFileInfo)(gson = new Gson()).fromJson(uploadInfoOldStr, UploadingFileInfo.class)) != null) {
                List list = this.fileServerService.listUpLoadFileParts(uploadInfoOld);
                response.setData((Object)list);
            }
            response.setMessage("\u8bf7\u6c42\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @GetMapping(value={"/listUpLoadFileTasks"})
    public BaseResponse listUpLoadFileTasks() {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            List list = this.fileServerService.listUpLoadFileTasks();
            response.setData((Object)list);
            response.setMessage("\u8bf7\u6c42\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @GetMapping(value={"/cancelUploadFile"})
    public BaseResponse cancelUploadFile(@RequestParam(value="originalFileName") String originalFileName, @RequestParam(value="md5") String md5) {
        BaseObjectResponse response = new BaseObjectResponse();
        String uploadInfoOldStr = (String)this.redisTemplate.opsForHash().get((Object)"UploadingFilesMD5", (Object)(md5 + "=" + originalFileName));
        try {
            Gson gson;
            UploadingFileInfo uploadInfoOld;
            if (StringUtils.isNotEmpty((CharSequence)uploadInfoOldStr) && (uploadInfoOld = (UploadingFileInfo)(gson = new Gson()).fromJson(uploadInfoOldStr, UploadingFileInfo.class)) != null) {
                BaseResponse baseResponse = this.fileServerService.abortMultipartUpload(uploadInfoOld);
                if (baseResponse.getCode() == 200) {
                    this.redisTemplate.opsForHash().delete((Object)"UploadingFilesMD5", new Object[]{md5 + "=" + originalFileName});
                }
                return baseResponse;
            }
            return BaseResponse.buildFailuaResponse((String)"\u53d6\u6d88\u4efb\u52a1\u4e0a\u4f20\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMessage(e.getMessage());
            return response;
        }
    }

    @GetMapping(value={"/cancelUploadFile1"})
    public BaseResponse cancelUploadFile1(@RequestParam(value="objectKey") String objectKey, @RequestParam(value="uploadId") String uploadId) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            return this.fileServerService.abortMultipartUpload(objectKey, uploadId);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setMessage(e.getMessage());
            return response;
        }
    }
}

