/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.zyfx.constant.submitcenter.EnumConcurrentTaskType;
import com.geoway.ns.zyfx.domain.ConcurrentCheck;
import com.geoway.ns.zyfx.domain.ConcurrentTask;
import com.geoway.ns.zyfx.mapper.ConcurrentTaskMapper;
import com.geoway.ns.zyfx.service.ConcurrentTaskService;
import com.geoway.ns.zyfx.service.ConcurrentTemplatesService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ConcurrentTaskServiceImpl
extends ServiceImpl<ConcurrentTaskMapper, ConcurrentTask>
implements ConcurrentTaskService {
    @Resource
    private ConcurrentTemplatesService concurrentTemplatesService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<ConcurrentCheck> addConcurrentTask(ConcurrentTask concurrentTask) throws Exception {
        this.judgeSameName(concurrentTask);
        this.save(concurrentTask);
        List<ConcurrentCheck> concurrentCheckList = new ArrayList<ConcurrentCheck>();
        if (concurrentTask.getConcurrentType() == EnumConcurrentTaskType.Initiative.value) {
            ConcurrentCheck concurrentCheck = ConcurrentCheck.builder().taskReceiver(concurrentTask.getTaskPublisher()).taskReceiverId(concurrentTask.getTaskPublisherId()).build();
            concurrentCheckList.add(concurrentCheck);
            if (StrUtil.isNotBlank((CharSequence)concurrentTask.getConcurrentDataUrl()) && StrUtil.isNotBlank((CharSequence)concurrentTask.getConcurrentDataStructureTree())) {
                concurrentCheck.setConcurrentDataUrl(concurrentTask.getConcurrentDataUrl());
                concurrentCheck.setConcurrentDataStructureTree(concurrentTask.getConcurrentDataStructureTree());
                concurrentCheck.setConcurrentCount(1);
                concurrentCheck.setConcurrentTime(concurrentTask.getCreateTime());
            }
        } else if (concurrentTask.getConcurrentType() == EnumConcurrentTaskType.Passive.value) {
            if (StrUtil.isBlank((CharSequence)concurrentTask.getTaskReceiverList())) {
                throw new Exception("\u4efb\u52a1\u63a5\u6536\u4eba\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\uff01");
            }
            try {
                concurrentCheckList = JSON.parseArray((String)concurrentTask.getTaskReceiverList(), ConcurrentCheck.class);
            }
            catch (Exception e) {
                throw new Exception("\u4efb\u52a1\u63a5\u6536\u4eba\u6570\u636e\u683c\u5f0f\u4e0d\u4e89\u53d6\uff0c\u8bf7\u786e\u8ba4\uff01");
            }
        }
        return concurrentCheckList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<String> deleteConcurrentTask(ConcurrentTask concurrentTask) throws Exception {
        if (StrUtil.isBlank((CharSequence)concurrentTask.getId())) {
            throw new Exception("\u6c47\u4ea4\u4efb\u52a1id\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        List<String> idList = Arrays.asList(concurrentTask.getId().split(","));
        this.removeByIds(idList);
        return idList;
    }

    @Override
    public FileServerResponse uploadFile(MultipartFile multipartFile) throws Exception {
        FileServerResponse fileUploadResponse = this.concurrentTemplatesService.uploadFile(multipartFile);
        if (ObjectUtil.isEmpty((Object)fileUploadResponse.getTreeList())) {
            throw new Exception("\u6c47\u4ea4\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return fileUploadResponse;
    }

    @Override
    public IPage<ConcurrentTask> queryConcurrentTaskPage(ConcurrentTask concurrentTask) throws Exception {
        if (ObjectUtil.isEmpty((Object)concurrentTask.getRows()) || ObjectUtil.isEmpty((Object)concurrentTask.getPage())) {
            throw new Exception("\u5206\u9875\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        Page concurrentTaskPage = new Page((long)concurrentTask.getPage().intValue(), (long)concurrentTask.getRows().intValue());
        return ((ConcurrentTaskMapper)this.baseMapper).queryConcurrentTaskPage((Page<ConcurrentTask>)concurrentTaskPage, concurrentTask);
    }

    public void judgeSameName(ConcurrentTask concurrentTask) throws Exception {
        long countRule;
        if (StrUtil.isBlank((CharSequence)concurrentTask.getName())) {
            throw new Exception("\u6c47\u4ea4\u4efb\u52a1\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        if (ObjectUtil.isEmpty((Object)concurrentTask.getConcurrentType())) {
            throw new Exception("\u6c47\u4ea4\u4efb\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        if (concurrentTask.getConcurrentType() == 1 && StrUtil.isBlank((CharSequence)concurrentTask.getTemplatesId())) {
            throw new Exception("\u6c47\u4ea4\u4efb\u52a1\u6a21\u677f\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        if (StrUtil.isBlank((CharSequence)concurrentTask.getDataReceiver()) || StrUtil.isBlank((CharSequence)concurrentTask.getDataReceiverId())) {
            throw new Exception("\u6570\u636e\u63a5\u6536\u4eba\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        if (StrUtil.isBlank((CharSequence)concurrentTask.getTelephone())) {
            throw new Exception("\u6570\u636e\u63a5\u6536\u4eba\u7535\u8bdd\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        if (ObjectUtil.isEmpty((Object)concurrentTask.getConcurrentMode())) {
            throw new Exception("\u6c47\u4ea4\u4efb\u52a1\u6a21\u5f0f\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
        QueryWrapper concurrentTaskQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)concurrentTaskQueryWrapper.lambda().eq(ConcurrentTask::getName, (Object)concurrentTask.getName())).eq(ConcurrentTask::getConcurrentType, (Object)concurrentTask.getConcurrentType());
        if (StrUtil.isNotBlank((CharSequence)concurrentTask.getTemplatesId()) && concurrentTask.getConcurrentType() == 1) {
            concurrentTaskQueryWrapper.lambda().eq(ConcurrentTask::getTemplatesId, (Object)concurrentTask.getTemplatesId());
        }
        if (StrUtil.isNotBlank((CharSequence)concurrentTask.getId())) {
            concurrentTaskQueryWrapper.lambda().ne(ConcurrentTask::getId, (Object)concurrentTask.getId());
        }
        if ((countRule = this.count((Wrapper)concurrentTaskQueryWrapper)) > 0L) {
            throw new Exception("\u65b0\u5efa\u5931\u8d25\uff1a\u5b58\u5728\u540c\u540d\u6570\u636e\u6c47\u4ea4\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
    }
}

