/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.flowable.listener;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.adf.gbpm.flow.entity.GbpmTbTaskComment;
import com.geoway.ns.flowable.service.ShareFlowService;
import com.geoway.ns.proxy.dto.ProxyObjectLimit;
import com.geoway.ns.zyfx.domain.ZyfxApplyOrder;
import com.geoway.ns.zyfx.domain.ZyfxObjectApply;
import com.geoway.ns.zyfx.domain.ZyfxObjectApproval;
import com.geoway.ns.zyfx.service.ZyfxApplyOrderService;
import com.geoway.ns.zyfx.service.ZyfxObjectApplyService;
import com.geoway.ns.zyfx.utils.ObjectUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEntityEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventListener;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.runtime.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ProcessCompleteListener
implements FlowableEventListener {
    private static final Logger log = LoggerFactory.getLogger(ProcessCompleteListener.class);
    @Resource
    private ZyfxApplyOrderService zyfxApplyOrderService;
    @Autowired
    private ZyfxObjectApplyService applyService;
    @Lazy
    @Autowired
    private ShareFlowService shareFlowService;
    @Lazy
    @Autowired
    private RuntimeService runtimeService;

    public void onEvent(FlowableEvent event) {
        log.info("===== ProcessCompleteListener \u6536\u5230\u4e8b\u4ef6 ===== \u4e8b\u4ef6\u7c7b\u578b: {}", (Object)event.getType());
        if (event.getType() != FlowableEngineEventType.PROCESS_COMPLETED) {
            log.debug("\u5ffd\u7565\u975e\u6d41\u7a0b\u5b8c\u6210\u4e8b\u4ef6: {}", (Object)event.getType());
            return;
        }
        log.info("===== \u5f00\u59cb\u5904\u7406\u6d41\u7a0b\u5b8c\u6210\u4e8b\u4ef6 ===== \u7ebf\u7a0b: {}", (Object)Thread.currentThread().getName());
        try {
            if (event instanceof FlowableEngineEntityEvent) {
                FlowableEngineEntityEvent entityEvent = (FlowableEngineEntityEvent)event;
                Object entity = entityEvent.getEntity();
                log.info("\u4e8b\u4ef6\u5b9e\u4f53\u7c7b\u578b: {}", (Object)(entity != null ? entity.getClass().getName() : "null"));
                if (entity instanceof ProcessInstance) {
                    ProcessInstance processInstance = (ProcessInstance)entity;
                    String businessKey = processInstance.getBusinessKey();
                    log.info("===== \u6d41\u7a0b\u5b8c\u6210\u56de\u8c03\u89e6\u53d1 ===== \n  \u6d41\u7a0b\u5b9e\u4f8bID: {}\n  \u4e1a\u52a1Key: {}\n  \u6d41\u7a0b\u5b9a\u4e49ID: {}\n  \u6d41\u7a0b\u5b9a\u4e49Key: {}\n  \u6d41\u7a0b\u540d\u79f0: {}", new Object[]{processInstance.getId(), businessKey, processInstance.getProcessDefinitionId(), processInstance.getProcessDefinitionKey(), processInstance.getName()});
                    this.handleProcessComplete(businessKey, processInstance);
                    log.info("===== \u6d41\u7a0b\u5b8c\u6210\u56de\u8c03\u5904\u7406\u6210\u529f ===== \u4e1a\u52a1Key: {}", (Object)businessKey);
                } else {
                    log.warn("\u4e8b\u4ef6\u5b9e\u4f53\u4e0d\u662f ProcessInstance \u7c7b\u578b: {}", entity != null ? entity.getClass() : "null");
                }
            } else {
                log.warn("\u4e8b\u4ef6\u4e0d\u662f FlowableEngineEntityEvent \u7c7b\u578b: {}", event.getClass());
            }
        }
        catch (Exception e) {
            log.error("===== \u5904\u7406\u6d41\u7a0b\u5b8c\u6210\u4e8b\u4ef6\u5931\u8d25 =====", (Throwable)e);
        }
    }

    private void handleProcessComplete(String businessKey, ProcessInstance processInstance) {
        try {
            ProxyObjectLimit proxyObjectLimit = this.restoreProxyObjectLimit(processInstance.getId());
            ZyfxObjectApply zyfxObjectApply = (ZyfxObjectApply)this.applyService.getById((Serializable)((Object)businessKey));
            if (zyfxObjectApply != null) {
                List allApplies;
                List<GbpmTbTaskComment> comments = this.shareFlowService.getProcessAuditRecords(businessKey);
                GbpmTbTaskComment gbpmTbTaskComment = comments.get(comments.size() - 1);
                Integer checkstatus = 2;
                zyfxObjectApply.setCheckstatus(checkstatus);
                log.info("\u8bbe\u7f6e checkstatus={} - \u7533\u8bf7ID: {}", (Object)checkstatus, (Object)zyfxObjectApply.getId());
                if (zyfxObjectApply.getApprovals() == null || zyfxObjectApply.getApprovals().size() == 0) {
                    final ZyfxObjectApproval zyfxObjectApproval = new ZyfxObjectApproval();
                    zyfxObjectApproval.setObjectid(zyfxObjectApply.getId());
                    zyfxObjectApproval.setCheckstatus(checkstatus + "");
                    zyfxObjectApproval.setCheckuserid(gbpmTbTaskComment.getAssignee());
                    zyfxObjectApproval.setCheckusername(gbpmTbTaskComment.getAssigneeName());
                    zyfxObjectApproval.setComment(gbpmTbTaskComment.getComment());
                    zyfxObjectApproval.setObjectname(zyfxObjectApply.getObjectname());
                    zyfxObjectApproval.setCreatetime(LocalDateTime.now());
                    zyfxObjectApproval.setUpdatetime(LocalDateTime.now());
                    zyfxObjectApply.setApprovals((List<ZyfxObjectApproval>)new ArrayList<ZyfxObjectApproval>(){
                        {
                            this.add(zyfxObjectApproval);
                        }
                    });
                }
                log.info("\u6d41\u7a0b\u5b8c\u6210\uff0c\u8fd8\u539f\u7684 ProxyObjectLimit: ipScope={}, expiretime={}, frequency={}, extension={}, xzqlimit={}", new Object[]{proxyObjectLimit != null ? proxyObjectLimit.getIpScope() : null, proxyObjectLimit != null ? proxyObjectLimit.getExpiretime() : null, proxyObjectLimit != null ? proxyObjectLimit.getFrequency() : null, proxyObjectLimit != null ? proxyObjectLimit.getExtension() : null, proxyObjectLimit != null ? proxyObjectLimit.getXzqlimit() : null});
                log.info("\u8c03\u7528 check() \u65b9\u6cd5\u524d checkstatus={}", (Object)zyfxObjectApply.getCheckstatus());
                this.applyService.check(zyfxObjectApply, proxyObjectLimit);
                ZyfxObjectApply savedApply = (ZyfxObjectApply)this.applyService.getById((Serializable)((Object)businessKey));
                log.info("\u8c03\u7528 check() \u65b9\u6cd5\u540e\uff0c\u4ece\u6570\u636e\u5e93\u67e5\u8be2 checkstatus={}", savedApply != null ? savedApply.getCheckstatus() : "null");
                if (zyfxObjectApply.getOrderid() != null && !zyfxObjectApply.getOrderid().isEmpty() && (allApplies = this.applyService.list((Wrapper)Wrappers.lambdaQuery(ZyfxObjectApply.class).eq(ZyfxObjectApply::getOrderid, (Object)zyfxObjectApply.getOrderid()))) != null && allApplies.size() > 0) {
                    boolean hasDoing = allApplies.stream().anyMatch(apply -> apply.getCheckstatus() != null && (apply.getCheckstatus() == 0 || apply.getCheckstatus() == 1));
                    boolean hasRejected = allApplies.stream().anyMatch(apply -> apply.getCheckstatus() != null && apply.getCheckstatus() == 3);
                    boolean allApproved = allApplies.stream().allMatch(apply -> apply.getCheckstatus() != null && apply.getCheckstatus() == 2);
                    ZyfxApplyOrder zyfxApplyOrder = (ZyfxApplyOrder)this.zyfxApplyOrderService.getById((Serializable)((Object)zyfxObjectApply.getOrderid()));
                    if (zyfxApplyOrder != null) {
                        if (hasDoing) {
                            zyfxApplyOrder.setStatus(1);
                        } else if (hasRejected) {
                            zyfxApplyOrder.setStatus(3);
                        } else if (allApproved) {
                            zyfxApplyOrder.setStatus(2);
                        }
                        if (hasRejected || allApproved) {
                            this.zyfxApplyOrderService.updateById(zyfxApplyOrder);
                        }
                    }
                }
                log.info("\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7 - \u7533\u8bf7ID: {}, \u7533\u8bf7\u540d\u79f0: {}", (Object)zyfxObjectApply.getId(), (Object)zyfxObjectApply.getObjectname());
                this.executePostApprovalBusiness(zyfxObjectApply);
            } else {
                log.error("\u5904\u7406\u6d41\u7a0b\u5b8c\u6210\u4e1a\u52a1\u5931\u8d25,\u6ca1\u6709\u627e\u5230\u4e1a\u52a1\u6570\u636e - \u4e1a\u52a1Key: {}", (Object)businessKey);
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u6d41\u7a0b\u5b8c\u6210\u4e1a\u52a1\u5931\u8d25 - \u4e1a\u52a1Key: {}", (Object)businessKey, (Object)e);
        }
    }

    private ProxyObjectLimit restoreProxyObjectLimit(String processInstanceId) {
        try {
            Map variables = this.runtimeService.getVariables(processInstanceId);
            Object proxyLimitObj = variables.get("proxyObjectLimit");
            if (proxyLimitObj != null && proxyLimitObj instanceof Map) {
                Map proxyLimitMap = (Map)proxyLimitObj;
                return ObjectUtils.mapToObject(proxyLimitMap, ProxyObjectLimit.class);
            }
            String ipScope = (String)variables.get("ipScope");
            Object expiretimeObj = variables.get("expiretime");
            String frequency = (String)variables.get("frequency");
            String extension = (String)variables.get("extension");
            String xzqlimit = (String)variables.get("xzqlimit");
            if (ipScope != null || expiretimeObj != null || frequency != null || extension != null || xzqlimit != null) {
                ProxyObjectLimit limit = ProxyObjectLimit.builder().ipScope(ipScope).expiretime(expiretimeObj != null ? (Date)expiretimeObj : null).frequency(frequency).extension(extension).xzqlimit(xzqlimit).build();
                log.info("\u4ece\u6d41\u7a0b\u53d8\u91cf\u8fd8\u539f ProxyObjectLimit - \u6d41\u7a0b\u5b9e\u4f8bID: {}", (Object)processInstanceId);
                return limit;
            }
            log.debug("\u6d41\u7a0b\u53d8\u91cf\u4e2d\u672a\u627e\u5230 ProxyObjectLimit \u76f8\u5173\u6570\u636e - \u6d41\u7a0b\u5b9e\u4f8bID: {}", (Object)processInstanceId);
            return null;
        }
        catch (Exception e) {
            log.error("\u8fd8\u539f ProxyObjectLimit \u5931\u8d25 - \u6d41\u7a0b\u5b9e\u4f8bID: {}", (Object)processInstanceId, (Object)e);
            return null;
        }
    }

    private void executePostApprovalBusiness(ZyfxObjectApply apply) {
        log.info("\u6267\u884c\u5ba1\u6838\u901a\u8fc7\u540e\u7684\u4e1a\u52a1\u5904\u7406 - \u7533\u8bf7ID: {}", (Object)apply.getId());
    }

    public boolean isFailOnException() {
        return false;
    }

    public boolean isFireOnTransactionLifecycleEvent() {
        return false;
    }

    public String getOnTransaction() {
        return null;
    }
}

