/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.controller;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.ns.base.exception.BizException;
import com.geoway.ns.zyfx.domain.ZyfxToolCenterGroup;
import com.geoway.ns.zyfx.domain.ZyfxToolCenterScheme;
import com.geoway.ns.zyfx.service.ZyfxToolCenterGroupService;
import com.geoway.ns.zyfx.service.ZyfxToolCenterSchemeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5de5\u5177\u96c6\u5206\u7ec4\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/zyfx/toolcenter/group"})
public class ZyfxToolCenterGroupController {
    @Autowired
    private ZyfxToolCenterGroupService groupService;
    @Autowired
    private ZyfxToolCenterSchemeService schemeService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u7ec4\u5217\u8868\uff08\u4e0d\u4f20\u65b9\u6848ID\u5219\u4f7f\u7528\u9ed8\u8ba4\u65b9\u6848\uff09")
    @GetMapping(value={"/list"})
    public Response<List<ZyfxToolCenterGroup>> list(@ApiParam(value="\u65b9\u6848ID\uff0c\u4e0d\u4f20\u5219\u4f7f\u7528\u9ed8\u8ba4\u65b9\u6848") @RequestParam(required=false) String schemeId, @ApiParam(value="\u662f\u5426\u5305\u542b\u5de5\u5177\u96c6") @RequestParam(required=false, defaultValue="true") Boolean withToolsets) {
        try {
            ZyfxToolCenterScheme defaultScheme;
            List<ZyfxToolCenterGroup> groups = this.groupService.listBySchemeIdOrDefault(schemeId, withToolsets);
            if (!(StringUtils.hasText((String)schemeId) && groups != null && groups.size() != 0 || (defaultScheme = this.schemeService.findDefault()) == null)) {
                groups = this.groupService.listBySchemeIdOrDefault(defaultScheme.getId(), withToolsets);
            }
            return Response.ok(groups);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u65b9\u6848ID\u67e5\u8be2\u5206\u7ec4\u5217\u8868")
    @GetMapping(value={"/list/{schemeId}"})
    public Response<List<ZyfxToolCenterGroup>> listBySchemeId(@PathVariable String schemeId, @ApiParam(value="\u662f\u5426\u5305\u542b\u5de5\u5177\u96c6") @RequestParam(required=false, defaultValue="false") Boolean withToolsets) {
        try {
            List<ZyfxToolCenterGroup> groups = withToolsets != false ? this.groupService.listBySchemeIdWithToolsets(schemeId) : this.groupService.listBySchemeId(schemeId);
            return Response.ok(groups);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5206\u7ec4\u8be6\u60c5")
    @GetMapping(value={"/{id}"})
    public Response<ZyfxToolCenterGroup> getById(@PathVariable String id) {
        try {
            ZyfxToolCenterGroup group = (ZyfxToolCenterGroup)this.groupService.getById((Serializable)((Object)id));
            return Response.ok((Object)group);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u5206\u7ec4")
    @PostMapping(value={"/save"})
    public Response<String> save(@RequestBody ZyfxToolCenterGroup group) {
        try {
            this.groupService.saveOne(group);
            return Response.ok((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (BizException e) {
            return Response.error((String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u5220\u9664\u5206\u7ec4")
    @DeleteMapping(value={"/{id}"})
    public Response<String> delete(@PathVariable String id) {
        try {
            this.groupService.deleteOne(id);
            return Response.ok((Object)"\u5220\u9664\u6210\u529f");
        }
        catch (BizException e) {
            return Response.error((String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)("\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u4e3a\u5206\u7ec4\u6dfb\u52a0\u5de5\u5177\u96c6")
    @PostMapping(value={"/{groupId}/toolsets/add"})
    public Response<String> addToolsets(@PathVariable String groupId, @RequestBody List<String> toolsetIds) {
        try {
            this.groupService.addToolsets(groupId, toolsetIds);
            return Response.ok((Object)"\u6dfb\u52a0\u6210\u529f");
        }
        catch (BizException e) {
            e.printStackTrace();
            return Response.error((String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)("\u6dfb\u52a0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u4ece\u5206\u7ec4\u79fb\u9664\u5de5\u5177\u96c6")
    @PostMapping(value={"/{groupId}/toolsets/remove"})
    public Response<String> removeToolsets(@PathVariable String groupId, @RequestBody List<String> toolsetIds) {
        try {
            this.groupService.removeToolsets(groupId, toolsetIds);
            return Response.ok((Object)"\u79fb\u9664\u6210\u529f");
        }
        catch (BizException e) {
            e.printStackTrace();
            return Response.error((String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)("\u79fb\u9664\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

