/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.controller;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.ns.base.exception.BizException;
import com.geoway.ns.zyfx.domain.ZyfxToolCenterScheme;
import com.geoway.ns.zyfx.service.ZyfxToolCenterSchemeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5de5\u5177\u96c6\u65b9\u6848\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/zyfx/toolcenter/scheme"})
public class ZyfxToolCenterSchemeController {
    @Autowired
    private ZyfxToolCenterSchemeService schemeService;

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u65b9\u6848")
    @GetMapping(value={"/list"})
    public Response<List<ZyfxToolCenterScheme>> list(@ApiParam(value="\u662f\u5426\u5305\u542b\u8be6\u60c5") @RequestParam(required=false, defaultValue="false") Boolean withDetails) {
        try {
            List schemes = withDetails != false ? this.schemeService.listAllWithDetails() : this.schemeService.list();
            return Response.ok((Object)schemes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u65b9\u6848\u8be6\u60c5\uff08\u5305\u542b\u5206\u7ec4\u548c\u5de5\u5177\uff09")
    @GetMapping(value={"/{id}"})
    public Response<ZyfxToolCenterScheme> getById(@PathVariable String id) {
        try {
            ZyfxToolCenterScheme scheme = this.schemeService.getDetailById(id);
            return Response.ok((Object)scheme);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u65b9\u6848\u8be6\u60c5\uff08\u4e0d\u4f20ID\u5219\u4f7f\u7528\u9ed8\u8ba4\u65b9\u6848\uff09")
    @GetMapping(value={"/detail"})
    public Response<ZyfxToolCenterScheme> getDetail(@ApiParam(value="\u65b9\u6848ID\uff0c\u4e0d\u4f20\u5219\u4f7f\u7528\u9ed8\u8ba4\u65b9\u6848") @RequestParam(required=false) String schemeId) {
        try {
            ZyfxToolCenterScheme scheme;
            if (schemeId != null && !schemeId.isEmpty()) {
                scheme = this.schemeService.getDetailById(schemeId);
            } else {
                scheme = this.schemeService.findDefault();
                if (scheme != null) {
                    scheme = this.schemeService.getDetailById(scheme.getId());
                }
            }
            return Response.ok((Object)scheme);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u9ed8\u8ba4\u65b9\u6848\uff08\u5305\u542b\u5206\u7ec4\u548c\u5de5\u5177\uff09")
    @GetMapping(value={"/default"})
    public Response<ZyfxToolCenterScheme> getDefault(@ApiParam(value="\u662f\u5426\u5305\u542b\u8be6\u60c5") @RequestParam(required=false, defaultValue="true") Boolean withDetails) {
        try {
            ZyfxToolCenterScheme scheme = this.schemeService.findDefault();
            if (scheme != null && withDetails.booleanValue()) {
                scheme = this.schemeService.getDetailById(scheme.getId());
            }
            return Response.ok((Object)scheme);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8bbe\u7f6e\u9ed8\u8ba4\u65b9\u6848")
    @PostMapping(value={"/setDefault/{id}"})
    public Response<String> setDefault(@PathVariable String id) {
        try {
            this.schemeService.setDefault(id);
            return Response.ok((Object)"\u8bbe\u7f6e\u6210\u529f");
        }
        catch (BizException e) {
            e.printStackTrace();
            return Response.error((String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)("\u8bbe\u7f6e\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u6839\u636e\u5173\u952e\u5b57\u67e5\u8be2\u65b9\u6848")
    @GetMapping(value={"/key/{key}"})
    public Response<ZyfxToolCenterScheme> getByKey(@PathVariable String key) {
        try {
            ZyfxToolCenterScheme scheme = this.schemeService.findByKey(key);
            return Response.ok((Object)scheme);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u65b9\u6848")
    @PostMapping(value={"/save"})
    public Response<String> save(@RequestBody ZyfxToolCenterScheme scheme) {
        try {
            this.schemeService.saveOne(scheme);
            return Response.ok((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (BizException e) {
            e.printStackTrace();
            return Response.error((String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u5220\u9664\u65b9\u6848")
    @DeleteMapping(value={"/{id}"})
    public Response<String> delete(@PathVariable String id) {
        try {
            this.schemeService.deleteOne(id);
            return Response.ok((Object)"\u5220\u9664\u6210\u529f");
        }
        catch (BizException e) {
            return Response.error((String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)("\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u590d\u5236\u65b9\u6848")
    @PostMapping(value={"/copy"})
    public Response<ZyfxToolCenterScheme> copy(@ApiParam(value="\u6e90\u65b9\u6848ID") @RequestParam String id, @ApiParam(value="\u65b0\u65b9\u6848\u540d\u79f0") @RequestParam String newName) {
        try {
            ZyfxToolCenterScheme newScheme = this.schemeService.copyScheme(id, newName);
            return Response.ok((Object)newScheme);
        }
        catch (BizException e) {
            e.printStackTrace();
            return Response.error((String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error((String)("\u590d\u5236\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

