/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.utils;

import cn.hutool.core.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;

public class Z7zUtil {
    public static File unzip7z(File zipFile) throws IOException, ArchiveException {
        File destDir = FileUtil.file((File)zipFile.getParentFile(), (String)FileUtil.mainName((File)zipFile));
        return Z7zUtil.unzip7z(zipFile, destDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzip7z(File src7zPath, File targetPath) throws IOException, ArchiveException {
        SevenZFile sevenZFile = null;
        OutputStream outputStream = null;
        try {
            SevenZArchiveEntry entry;
            sevenZFile = new SevenZFile(src7zPath);
            Z7zUtil.createDirectory(targetPath.getAbsolutePath(), null);
            while ((entry = sevenZFile.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    Z7zUtil.createDirectory(targetPath.getAbsolutePath(), entry.getName());
                    continue;
                }
                outputStream = new FileOutputStream(new File(targetPath + File.separator + entry.getName()));
                int len = 0;
                byte[] b = new byte[2048];
                while ((len = sevenZFile.read(b)) != -1) {
                    outputStream.write(b, 0, len);
                }
                outputStream.flush();
                outputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (sevenZFile != null) {
                    sevenZFile.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return targetPath;
    }

    private static void createDirectory(String outputDir, String subDir) {
        File file = new File(outputDir);
        if (subDir != null && !subDir.trim().equals("")) {
            file = new File(outputDir + File.separator + subDir);
        }
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.mkdirs();
        }
    }
}

