/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.flowable.config;

import com.geoway.ns.flowable.listener.ProcessCompleteListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.boot.EngineConfigurationConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FlowableEventConfig {
    private static final Logger log = LoggerFactory.getLogger(FlowableEventConfig.class);

    @Bean
    public EngineConfigurationConfigurer<SpringProcessEngineConfiguration> processEngineConfigurer(ApplicationContext applicationContext) {
        return engineConfiguration -> {
            String eventType;
            List listeners;
            log.info("\u5f00\u59cb\u6ce8\u518c Flowable \u6d41\u7a0b\u5b8c\u6210\u4e8b\u4ef6\u76d1\u542c\u5668...");
            ProcessCompleteListener processCompleteListener = (ProcessCompleteListener)applicationContext.getBean(ProcessCompleteListener.class);
            HashMap<String, List> typedListeners = engineConfiguration.getTypedEventListeners();
            if (typedListeners == null) {
                typedListeners = new HashMap<String, List>();
                engineConfiguration.setTypedEventListeners(typedListeners);
            }
            if (!(listeners = typedListeners.computeIfAbsent(eventType = FlowableEngineEventType.PROCESS_COMPLETED.name(), k -> new ArrayList())).contains(processCompleteListener)) {
                listeners.add(processCompleteListener);
                log.info("Flowable \u6d41\u7a0b\u5b8c\u6210\u76d1\u542c\u5668\u6ce8\u518c\u6210\u529f - \u4e8b\u4ef6\u7c7b\u578b: {}, \u76d1\u542c\u5668\u5b9e\u4f8b: {}", (Object)eventType, (Object)processCompleteListener.getClass().getSimpleName());
            } else {
                log.warn("Flowable \u6d41\u7a0b\u5b8c\u6210\u76d1\u542c\u5668\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u6ce8\u518c");
            }
            log.info("Flowable \u4e8b\u4ef6\u76d1\u542c\u5668\u914d\u7f6e\u5b8c\u6210 - \u7c7b\u578b\u5316\u76d1\u542c\u5668\u6570\u91cf: {}", (Object)listeners.size());
        };
    }
}

