/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.flowable.controller;

import com.alibaba.fastjson2.JSONObject;
import com.geoway.adf.gbpm.flow.constant.ErrorCodeEnum;
import com.geoway.adf.gbpm.flow.entity.GbpmTbFlow;
import com.geoway.adf.gbpm.flow.entity.GbpmTbFlowPublish;
import com.geoway.adf.gbpm.flow.entity.GbpmTbTaskComment;
import com.geoway.adf.gbpm.flow.service.GbpmFlowService;
import com.geoway.adf.gbpm.flow.service.GbpmProcessService;
import com.geoway.adf.gbpm.flow.utils.CallResult;
import com.geoway.adf.gbpm.flow.utils.ResponseResult;
import com.geoway.ns.sys.service.ITokenService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.runtime.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d41\u7a0b\u5b9e\u4f8b\u76f8\u5173\u63a5\u53e3"})
@RestController
@CrossOrigin
@RequestMapping(value={"/open/process"})
public class ProcessController {
    private static final Logger log = LoggerFactory.getLogger(ProcessController.class);
    @Autowired
    GbpmProcessService gbpmProcessService;
    @Autowired
    GbpmFlowService gbpmFlowService;
    @Autowired
    ITokenService tokenService;

    @ApiOperation(value="\u542f\u52a8\u6d41\u7a0b", notes="\u6839\u636e\u6d41\u7a0bID\u542f\u52a8\u5bf9\u5e94\u7684\u4e3b\u7248\u672c\u6d41\u7a0b\uff0c\u53ea\u542f\u52a8\u800c\u4e0d\u6d41\u8f6c\u9996\u73af\u8282")
    @ApiImplicitParams(value={@ApiImplicitParam(name="flowId", value="\u6d41\u7a0bID", required=true), @ApiImplicitParam(name="title", value="\u6d41\u7a0b\u6807\u9898", required=true), @ApiImplicitParam(name="dataId", value="\u4e1a\u52a1ID", required=true), @ApiImplicitParam(name="mapData", value="\u542f\u52a8\u53c2\u6570Map\u7c7b\u578b\u7684json\u5b57\u7b26\u4e32", required=false)})
    @PostMapping(value={"/startByFlowId"})
    public ResponseResult<String> startByFlowId(HttpServletRequest request, String flowId, String title, String dataId, String mapData) {
        try {
            String initiator = this.tokenService.queryUserIdByRequest(request);
            Map map = new HashMap();
            if (StringUtils.isNotEmpty((CharSequence)mapData)) {
                map = (Map)JSONObject.parseObject((String)mapData, map.getClass());
            }
            ProcessInstance pi = this.gbpmProcessService.startByFlowId(flowId, title, (Object)dataId, initiator, map);
            return ResponseResult.success((Object)pi.getId());
        }
        catch (Exception ex) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)ex.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u52a8\u6d41\u7a0b\u5e76\u6d41\u8f6c\u9996\u73af\u8282", notes="\u6839\u636e\u6d41\u7a0bID\u542f\u52a8\u5bf9\u5e94\u7684\u4e3b\u7248\u672c\u6d41\u7a0b\uff0c\u542f\u52a8\u5e76\u4e14\u6d41\u8f6c\u9996\u73af\u8282")
    @ApiImplicitParams(value={@ApiImplicitParam(name="flowId", value="\u6d41\u7a0bID", required=true), @ApiImplicitParam(name="title", value="\u6d41\u7a0b\u6807\u9898", required=true), @ApiImplicitParam(name="dataId", value="\u4e1a\u52a1ID", required=true), @ApiImplicitParam(name="mapData", value="\u542f\u52a8\u53c2\u6570Map\u7c7b\u578b\u7684json\u5b57\u7b26\u4e32", required=false)})
    @PostMapping(value={"/startAndTakeByFlowId"})
    public ResponseResult<String> startAndTakeByFlowId(HttpServletRequest request, String flowId, String title, String dataId, String mapData) {
        try {
            GbpmTbFlowPublish flowPublish;
            GbpmTbFlow flow;
            String initiator = this.tokenService.queryUserIdByRequest(request);
            Object map = null;
            if (StringUtils.isNotEmpty((CharSequence)mapData)) {
                map = (JSONObject)JSONObject.parseObject((String)mapData, map.getClass());
            }
            if ((flow = this.gbpmFlowService.findFlowById(flowId)) != null && 1 == flow.getStatus() && (flowPublish = this.gbpmFlowService.getFlowPublishById(flow.getMainPublishId())) != null) {
                ProcessInstance pi = this.gbpmProcessService.startAndTakeFirst(title, flowPublish.getProcDefId(), (Object)dataId, initiator, (JSONObject)map);
                return ResponseResult.success((Object)pi.getId());
            }
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6d41\u7a0b\u4fe1\u606f");
        }
        catch (Exception ex) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)ex.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u52a8\u6d41\u7a0b", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49ID\u542f\u52a8\u5bf9\u5e94\u7684\u4e3b\u7248\u672c\u6d41\u7a0b\uff0c\u53ea\u542f\u52a8\u800c\u4e0d\u6d41\u8f6c\u9996\u73af\u8282")
    @ApiImplicitParams(value={@ApiImplicitParam(name="procDefId", value="\u6d41\u7a0b\u5b9a\u4e49ID", required=true), @ApiImplicitParam(name="title", value="\u6d41\u7a0b\u6807\u9898", required=true), @ApiImplicitParam(name="dataId", value="\u4e1a\u52a1ID", required=true), @ApiImplicitParam(name="mapData", value="\u542f\u52a8\u53c2\u6570Map\u7c7b\u578b\u7684json\u5b57\u7b26\u4e32", required=false)})
    @PostMapping(value={"/startByProcDefId"})
    public ResponseResult<String> startByProcDefId(HttpServletRequest request, String procDefId, String title, String dataId, String mapData) {
        try {
            String initiator = this.tokenService.queryUserIdByRequest(request);
            Map map = new HashMap();
            if (StringUtils.isNotEmpty((CharSequence)mapData)) {
                map = (Map)JSONObject.parseObject((String)mapData, map.getClass());
            }
            ProcessInstance pi = this.gbpmProcessService.startByProcDefId(procDefId, title, (Object)dataId, initiator, map);
            return ResponseResult.success((Object)pi.getId());
        }
        catch (Exception ex) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)ex.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u52a8\u6d41\u7a0b\u5e76\u6d41\u8f6c\u9996\u73af\u8282", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49ID\u542f\u52a8\u5bf9\u5e94\u7684\u4e3b\u7248\u672c\u6d41\u7a0b\uff0c\u542f\u52a8\u5e76\u4e14\u6d41\u8f6c\u9996\u73af\u8282")
    @ApiImplicitParams(value={@ApiImplicitParam(name="procDefId", value="\u6d41\u7a0b\u5b9a\u4e49ID", required=true), @ApiImplicitParam(name="title", value="\u6d41\u7a0b\u6807\u9898", required=true), @ApiImplicitParam(name="dataId", value="\u4e1a\u52a1ID", required=true), @ApiImplicitParam(name="mapData", value="\u542f\u52a8\u53c2\u6570Map\u7c7b\u578b\u7684json\u5b57\u7b26\u4e32", required=false)})
    @PostMapping(value={"/startAndTakeByProcDefId"})
    public ResponseResult<String> startAndTakeByProcDefId(HttpServletRequest request, String procDefId, String title, String dataId, String mapData) {
        try {
            String initiator = this.tokenService.queryUserIdByRequest(request);
            JSONObject map = null;
            if (StringUtils.isNotEmpty((CharSequence)mapData)) {
                map = JSONObject.parseObject((String)mapData);
            }
            ProcessInstance pi = this.gbpmProcessService.startAndTakeFirst(title, procDefId, (Object)dataId, initiator, map);
            return ResponseResult.success((Object)pi.getId());
        }
        catch (Exception ex) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)ex.getMessage());
        }
    }

    @ApiOperation(value="\u6d41\u7a0b\u7ec8\u6b62", notes="\u7ec8\u6b62\u6307\u5b9a\u7684\u6d41\u7a0b\u5b9e\u4f8b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="\u6d41\u7a0b\u5b9e\u4f8bID", required=true), @ApiImplicitParam(name="stopReason", value="\u7ec8\u6b62\u539f\u56e0", required=true)})
    @PostMapping(value={"/stopProcess"})
    public ResponseResult<Void> stopProcessInstance(HttpServletRequest request, String processInstanceId, String stopReason) {
        String userId = null;
        try {
            userId = this.tokenService.queryUserIdByRequest(request);
            CallResult cr = this.gbpmProcessService.stopProcessInstance(processInstanceId, userId, stopReason);
            if (cr.isSuccess()) {
                return ResponseResult.success();
            }
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)cr.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.UNHANDLED_EXCEPTION, (String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b", notes="\u5220\u9664\u6307\u5b9a\u7684\u6d41\u7a0b\u5b9e\u4f8b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="\u6d41\u7a0b\u5b9e\u4f8bID", required=true), @ApiImplicitParam(name="deleteReason", value="\u5220\u9664\u539f\u56e0", required=true), @ApiImplicitParam(name="cascade", value="\u662f\u5426\u7ea7\u8054\u5220\u9664", required=false)})
    @PostMapping(value={"/deleteProcess"})
    public ResponseResult<Void> deleteProcessInstance(String processInstanceId, String deleteReason, Boolean cascade) {
        if (cascade != null && cascade.booleanValue()) {
            this.gbpmProcessService.deleteProcessInstance(processInstanceId, deleteReason, cascade.booleanValue());
        } else {
            this.gbpmProcessService.deleteProcessInstance(processInstanceId, deleteReason);
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u8be6\u60c5", notes="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bID\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u8be6\u60c5")
    @ApiImplicitParam(name="processInstanceId", value="\u6d41\u7a0b\u5b9e\u4f8bID", required=true)
    @GetMapping(value={"/getProcessInstance"})
    public ResponseResult<HistoricProcessInstance> getProcessInstance(String processInstanceId) {
        HistoricProcessInstance hpi = this.gbpmProcessService.getHistoricProcessInstance(processInstanceId);
        return ResponseResult.success((Object)hpi);
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u6d41\u8f6c\u8bb0\u5f55", notes="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bID\u83b7\u53d6\u6d41\u7a0b\u6d41\u8f6c\u8bb0\u5f55")
    @ApiImplicitParam(name="processInstanceId", value="\u6d41\u7a0b\u5b9e\u4f8bID", required=true)
    @GetMapping(value={"/getFlowTaskCommentList"})
    public ResponseResult<List<GbpmTbTaskComment>> getFlowTaskCommentList(String processInstanceId) {
        List ls = this.gbpmProcessService.getFlowTaskCommentList(processInstanceId);
        return ResponseResult.success((Object)ls);
    }
}

