/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.controller;

import com.geoway.ns.sys.annotation.WhiteRequest;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.zyfx.domain.ZyfxImage;
import com.geoway.ns.zyfx.service.ZyfxImageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u56fe\u7247\u8bbf\u95ee\u63a5\u53e3"})
@RestController
@RequestMapping(value={"zyfx/image"})
public class ZyfxImageController {
    private static final Logger log = LoggerFactory.getLogger(ZyfxImageController.class);
    @Autowired
    ZyfxImageService zyfxImageService;

    @WhiteRequest(value=true)
    @ApiOperation(value="\u67e5\u8be2\u56fe\u7247")
    @RequestMapping(value={"/getImg"}, method={RequestMethod.GET}, produces={"image/jpeg"})
    @ResponseBody
    public byte[] findImage(HttpServletRequest request, @RequestParam(value="imgId", required=true) String imgId) {
        byte[] imageArr = null;
        try {
            ZyfxImage zyfxImage = (ZyfxImage)this.zyfxImageService.getById((Serializable)((Object)imgId));
            imageArr = zyfxImage.getImage();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return imageArr;
    }

    @WhiteRequest(value=true)
    @ApiOperation(value="\u67e5\u8be2\u56fe\u7247\u7f29\u7565\u56fe")
    @RequestMapping(value={"/getImgThumnail"}, method={RequestMethod.GET}, produces={"image/jpeg"})
    @ResponseBody
    public byte[] findImgThumnail(HttpServletRequest request, @RequestParam(value="imgId", required=true) String imgId) {
        byte[] imageArr = null;
        try {
            ZyfxImage zyfxImage = (ZyfxImage)this.zyfxImageService.getById((Serializable)((Object)imgId));
            if (zyfxImage != null) {
                imageArr = zyfxImage.getThumnail();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return imageArr;
    }

    @ApiOperation(value="\u5220\u9664\u56fe\u7247")
    @PostMapping(value={"delete"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse deleteById(HttpServletRequest request, @RequestParam(value="imgId", required=true) String imgId) {
        BaseResponse response = new BaseResponse();
        try {
            this.zyfxImageService.removeById((Serializable)((Object)imgId));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u66f4\u65b0\u56fe\u7247")
    @PostMapping(value={"updateZyfxImage"}, produces={"application/json;charset=UTF-8"})
    public DataResponse<ZyfxImage> updateZyfxImage(HttpServletRequest request, @RequestPart(value="image", required=true) MultipartFile image, @RequestParam(value="imgId", required=false) String imgId, @RequestParam(value="imgId", required=false) String tag) {
        DataResponse response = new DataResponse();
        try {
            ZyfxImage zyfxImage = this.zyfxImageService.updateZyfxImage(imgId, image.getInputStream(), tag);
            response.setResult((Object)zyfxImage);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
            response.markFailure(e.getMessage());
        }
        return response;
    }
}

