/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.sys.domain.FileServer;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.sys.service.FileServerService;
import com.geoway.ns.zyfx.domain.ZyfxFiles;
import com.geoway.ns.zyfx.mapper.ZyfxFilesMapper;
import com.geoway.ns.zyfx.service.ZyfxFilesService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ZyfxFilesServiceImpl
extends ServiceImpl<ZyfxFilesMapper, ZyfxFiles>
implements ZyfxFilesService {
    @Resource
    FileServerService fileServerService;

    @Override
    public List<ZyfxFiles> queryZyfxFilesByObjectId(String objectId, String tag) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(ZyfxFiles::getObjectid, (Object)objectId);
        if (StrUtil.isNotBlank((CharSequence)tag)) {
            queryWrapper.eq(ZyfxFiles::getTag, (Object)tag);
        }
        List zyfxFiles = this.list((Wrapper)queryWrapper);
        for (ZyfxFiles zyfxFile : zyfxFiles) {
            FileServer fileServer = this.fileServerService.findById(zyfxFile.getServerid());
            if (fileServer == null) continue;
            zyfxFile.setEndPoint(fileServer.getEndpoint() + "/" + fileServer.getBucket());
        }
        return zyfxFiles;
    }

    @Override
    public void saveFiles(MultipartFile[] files, String objectId, String tag, boolean isClear, boolean isSnapshot) throws Exception {
        if (isClear) {
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(ZyfxFiles::getObjectid, (Object)objectId);
            List zyfxFiles = this.list((Wrapper)queryWrapper);
            for (ZyfxFiles zyfxFile : zyfxFiles) {
                this.fileServerService.deleteFile(zyfxFile.getServerid(), zyfxFile.getUrl());
            }
            this.remove((Wrapper)queryWrapper);
        }
        if (files != null) {
            ArrayList<ZyfxFiles> zyfxFilesList = new ArrayList<ZyfxFiles>();
            for (MultipartFile file : files) {
                ZyfxFiles zyfxFile = new ZyfxFiles();
                FileServerResponse fileServerRsp = this.fileServerService.sendFileToServer(file, isSnapshot);
                zyfxFile.setServerid(fileServerRsp.getServerId());
                zyfxFile.setName(file.getOriginalFilename());
                zyfxFile.setObjectid(objectId);
                zyfxFile.setPid("-1");
                zyfxFile.setSize(String.valueOf(file.getSize()));
                zyfxFile.setTag(tag);
                zyfxFile.setFiletype(fileServerRsp.getFileType());
                zyfxFile.setType(1);
                zyfxFile.setUrl(fileServerRsp.getPath());
                zyfxFile.setSnapshot(fileServerRsp.getThumailPath());
                zyfxFilesList.add(zyfxFile);
            }
            this.saveBatch(zyfxFilesList);
        }
    }
}

