/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.monitor.controller;

import com.geoway.ns.monitor.dto.result.MonitorSearchDTO;
import com.geoway.ns.monitor.entity.ZyfxAccessRoll;
import com.geoway.ns.monitor.service.AccessRollService;
import com.geoway.ns.monitor.service.ZyfxAccessStatisticsService;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.utils.MyRequestUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u670d\u52a1\u76d1\u63a7"})
@RestController
@RequestMapping(value={"/proxyManage"})
public class AccessManagerController {
    @Autowired
    ZyfxAccessStatisticsService statisticsService;
    @Autowired
    AccessRollService accessRollService;

    @ApiOperation(value="\u670d\u52a1\u76d1\u63a7\u2014\u2014\u670d\u52a1\u67e5\u8be2")
    @RequestMapping(value={"/queryService"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse queryService(Integer page, Integer size, String resourceName, Integer status, Integer resourceType, Long strTime, Long endTime, String resourceCategory) {
        DataResponse response = new DataResponse();
        try {
            response.setResult(this.statisticsService.queryServiceList(page, size, resourceName, status, resourceType, strTime, endTime, resourceCategory));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u670d\u52a1\u76d1\u63a7\u2014\u2014\u7528\u6237\u67e5\u8be2")
    @RequestMapping(value={"/queryUser"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse queryUser(Integer page, Integer size, String authorizerName, Integer status, Integer userType, Long strTime, Long endTime) {
        DataResponse response = new DataResponse();
        try {
            response.setResult(this.statisticsService.queryUserList(page, size, authorizerName, status, userType, strTime, endTime));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u670d\u52a1\u76d1\u63a7\u2014\u2014\u5e94\u7528\u67e5\u8be2")
    @RequestMapping(value={"/queryApplication"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse queryApplication(Integer page, Integer size, String authorizerName, Integer status, Integer userType, Long strTime, Long endTime) {
        DataResponse response = new DataResponse();
        try {
            response.setResult(this.statisticsService.queryApplicationList(page, size, authorizerName, status, strTime, endTime));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u670d\u52a1\u76d1\u63a7\u2014\u2014\u8bbf\u95ee\u7edf\u8ba1")
    @RequestMapping(value={"/queryAccessStatis"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse queryAccessStatis(@RequestBody MonitorSearchDTO search) {
        DataResponse response = new DataResponse();
        try {
            response.setResult((Object)this.statisticsService.queryAccessStatis(search));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u670d\u52a1\u76d1\u63a7\u2014\u2014\u8bbf\u95ee\u8bb0\u5f55")
    @RequestMapping(value={"/queryAccessRecord"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse queryAccessRecord(@RequestBody MonitorSearchDTO search) {
        DataResponse response = new DataResponse();
        try {
            response.setResult((Object)this.statisticsService.queryAccessRecord(search));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u603b\u4f53\u76d1\u63a7\u2014\u2014\u67e5\u8be2\u603b\u6570")
    @RequestMapping(value={"/statistics"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public DataResponse statistics() {
        DataResponse response = new DataResponse();
        try {
            response.setResult((Object)this.statisticsService.statistics());
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u603b\u4f53\u76d1\u63a7\u2014\u2014\u6d3b\u8dc3\u8bbf\u5ba2")
    @RequestMapping(value={"/queryActiveAuthorizer"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public DataResponse queryActiveAuthorizer(Integer accessType, Integer limit) {
        DataResponse response = new DataResponse();
        try {
            response.setResult(this.statisticsService.queryActiveAuthorizer(accessType, limit));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u603b\u4f53\u76d1\u63a7\u2014\u2014\u6309\u670d\u52a1\u5bf9\u6570\u636e\u3001\u5206\u6790\u3001\u7ec4\u4ef6\u670d\u52a1\u7edf\u8ba1")
    @RequestMapping(value={"/statisService"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse countResource(Integer precision) {
        DataResponse response = new DataResponse();
        try {
            HashMap<String, Object> map = this.statisticsService.countResource(precision);
            response.setResult(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u603b\u4f53\u76d1\u63a7\u2014\u2014\u6309\u670d\u52a1\u5bf9\u6570\u636e\u3001\u5206\u6790\u3001\u7ec4\u4ef6\u670d\u52a1\u7edf\u8ba1--\u6839\u636e\u5f53\u524d\u670d\u52a1\u76ee\u5f55\u6765\u67e5\u8be2\uff08\u65b0\uff09")
    @RequestMapping(value={"/getServiceStatisByCatalog"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse getServiceStatisByCatalog(Integer precision, Long strTime, Long endTime, Integer type) {
        DataResponse response = new DataResponse();
        try {
            Map<String, Object> accessStatistics = this.statisticsService.getServiceStatisByCatalog(precision, strTime, endTime, type);
            response.setResult(accessStatistics);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u603b\u4f53\u76d1\u63a7-\u2014\u6309\u7c7b\u578b\u5bf9\u6570\u636e\u3001\u5206\u6790\u3001\u7ec4\u4ef6\u670d\u52a1\u7edf\u8ba1")
    @RequestMapping(value={"/getNumByMapServiceType"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public DataResponse getNumByMapServiceType(Integer precision) {
        DataResponse response = new DataResponse();
        try {
            Map<String, Object> map = this.statisticsService.getNumByMapServiceType(precision);
            response.setResult(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u603b\u4f53\u76d1\u63a7-\u6309\u670d\u52a1\u76ee\u5f55\u7edf\u8ba1\u670d\u52a1\u6570\u91cf")
    @RequestMapping(value={"/getNumByServiceType"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public DataResponse getNumByServiceType(Integer precision) {
        DataResponse response = new DataResponse();
        try {
            Map<String, Object> map = this.statisticsService.getNumByServiceType(precision);
            response.setResult(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u603b\u4f53\u76d1\u63a7\u2014\u2014\u670d\u52a1\u54cd\u5e94\u7edf\u8ba1\uff08\u65b0\uff09")
    @RequestMapping(value={"/getResponseStatis"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse getResponseStatis() {
        DataResponse response = new DataResponse();
        try {
            Map<String, Object> accessStatistics = this.statisticsService.getResponseStatis();
            response.setResult(accessStatistics);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u603b\u4f53\u76d1\u63a7\u2014\u2014\u670d\u52a1\u8bbf\u95ee\u7edf\u8ba1\uff08\u65b0\uff09")
    @RequestMapping(value={"/getAccessStatis"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse getAccessStatis() {
        DataResponse response = new DataResponse();
        try {
            Map<String, Object> accessStatistics = this.statisticsService.getAccessStatis();
            response.setResult(accessStatistics);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u603b\u4f53\u76d1\u63a7\u2014\u2014\u6d41\u91cf\u7edf\u8ba1\uff08\u65b0\uff09")
    @RequestMapping(value={"/getFlowStatis"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse getFlowStatis() {
        DataResponse response = new DataResponse();
        try {
            response.setResult((Object)this.statisticsService.getFlowStatis());
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u603b\u4f53\u76d1\u63a7\u2014\u76d1\u63a7\u670d\u52a1\u5f02\u5e38\u6570\uff08\u4e00\u4e2a\u5c0f\u65f6\u5185\u8bbf\u95ee\u5f02\u5e38\u8d8550%\u89c6\u4e3a\u670d\u52a1\u5f02\u5e38\uff09")
    @RequestMapping(value={"/queryExceptionTotalNumber"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse queryExceptionTotalNumber() {
        DataResponse response = new DataResponse();
        try {
            response.setResult((Object)this.statisticsService.queryExceptionTotalNumber());
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u603b\u4f53\u76d1\u63a7\u2014\u2014\u70ed\u70b9\u533a\u57df\uff08\u65b0\uff09")
    @RequestMapping(value={"/getHotSpotAreatatis"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse getHotSpotAreatatis(HttpServletRequest request) {
        DataResponse response = new DataResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            Map<String, Long> accessStatistics = this.statisticsService.getHotSpotAreatatis(token);
            response.setResult(accessStatistics);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u603b\u4f53\u76d1\u63a7-\u6839\u636e\u670d\u52a1\u7c7b\u578b\u67e5\u8be2\u70ed\u70b9\u670d\u52a1")
    @RequestMapping(value={"/getHotServiceByServiceType"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public DataResponse getHotServiceByServiceType(Integer precision, Integer limit, Long strTime, Long endTime) {
        DataResponse response = new DataResponse();
        try {
            Map<String, Object> map = this.statisticsService.getHotServiceByServiceType(precision, limit, strTime, endTime);
            response.setResult(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5f02\u5e38\u76d1\u63a7\u2014\u67e5\u8be2\u4eca\u65e5\u5f02\u5e38")
    @RequestMapping(value={"/queryExceptionByNow"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public DataResponse queryExceptionByNow() {
        DataResponse response = new DataResponse();
        try {
            response.setResult(this.statisticsService.queryExceptionByNow());
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5f02\u5e38\u76d1\u63a7\u2014\u67e5\u8be2\u7d2f\u79ef\u5f02\u5e38")
    @RequestMapping(value={"/queryExceptionChat"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse queryExceptionChat(Long times) {
        DataResponse response = new DataResponse();
        try {
            response.setResult((Object)this.statisticsService.queryExceptionChat(times));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5f02\u5e38\u76d1\u63a7\u2014\u67e5\u8be2\u5f02\u5e38\u7c7b\u578b")
    @RequestMapping(value={"/queryExceptionType"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public DataResponse queryExceptionType() {
        DataResponse response = new DataResponse();
        try {
            response.setResult(this.statisticsService.queryExceptionType());
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u5f02\u5e38\u76d1\u63a7\u2014\u67e5\u8be2\u5f02\u5e38\u6392\u540d")
    @ApiImplicitParam(name="type", value="0.\u5f02\u5e38\u670d\u52a1 1.\u5f02\u5e38\u7528\u6237 2.\u5f02\u5e38\u5e94\u7528", dataTypeClass=String.class)
    @RequestMapping(value={"/queryExceptionSort"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse queryExceptionSort(Long times, Integer size, Integer type) {
        DataResponse response = new DataResponse();
        try {
            response.setResult((Object)this.statisticsService.queryExceptionListSort(size, type, times));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u9ed1\u767d\u540d\u5355\u2014\u2014\u589e\u52a0")
    @RequestMapping(value={"/addRoll"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse getRoll(ZyfxAccessRoll zyfxAccessRoll) {
        DataResponse response = new DataResponse();
        try {
            response.setResult((Object)this.accessRollService.addRoll(zyfxAccessRoll));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u9ed1\u767d\u540d\u5355\u2014\u2014\u5220\u9664")
    @RequestMapping(value={"/deleteRoll"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public DataResponse deleteRoll(String id) {
        DataResponse response = new DataResponse();
        try {
            this.accessRollService.delete(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u4fe1\u606f\u67e5\u8be2\u2014\u2014\u4eca\u65e5\u8bbf\u95ee\u4ee5\u53ca\u603b\u8bbf\u95ee\u91cf")
    @RequestMapping(value={"/queryAccesscount"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public DataResponse queryAccesscount(Integer type) {
        DataResponse response = new DataResponse();
        try {
            response.setResult(this.statisticsService.queryAccesscount(type));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.markFailure(e.getMessage());
        }
        return response;
    }
}

