/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.adf.gbpm.flow.entity.GbpmTbTaskComment;
import com.geoway.ns.flowable.service.ShareFlowService;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.dto.PageParam;
import com.geoway.ns.sys.dto.RowsResponse;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.utils.MyRequestUtil;
import com.geoway.ns.zyfx.constant.EnumCheckStatus;
import com.geoway.ns.zyfx.constant.datacenter.EnumDataApplyType;
import com.geoway.ns.zyfx.domain.ZyfxApplyOrder;
import com.geoway.ns.zyfx.domain.ZyfxObjectApply;
import com.geoway.ns.zyfx.dto.ZyfxApplyFilterDTO;
import com.geoway.ns.zyfx.dto.ZyfxObjectDetail;
import com.geoway.ns.zyfx.service.ZyfxApplyOrderService;
import com.geoway.ns.zyfx.service.ZyfxObjectApplyService;
import com.geoway.ns.zyfx.service.ZyfxObjectApprovalService;
import com.geoway.ns.zyfx.service.ZyfxObjectService;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.flowable.task.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u7533\u8bf7\u63a5\u53e3"})
@RestController
@RequestMapping(value={"zyfx/apply"})
public class zyfxObjectApplyController {
    private static final Logger log = LoggerFactory.getLogger(zyfxObjectApplyController.class);
    @Resource
    private ITokenService tokenService;
    @Resource
    private ZyfxObjectApplyService applyService;
    @Resource
    ZyfxObjectApprovalService zyfxObjectApprovalService;
    @Resource
    ZyfxApplyOrderService zyfxApplyOrderService;
    @Autowired
    ZyfxObjectService zyfxObjectService;
    @Autowired
    ShareFlowService shareFlowService;

    @ApiOperation(value="1-\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"/listPage"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse searchPage(HttpServletRequest request, ZyfxApplyFilterDTO dataApplyFilterDTO) {
        RowsResponse response = new RowsResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            dataApplyFilterDTO.setUserId(sysUser.getId());
            dataApplyFilterDTO.setHasReadCheck(dataApplyFilterDTO.getHasRead());
            dataApplyFilterDTO.setHasReadApply(-1);
            dataApplyFilterDTO.setApplyType(EnumDataApplyType.Initiative.value);
            IPage<ZyfxObjectApply> resultPage = this.applyService.queryPageByFilter(dataApplyFilterDTO);
            if (this.shareFlowService.checkFlowInfo(dataApplyFilterDTO.getGrouptype()).booleanValue()) {
                for (ZyfxObjectApply apply : resultPage.getRecords()) {
                    List<Task> tasks = this.shareFlowService.queryTaskListByBusinessKey(apply.getId());
                    if (tasks != null && tasks.size() > 0) {
                        Task task = tasks.get(0);
                        apply.setCurrentTaskId(task.getId());
                        apply.setCurrentTaskName(task.getName());
                        apply.setTaskCreateTime(task.getCreateTime());
                        apply.setProcessInstanceId(task.getProcessInstanceId());
                        apply.setCurrentAssignee(task.getAssignee());
                        ShareFlowService.NextNodeAssignee currentNodeAssignee = this.shareFlowService.getCurrentNodeAssignees(task);
                        apply.setCurrentNodeAssignee(currentNodeAssignee);
                    }
                    apply.setFlowEnabled(true);
                }
            }
            response.setRows(resultPage.getRecords());
            response.setTotal(Long.valueOf(resultPage.getTotal()));
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="1-\u5206\u9875\u67e5\u8be2-\u8ba2\u5355")
    @RequestMapping(value={"/orderListPage"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse searchPageByOrder(HttpServletRequest request, ZyfxApplyFilterDTO dataApplyFilterDTO) {
        RowsResponse response = new RowsResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            dataApplyFilterDTO.setUserId(sysUser.getId());
            dataApplyFilterDTO.setHasReadCheck(dataApplyFilterDTO.getHasRead());
            dataApplyFilterDTO.setHasReadApply(-1);
            dataApplyFilterDTO.setApplyType(EnumDataApplyType.Initiative.value);
            IPage<ZyfxApplyOrder> resultPage = this.applyService.queryOrderPageByFilter(dataApplyFilterDTO);
            response.setRows(resultPage.getRecords());
            response.setTotal(Long.valueOf(resultPage.getTotal()));
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="2-\u589e\u52a0\u7533\u8bf7")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse add(HttpServletRequest request, @RequestBody ZyfxObjectApply shareDataApplyInfo) {
        DataResponse response = new DataResponse();
        try {
            shareDataApplyInfo.setCreatetime(new Date());
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            shareDataApplyInfo.setUserid(sysUser.getId());
            shareDataApplyInfo.setUsername(sysUser.getAlisname());
            this.applyService.saveOne(shareDataApplyInfo);
            response.setResult((Object)shareDataApplyInfo.getId());
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="3-\u589e\u52a0\u7533\u8bf7")
    @RequestMapping(value={"/addOrderApply"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse addOrderApply(HttpServletRequest request, @ApiParam(value="\u6570\u636e\u7533\u8bf7\u8ba2\u5355(ZyfxObjectApply)\u5217\u8868", required=true) @RequestBody String orderInfoStr) {
        DataResponse response = new DataResponse();
        if (StringUtils.isEmpty((CharSequence)orderInfoStr)) {
            return DataResponse.error((String)"\u8ba2\u5355\u6570\u636e\u4e3a\u7a7a");
        }
        try {
            ZyfxApplyOrder order;
            Gson gson = new Gson();
            List objectApplies = (List)gson.fromJson(orderInfoStr.toString(), new TypeToken<List<ZyfxObjectApply>>(){}.getType());
            if (objectApplies == null || objectApplies.size() == 0) {
                return DataResponse.error((String)"\u8ba2\u5355\u6570\u636e\u4fe1\u606f\u6709\u8bef");
            }
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            objectApplies.forEach(f -> {
                f.setUsername(sysUser.getAlisname());
                f.setUserid(sysUser.getId());
                f.setCheckstatus(EnumCheckStatus.NotCheck.value);
                f.setCreatetime(new Date());
            });
            List<ZyfxObjectApply> objectApplies1 = objectApplies.stream().filter(p -> p.getGxlx().equals(1) || StringUtils.isNotEmpty((CharSequence)sysUser.getDeptId()) && StringUtils.isNotEmpty((CharSequence)p.getHjdwid()) && sysUser.getDeptId().contains(p.getHjdwid())).collect(Collectors.toList());
            List<ZyfxObjectApply> objectApplies2 = objectApplies.stream().filter(apply -> !objectApplies1.contains(apply)).collect(Collectors.toList());
            if (objectApplies1.size() > 0) {
                order = this.applyService.saveAll(objectApplies1);
                response.setResult((Object)order.getId());
                this.applyService.orderCheck(sysUser, null, 2, "\u65e0\u6761\u4ef6\u5171\u4eab\u6570\u636e,\u9ed8\u8ba4\u901a\u8fc7", order.getId());
            }
            if (objectApplies2.size() > 0) {
                order = this.applyService.saveAll(objectApplies2);
                response.setResult((Object)order.getId());
                if (this.shareFlowService.checkFlowInfo(order.getGrouptype()).booleanValue()) {
                    this.shareFlowService.startFlow(order.getId(), true);
                }
            }
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="3-\u8bbe\u7f6e\u6d88\u606f\u4e3a\u5df2\u8bfb")
    @PostMapping(value={"setHasReadById"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse setHasReadById(HttpServletRequest request, @RequestParam(value="id") String id, @RequestParam(value="hasRead", required=false, defaultValue="1") Integer hasRead) {
        BaseResponse response = new BaseResponse();
        try {
            ZyfxObjectApply applyInfo = (ZyfxObjectApply)this.applyService.getById((Serializable)((Object)id));
            if (applyInfo.getApprovals() != null) {
                applyInfo.getApprovals().forEach(f -> f.setHasread(hasRead));
                this.zyfxObjectApprovalService.saveOrUpdateBatch(applyInfo.getApprovals());
            }
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="4-\u67e5\u770b\u8be6\u60c5")
    @RequestMapping(value={"/detail"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public DataResponse detail(HttpServletRequest request, @RequestParam(value="id") String id) {
        DataResponse response = new DataResponse();
        try {
            ZyfxObjectApply applyInfo = this.applyService.findDetailById(id);
            if (this.shareFlowService.checkFlowInfo(applyInfo.getGrouptype()).booleanValue()) {
                List<GbpmTbTaskComment> comments = this.shareFlowService.getProcessAuditRecords(applyInfo.getId());
                applyInfo.setComments(comments);
                List<Task> tasks = this.shareFlowService.queryTaskListByBusinessKey(applyInfo.getId());
                if (tasks != null && !tasks.isEmpty()) {
                    Task task = tasks.get(0);
                    applyInfo.setCurrentAssignee(task.getAssignee());
                    applyInfo.setCurrentTaskId(task.getId());
                    applyInfo.setCurrentTaskName(task.getName());
                    applyInfo.setTaskCreateTime(task.getCreateTime());
                    applyInfo.setProcessInstanceId(task.getProcessInstanceId());
                    List<ShareFlowService.NextNodeAssignee> nextNodeAssignees = this.shareFlowService.getNextNodeAssignees(task);
                    applyInfo.setNextNodeAssignees(nextNodeAssignees);
                    ShareFlowService.NextNodeAssignee currentNodeAssignee = this.shareFlowService.getCurrentNodeAssignees(task);
                    applyInfo.setCurrentNodeAssignee(currentNodeAssignee);
                }
                applyInfo.setFlowEnabled(true);
            }
            response.setResult((Object)applyInfo);
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="4-\u67e5\u770b\u8be6\u60c5(\u8ba2\u5355)")
    @RequestMapping(value={"/orderdetail"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public DataResponse orderdetail(HttpServletRequest request, @RequestParam(value="id") String id) {
        DataResponse response = new DataResponse();
        try {
            ZyfxApplyOrder applyInfo = (ZyfxApplyOrder)this.zyfxApplyOrderService.getById((Serializable)((Object)id));
            List applies = this.applyService.list((Wrapper)Wrappers.lambdaQuery(ZyfxObjectApply.class).in(ZyfxObjectApply::getOrderid, new Object[]{id}));
            applies.forEach(p -> p.setApprovals(this.applyService.findDetailById(p.getId()).getApprovals()));
            applyInfo.setDetails(applies);
            response.setResult((Object)applyInfo);
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="5-\u4e0b\u8f7d\u7533\u8bf7\u6570\u636e")
    @RequestMapping(value={"/downloadFile"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void downloadFile(@RequestParam(value="applyId") String applyId) throws Exception {
        this.applyService.download(applyId);
    }

    @ApiOperation(value="6-\u5220\u9664\u7533\u8bf7")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse delete(HttpServletRequest request, @RequestParam(value="id") String id) {
        DataResponse response = new DataResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            this.applyService.removeById((Serializable)((Object)id));
            response.setResult((Object)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="7-\u5220\u9664\u7533\u8bf7(\u8ba2\u5355)")
    @RequestMapping(value={"/deleteByOrderid"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse deleteByOrderid(HttpServletRequest request, @RequestParam(value="orderId") String orderId) {
        DataResponse response = new DataResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            ZyfxApplyOrder zyfxApplyOrder = (ZyfxApplyOrder)this.zyfxApplyOrderService.getById((Serializable)((Object)orderId));
            List applies = this.applyService.list((Wrapper)Wrappers.lambdaQuery(ZyfxObjectApply.class).in(ZyfxObjectApply::getOrderid, new Object[]{orderId}));
            applies.forEach(t -> this.applyService.deleteAllById(t.getId()));
            this.zyfxApplyOrderService.removeById((Serializable)((Object)orderId));
            response.setResult((Object)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="8-\u67e5\u770b\u8ba2\u5355\u6570\u636e")
    @RequestMapping(value={"/orderData"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public DataResponse orderData(HttpServletRequest request, @RequestParam(value="id") String id, @RequestParam(value="havaDataSet", defaultValue="false", required=false) Boolean havaDataSet) {
        DataResponse response = new DataResponse();
        try {
            boolean isTempUrl = true;
            ArrayList<ZyfxObjectDetail> zyfxObjectDetailList = new ArrayList<ZyfxObjectDetail>();
            List applies = this.applyService.list((Wrapper)Wrappers.lambdaQuery(ZyfxObjectApply.class).in(ZyfxObjectApply::getOrderid, new Object[]{id}));
            for (ZyfxObjectApply apply : applies) {
                ZyfxObjectDetail zyfxObjectDetail = this.zyfxObjectService.findDetailById(apply.getObjectid(), apply.getUserid(), havaDataSet, isTempUrl);
                zyfxObjectDetail.setApplies(this.applyService.findDetailById(apply.getId()));
                zyfxObjectDetailList.add(zyfxObjectDetail);
            }
            response.setResult(zyfxObjectDetailList);
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="8-\u67e5\u770b\u7533\u8bf7\u6570\u636e")
    @RequestMapping(value={"/applyData"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public DataResponse applyData(HttpServletRequest request, @RequestParam(value="id") String id, @RequestParam(value="havaDataSet", defaultValue="false", required=false) Boolean havaDataSet) {
        DataResponse detailDataResponse = new DataResponse();
        try {
            boolean isTempUrl = true;
            ZyfxObjectApply applies = this.applyService.findDetailById(id);
            ZyfxObjectDetail detail = this.zyfxObjectService.findDetailById(applies.getObjectid(), applies.getUserid(), havaDataSet, isTempUrl);
            detail.setApplies(applies);
            detailDataResponse.setResult((Object)detail);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            detailDataResponse.markFailure(e.getMessage());
        }
        return detailDataResponse;
    }

    @ApiOperation(value="9-\u6211\u7684\u8d44\u6e90")
    @RequestMapping(value={"/myResources"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse myResources(HttpServletRequest request, PageParam page, String name, Integer resourceType, Integer authorizationType) {
        RowsResponse response = new RowsResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            List<Map<String, Object>> resourcesList = this.zyfxObjectService.findMyResources(sysUser.getId(), name, resourceType, authorizationType);
            response.setRows(resourcesList.subList((page.getPage() - 1) * page.getSize(), page.getPage() * page.getSize() > resourcesList.size() ? resourcesList.size() : page.getPage() * page.getSize()));
            response.setTotal(Long.valueOf(resourcesList.size()));
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }
}

