/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.adf.gbpm.flow.service.GbpmTaskService;
import com.geoway.ns.flowable.service.ShareFlowService;
import com.geoway.ns.proxy.dto.ProxyObjectLimit;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.dto.RowsResponse;
import com.geoway.ns.sys.dto.SimpleRole;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.utils.MyRequestUtil;
import com.geoway.ns.zyfx.constant.datacenter.EnumDataApplyType;
import com.geoway.ns.zyfx.domain.ZyfxApplyOrder;
import com.geoway.ns.zyfx.domain.ZyfxObjectApply;
import com.geoway.ns.zyfx.domain.ZyfxObjectApproval;
import com.geoway.ns.zyfx.dto.ZyfxApplyFilterDTO;
import com.geoway.ns.zyfx.service.ZyfxApplyOrderService;
import com.geoway.ns.zyfx.service.ZyfxObjectApplyService;
import com.geoway.ns.zyfx.service.ZyfxObjectApprovalService;
import com.geoway.ns.zyfx.utils.ObjectUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import liquibase.repackaged.org.apache.commons.lang3.StringUtils;
import org.flowable.task.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d44\u6e90\u53d1\u73b0\u5bf9\u8c61\uff08\u6570\u636e\u3001\u670d\u52a1\u3001\u5de5\u5177\uff09\u5ba1\u6279\u63a5\u53e3"})
@RestController
@RequestMapping(value={"zyfx/check"})
public class zyfxObjectCheckController {
    private static final Logger log = LoggerFactory.getLogger(zyfxObjectCheckController.class);
    @Resource
    private ITokenService tokenService;
    @Resource
    private ZyfxObjectApplyService applyService;
    @Resource
    ZyfxObjectApprovalService zyfxObjectApprovalService;
    @Resource
    ZyfxApplyOrderService zyfxApplyOrderService;
    @Autowired
    ShareFlowService shareFlowService;
    @Autowired
    private GbpmTaskService gbpmTaskService;

    @ApiOperation(value="1-\u5206\u9875\u67e5\u8be2-\u8d44\u6e90\u5217\u8868")
    @RequestMapping(value={"/listPage"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RowsResponse searchPage(HttpServletRequest request, ZyfxApplyFilterDTO dataApplyFilterDTO) {
        RowsResponse response = new RowsResponse();
        try {
            dataApplyFilterDTO.setHasReadApply(-1);
            dataApplyFilterDTO.setHasReadCheck(dataApplyFilterDTO.getHasRead());
            dataApplyFilterDTO.setApplyType(EnumDataApplyType.Initiative.value);
            IPage<ZyfxObjectApply> resultPage = this.applyService.queryPageByFilter(dataApplyFilterDTO);
            if (this.shareFlowService.checkFlowInfo(dataApplyFilterDTO.getGrouptype()).booleanValue()) {
                for (ZyfxObjectApply apply : resultPage.getRecords()) {
                    List<Task> tasks = this.shareFlowService.queryTaskListByBusinessKey(apply.getId());
                    if (tasks != null && tasks.size() > 0) {
                        Task task = tasks.get(0);
                        apply.setCurrentTaskId(task.getId());
                        apply.setCurrentTaskName(task.getName());
                        apply.setTaskCreateTime(task.getCreateTime());
                        apply.setProcessInstanceId(task.getProcessInstanceId());
                        apply.setCurrentAssignee(task.getAssignee());
                        ShareFlowService.NextNodeAssignee currentNodeAssignee = this.shareFlowService.getCurrentNodeAssignees(task);
                        apply.setCurrentNodeAssignee(currentNodeAssignee);
                    }
                    apply.setFlowEnabled(true);
                }
            }
            response.setRows(resultPage.getRecords());
            response.setTotal(Long.valueOf(resultPage.getTotal()));
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="2-\u5206\u9875\u67e5\u8be2-\u8ba2\u5355\u5217\u8868")
    @RequestMapping(value={"/orderListPage"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public RowsResponse searchPageByOrder(HttpServletRequest request, ZyfxApplyFilterDTO dataApplyFilterDTO) {
        RowsResponse response = new RowsResponse();
        try {
            dataApplyFilterDTO.setHasReadApply(-1);
            dataApplyFilterDTO.setHasReadCheck(dataApplyFilterDTO.getHasRead());
            IPage<ZyfxApplyOrder> resultPage = this.applyService.queryOrderPageByFilter(dataApplyFilterDTO);
            dataApplyFilterDTO.setApplyType(EnumDataApplyType.Initiative.value);
            response.setRows(resultPage.getRecords());
            response.setTotal(Long.valueOf(resultPage.getTotal()));
        }
        catch (Exception ex) {
            response.markFailure();
            response.setMessage(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="3-\u8d44\u6e90\u5ba1\u6838-\u8d44\u6e90")
    @RequestMapping(value={"/check"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse check(HttpServletRequest request, @RequestBody ZyfxObjectApply shareServiceApplyInfo, @ModelAttribute ProxyObjectLimit proxyObjectLimit, @RequestParam(value="checkstatus", defaultValue="0", required=false) Integer checkstatus, @RequestParam(value="comment", required=false) String comment) {
        DataResponse response = new DataResponse();
        try {
            shareServiceApplyInfo.setCreatetime(new Date());
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            if (!this.tokenService.isChecker(sysUser).booleanValue()) {
                return DataResponse.error((String)"\u5f53\u524d\u7528\u6237\u65e0\u5ba1\u6279\u6743\u9650");
            }
            if (shareServiceApplyInfo.getApprovals() == null) {
                final ZyfxObjectApproval zyfxObjectApproval = new ZyfxObjectApproval();
                zyfxObjectApproval.setObjectid(shareServiceApplyInfo.getId());
                zyfxObjectApproval.setCheckstatus(checkstatus + "");
                zyfxObjectApproval.setCheckuserid(sysUser.getId());
                zyfxObjectApproval.setCheckusername(sysUser.getUsername());
                zyfxObjectApproval.setComment(comment);
                zyfxObjectApproval.setObjectname(shareServiceApplyInfo.getObjectname());
                zyfxObjectApproval.setCreatetime(LocalDateTime.now());
                zyfxObjectApproval.setUpdatetime(LocalDateTime.now());
                shareServiceApplyInfo.setApprovals((List<ZyfxObjectApproval>)new ArrayList<ZyfxObjectApproval>(){
                    {
                        this.add(zyfxObjectApproval);
                    }
                });
            } else {
                shareServiceApplyInfo.getApprovals().forEach(f -> {
                    f.setObjectid(shareServiceApplyInfo.getId());
                    f.setCheckuserid(sysUser.getId());
                    f.setCheckusername(sysUser.getUsername());
                    f.setObjectname(shareServiceApplyInfo.getObjectname());
                    f.setCreatetime(LocalDateTime.now());
                    f.setUpdatetime(LocalDateTime.now());
                });
            }
            this.applyService.check(shareServiceApplyInfo, proxyObjectLimit);
            response.setResult((Object)shareServiceApplyInfo);
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="4-\u8d44\u6e90\u5ba1\u6838-\u975e\u8ba2\u5355")
    @RequestMapping(value={"/simpleCheck"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse simpleCheck(HttpServletRequest request, @ModelAttribute ProxyObjectLimit proxyObjectLimit, @RequestParam(value="checkstatus", defaultValue="0", required=false) Integer checkstatus, @RequestParam(value="comment", required=false) String comment, @RequestParam(value="applyid") String applyid, @RequestParam(value="nextRoleId") String nextRoleId) {
        DataResponse response = new DataResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            if (!this.tokenService.isChecker(sysUser).booleanValue()) {
                return DataResponse.error((String)"\u5f53\u524d\u7528\u6237\u65e0\u5ba1\u6279\u6743\u9650");
            }
            ZyfxObjectApply zyfxObjectApply = this.applyService.findDetailById(applyid);
            if (this.shareFlowService.checkFlowInfo(zyfxObjectApply.getGrouptype()).booleanValue()) {
                List<Task> nextTasks = this.shareFlowService.queryTaskListByBusinessKey(zyfxObjectApply.getId());
                if (!nextTasks.isEmpty()) {
                    Task nextTask = nextTasks.get(0);
                    if (checkstatus == 2) {
                        this.shareFlowService.approveTask(nextTask.getId(), sysUser.getId(), sysUser.getAlisname(), sysUser.getXzqdm(), comment, ObjectUtils.objectToMap(proxyObjectLimit), StringUtils.isEmpty((CharSequence)nextRoleId) ? null : nextRoleId);
                        boolean isCompleted = this.shareFlowService.checkAndHandleProcessComplete(zyfxObjectApply.getId());
                        if (isCompleted) {
                            log.info("\u6d41\u7a0b\u5df2\u5168\u90e8\u5b8c\u6210 - \u7533\u8bf7ID: {}", (Object)zyfxObjectApply.getId());
                        }
                    } else {
                        this.shareFlowService.rejectTask(nextTask.getId(), sysUser.getId(), sysUser.getAlisname(), sysUser.getXzqdm(), comment, ObjectUtils.objectToMap(proxyObjectLimit));
                        zyfxObjectApply.setCheckstatus(3);
                        this.applyService.saveOrUpdate(zyfxObjectApply);
                    }
                } else {
                    zyfxObjectApply.setCheckstatus(2);
                    this.applyService.saveOrUpdate(zyfxObjectApply);
                }
            } else {
                List allApplies;
                zyfxObjectApply.setCheckstatus(checkstatus);
                if (zyfxObjectApply.getApprovals() == null || zyfxObjectApply.getApprovals().size() == 0) {
                    final ZyfxObjectApproval zyfxObjectApproval = new ZyfxObjectApproval();
                    zyfxObjectApproval.setObjectid(zyfxObjectApply.getId());
                    zyfxObjectApproval.setCheckstatus(checkstatus + "");
                    zyfxObjectApproval.setCheckuserid(sysUser.getId());
                    zyfxObjectApproval.setCheckusername(sysUser.getUsername());
                    zyfxObjectApproval.setComment(comment);
                    zyfxObjectApproval.setObjectname(zyfxObjectApply.getObjectname());
                    zyfxObjectApproval.setCreatetime(LocalDateTime.now());
                    zyfxObjectApproval.setUpdatetime(LocalDateTime.now());
                    zyfxObjectApply.setApprovals((List<ZyfxObjectApproval>)new ArrayList<ZyfxObjectApproval>(){
                        {
                            this.add(zyfxObjectApproval);
                        }
                    });
                }
                this.applyService.check(zyfxObjectApply, proxyObjectLimit);
                if (zyfxObjectApply.getOrderid() != null && !zyfxObjectApply.getOrderid().isEmpty() && (allApplies = this.applyService.list((Wrapper)Wrappers.lambdaQuery(ZyfxObjectApply.class).eq(ZyfxObjectApply::getOrderid, (Object)zyfxObjectApply.getOrderid()))) != null && allApplies.size() > 0) {
                    boolean hasDoing = allApplies.stream().anyMatch(apply -> apply.getCheckstatus() != null && (apply.getCheckstatus() == 0 || apply.getCheckstatus() == 1));
                    boolean hasRejected = allApplies.stream().anyMatch(apply -> apply.getCheckstatus() != null && apply.getCheckstatus() == 3);
                    boolean allApproved = allApplies.stream().allMatch(apply -> apply.getCheckstatus() != null && apply.getCheckstatus() == 2);
                    ZyfxApplyOrder zyfxApplyOrder = (ZyfxApplyOrder)this.zyfxApplyOrderService.getById((Serializable)((Object)zyfxObjectApply.getOrderid()));
                    if (zyfxApplyOrder != null) {
                        if (hasDoing) {
                            zyfxApplyOrder.setStatus(1);
                        } else if (hasRejected) {
                            zyfxApplyOrder.setStatus(3);
                        } else if (allApproved) {
                            zyfxApplyOrder.setStatus(2);
                        }
                        if (hasRejected || allApproved) {
                            this.zyfxApplyOrderService.updateById(zyfxApplyOrder);
                        }
                    }
                }
            }
            response.setResult((Object)zyfxObjectApply);
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="5-\u8d44\u6e90\u5ba1\u6838-\u8ba2\u5355")
    @RequestMapping(value={"/orderCheck"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse orderCheck(HttpServletRequest request, @ModelAttribute ProxyObjectLimit proxyObjectLimit, @RequestParam(value="checkstatus", defaultValue="0", required=false) Integer checkstatus, @RequestParam(value="comment", required=false) String comment, @RequestParam(value="orderid") String orderid) {
        DataResponse response = new DataResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            if (!this.tokenService.isChecker(sysUser).booleanValue()) {
                return DataResponse.error((String)"\u5f53\u524d\u7528\u6237\u65e0\u5ba1\u6279\u6743\u9650");
            }
            List<ZyfxObjectApply> applies = this.applyService.orderCheck(sysUser, proxyObjectLimit, checkstatus, comment, orderid);
            response.setResult(applies);
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="6-\u8bbe\u7f6e\u6d88\u606f\u4e3a\u5df2\u8bfb")
    @PostMapping(value={"setHasReadById"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse setHasReadById(HttpServletRequest request, @RequestParam(value="id") String id, @RequestParam(value="hasRead", required=false, defaultValue="1") Integer hasRead) {
        BaseResponse response = new BaseResponse();
        try {
            ZyfxObjectApply applyInfo = this.applyService.findDetailById(id);
            if (applyInfo.getApprovals() != null) {
                applyInfo.getApprovals().forEach(f -> f.setApplyread(hasRead));
                this.zyfxObjectApprovalService.saveOrUpdateBatch(applyInfo.getApprovals());
            }
            this.applyService.updateById(applyInfo);
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="7-\u91cd\u65b0\u63d0\u53d6")
    @RequestMapping(value={"/reexport"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse reExport(HttpServletRequest request, @RequestParam(value="id") String id) {
        BaseResponse response = new BaseResponse();
        try {
            this.applyService.reExport(id);
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="8-\u5220\u9664\u7533\u8bf7-\u8d44\u6e90")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse delete(HttpServletRequest request, @RequestParam(value="id") String id) {
        DataResponse response = new DataResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            this.applyService.removeById((Serializable)((Object)id));
            response.setResult((Object)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="9-\u5220\u9664\u7533\u8bf7-\u8ba2\u5355")
    @RequestMapping(value={"/deleteByOrderid"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse deleteByOrderid(HttpServletRequest request, @RequestParam(value="orderId") String orderId) {
        DataResponse response = new DataResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            ZyfxApplyOrder zyfxApplyOrder = (ZyfxApplyOrder)this.zyfxApplyOrderService.getById((Serializable)((Object)orderId));
            List applies = this.applyService.list((Wrapper)Wrappers.lambdaQuery(ZyfxObjectApply.class).in(ZyfxObjectApply::getOrderid, new Object[]{orderId}));
            applies.stream().forEach(t -> this.applyService.deleteAllById(t.getId()));
            this.zyfxApplyOrderService.removeById((Serializable)((Object)orderId));
            response.setResult((Object)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    @ApiOperation(value="10-\u5f85\u529e\u7edf\u8ba1")
    @RequestMapping(value={"/todoCount"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public BaseResponse getTodoCount(HttpServletRequest request, @RequestParam(value="grouptype", required=true) Short grouptype) {
        DataResponse response = new DataResponse();
        try {
            String token = MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request);
            SysUserDTO sysUser = this.tokenService.querySysUserByToken(token);
            if (sysUser == null) {
                return DataResponse.error((String)"\u7cfb\u7edf\u672a\u767b\u5165");
            }
            if (!this.tokenService.isChecker(sysUser).booleanValue()) {
                return DataResponse.error((String)"\u5f53\u524d\u7528\u6237\u65e0\u5ba1\u6279\u6743\u9650");
            }
            long count = 0L;
            if (grouptype != null && this.shareFlowService.checkFlowInfo(grouptype).booleanValue()) {
                ZyfxApplyFilterDTO dataApplyFilterDTO = new ZyfxApplyFilterDTO();
                dataApplyFilterDTO.setHasReadApply(-1);
                dataApplyFilterDTO.setStatus(0);
                dataApplyFilterDTO.setHasReadCheck(dataApplyFilterDTO.getHasRead());
                dataApplyFilterDTO.setApplyType(EnumDataApplyType.Initiative.value);
                dataApplyFilterDTO.setPage(1);
                dataApplyFilterDTO.setSize(100);
                IPage<ZyfxObjectApply> resultPage = this.applyService.queryPageByFilter(dataApplyFilterDTO);
                for (ZyfxObjectApply apply : resultPage.getRecords()) {
                    String currentAssignee;
                    Task task;
                    ShareFlowService.NextNodeAssignee currentNodeAssignee;
                    List<Task> tasks = this.shareFlowService.queryTaskListByBusinessKey(apply.getId());
                    if (tasks == null || tasks.size() <= 0 || (currentNodeAssignee = this.shareFlowService.getCurrentNodeAssignees(task = tasks.get(0))) == null) continue;
                    ArrayList<String> userRoleIds = new ArrayList<String>();
                    if (sysUser.getRoles() != null) {
                        for (SimpleRole role : sysUser.getRoles()) {
                            String roleId = role.getId();
                            if (roleId == null) continue;
                            userRoleIds.add("R" + roleId);
                        }
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(currentAssignee = task.getAssignee()))) {
                        if (!userRoleIds.contains(currentAssignee)) continue;
                        ++count;
                        continue;
                    }
                    List<String> candidateGroupIds = currentNodeAssignee.getCandidateGroupIds();
                    if (candidateGroupIds == null || candidateGroupIds.isEmpty()) continue;
                    boolean hasMatchingRole = false;
                    for (String groupId : candidateGroupIds) {
                        if (!userRoleIds.contains(groupId)) continue;
                        hasMatchingRole = true;
                        break;
                    }
                    if (!hasMatchingRole) continue;
                    ++count;
                }
                response.setResult((Object)count);
            } else {
                count = this.applyService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ZyfxObjectApply.class).eq(ZyfxObjectApply::getCheckstatus, (Object)0)).eq(grouptype != null, ZyfxObjectApply::getGrouptype, (Object)grouptype));
            }
            response.setResult((Object)count);
        }
        catch (Exception ex) {
            response.markFailure(ex.getMessage());
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }
}

