/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service;

import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictLevelDTO;
import com.geoway.adf.dms.datasource.dto.district.DmDistrictDTO;
import com.geoway.adf.dms.datasource.service.DistrictService;
import com.geoway.ns.zyfx.domain.ZyfxDataset;
import com.geoway.ns.zyfx.domain.ZyfxObjectApply;
import com.geoway.ns.zyfx.dto.ZyfxObjectDetail;
import com.geoway.ns.zyfx.service.impl.export.DatumDataTaskParamsServiceImpl;
import com.geoway.ns.zyfx.service.impl.export.RasterDataTaskParamsServiceImpl;
import com.geoway.ns.zyfx.service.impl.export.TileDataTaskParamsServiceImpl;
import com.geoway.ns.zyfx.service.impl.export.VectorDataTaskParamsServiceImpl;
import com.geoway.webstore.export.dto.ExportCustomTaskUnitDTO;
import java.util.List;

public interface ExportTaskParamsService {
    public ExportCustomTaskUnitDTO toExportTaskLayerParams(String var1, ZyfxObjectApply var2);

    public static DistrictItemDTO getTargetDistrictItemDTO(ZyfxObjectApply shareDataApplyDetail) {
        if (shareDataApplyDetail == null || StringUtils.isEmpty((CharSequence)shareDataApplyDetail.getParams())) {
            return null;
        }
        JSONObject paramJson = JSONObject.parseObject((String)shareDataApplyDetail.getParams());
        if (paramJson == null || !paramJson.containsKey((Object)"extent")) {
            throw new RuntimeException("\u4e0d\u5305\u542bextent\u884c\u653f\u533a\u9650\u5236\u5b57\u6bb5");
        }
        DistrictService districtService = (DistrictService)SpringContextUtil.getBean(DistrictService.class);
        DmDistrictDTO dmDistrictDTO = districtService.list().stream().filter(f -> f.getIsDefault()).findAny().orElse(null);
        return districtService.getDistrictItemDetail(dmDistrictDTO.getId(), paramJson.getString("extent"));
    }

    public static ExportTaskParamsService getInstance(DatasetTypeEnum datasetTypeEnum) {
        switch (datasetTypeEnum) {
            case FeatureClass: {
                return (ExportTaskParamsService)SpringContextUtil.getBean(VectorDataTaskParamsServiceImpl.class);
            }
            case MosaicDataset: {
                return (ExportTaskParamsService)SpringContextUtil.getBean(RasterDataTaskParamsServiceImpl.class);
            }
            case TileDataset: {
                return (ExportTaskParamsService)SpringContextUtil.getBean(TileDataTaskParamsServiceImpl.class);
            }
            case DatumDataset: {
                return (ExportTaskParamsService)SpringContextUtil.getBean(DatumDataTaskParamsServiceImpl.class);
            }
        }
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u7684\u63d0\u53d6\uff1a" + datasetTypeEnum.getDesc());
    }

    public static int getTargetXzqDistrictLevel(ZyfxObjectApply shareDataApplyDetail) {
        DmDistrictDTO defaultDistrictDTO;
        if (shareDataApplyDetail == null || StringUtils.isEmpty((CharSequence)shareDataApplyDetail.getParams())) {
            throw new RuntimeException("\u7533\u8bf7\u6570\u636e\u8ba2\u5355\u6570\u636e\u6709\u8bef");
        }
        JSONObject paramJson = JSONObject.parseObject((String)shareDataApplyDetail.getParams());
        if (paramJson == null || !paramJson.containsKey((Object)"orgType")) {
            throw new RuntimeException("\u4e0d\u5305\u542borgType\u5b57\u6bb5");
        }
        DistrictService districtService = (DistrictService)SpringContextUtil.getBean(DistrictService.class);
        List districtLevelDTOS = districtService.getDistrictLevels((defaultDistrictDTO = (DmDistrictDTO)districtService.list().stream().filter(f -> f.getIsDefault()).findAny().orElse(null)).getId());
        DistrictLevelDTO levelDTO = districtLevelDTOS.stream().filter(f -> f.getIndex().equals(Short.parseShort(paramJson.getString("orgType")))).findAny().orElse(null);
        if (levelDTO == null) {
            throw new RuntimeException("\u4e0d\u5b58\u5728\u884c\u653f\u533a\u5212\u7ea7\u522b\uff1a" + paramJson.getString("orgType"));
        }
        return levelDTO.getIndex().shortValue();
    }

    public static String getRealDatasetId(ZyfxObjectDetail shareDataApplyDetail) {
        return ((ZyfxDataset)shareDataApplyDetail.getDetail()).getDataid();
    }

    public static DatasetTypeEnum getDatasetTypeEnumByName(String name) {
        DatasetTypeEnum[] items = DatasetTypeEnum.values();
        Integer i = 0;
        while (i < items.length) {
            DatasetTypeEnum item = items[i];
            if (item.name().equalsIgnoreCase(name)) {
                return item;
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return DatasetTypeEnum.Unknown;
    }
}

