/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import com.alibaba.fastjson.JSON;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.zyfx.service.DataEncryptService;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.FutureTask;
import org.geomark.geocontrol.NativeMethod;
import org.geomark.geocontrol.util.CommonResponse;
import org.geomark.geocontrol.util.GeoResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class DataEncryptServiceImpl
implements DataEncryptService {
    private final Logger log = LoggerFactory.getLogger(DataEncryptServiceImpl.class);
    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    public BaseResponse init(String key) {
        BaseResponse responseData = new BaseResponse();
        try {
            GeoResponse init = NativeMethod.Init((String)key);
            this.log.info("\u3010\u6570\u636e\u52a0\u5bc6\u3011Init\uff1a" + JSON.toJSONString((Object)init));
            if (init.getCode() != CommonResponse.Init_Success.getCode()) {
                this.log.info("\u3010\u6570\u636e\u52a0\u5bc6\u3011\u521d\u59cb\u5316\u5931\u8d25\uff1a" + init.getMsg());
                return BaseResponse.error((String)init.getMsg(), (Integer)init.getCode());
            }
            this.redisTemplate.boundHashOps((Object)("encrypt:" + key)).put((Object)key, (Object)key);
            responseData.setStatus(init.getData());
            responseData.setMessage(init.getMsg());
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return responseData;
    }

    @Override
    public BaseResponse getState(String dataPath) {
        BaseResponse responseData = new BaseResponse();
        try {
            GeoResponse state = NativeMethod.GetFileState((String)dataPath);
            this.log.info("\u3010\u6570\u636e\u52a0\u5bc6\u3011GetFileState\uff1a" + JSON.toJSONString((Object)state));
            if (state.getCode() != CommonResponse.FileState_Plain.getCode()) {
                this.log.info("\u3010\u6570\u636e\u52a0\u5bc6\u3011\u83b7\u53d6\u52a0\u5bc6\u72b6\u6001\u5931\u8d25\uff1a" + state.getMsg());
                return BaseResponse.error((String)state.getMsg(), (Integer)state.getCode());
            }
            responseData.setStatus(state.getData());
            responseData.setMessage(state.getMsg());
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return responseData;
    }

    @Override
    public BaseResponse encrypt(String dataPath, String user, Date encEnd) {
        BaseResponse responseData = new BaseResponse();
        try {
            GeoResponse encrypt = NativeMethod.EncryptFile((String)dataPath, (String)user, (Date)DataEncryptServiceImpl.changeDate(encEnd));
            this.log.info("\u3010\u6570\u636e\u52a0\u5bc6\u3011EncryptFile\uff1a" + JSON.toJSONString((Object)encrypt));
            if (encrypt.getCode() != CommonResponse.FileState_Cipher.getCode()) {
                this.log.info("\u3010\u6570\u636e\u52a0\u5bc6\u3011\u52a0\u5bc6\u5931\u8d25\uff1a" + encrypt.getMsg());
                return BaseResponse.error((String)encrypt.getMsg(), (Integer)encrypt.getCode());
            }
            responseData.setStatus(encrypt.getData());
            responseData.setMessage(encrypt.getMsg());
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return responseData;
    }

    @Override
    public BaseResponse decrypt(String dataPath) {
        BaseResponse responseData = new BaseResponse();
        try {
            GeoResponse decrypt = NativeMethod.DecryptFile((String)dataPath);
            this.log.info("\u3010\u6570\u636e\u52a0\u5bc6\u3011DecryptFile\uff1a" + JSON.toJSONString((Object)decrypt));
            if (decrypt.getCode() != CommonResponse.FileState_Plain.getCode()) {
                this.log.info("\u3010\u6570\u636e\u52a0\u5bc6\u3011\u89e3\u5bc6\u5931\u8d25\uff1a" + decrypt.getMsg());
                return BaseResponse.error((String)decrypt.getMsg(), (Integer)decrypt.getCode());
            }
            responseData.setStatus(decrypt.getData());
            responseData.setMessage(decrypt.getMsg());
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return responseData;
    }

    @Override
    public BaseResponse renew(String dir, String user, Date renewDate, Date start, Date end) {
        BaseResponse responseData = new BaseResponse();
        try {
            Date[] times = new Date[]{DataEncryptServiceImpl.changeDate(start), DataEncryptServiceImpl.changeDate(end)};
            GeoResponse renew = NativeMethod.GenerateRenewAgreement((String)dir, (String)user, (Date)DataEncryptServiceImpl.changeDate(renewDate), (Date[])times);
            this.log.info("\u3010\u6570\u636e\u52a0\u5bc6\u3011GenerateRenewAgreement\uff1a" + JSON.toJSONString((Object)renew));
            if (renew.getCode() != CommonResponse.Function_Success.getCode()) {
                this.log.info("\u3010\u6570\u636e\u52a0\u5bc6\u3011\u751f\u6210\u7eed\u671f\u8bb8\u53ef\u5931\u8d25\uff1a" + renew.getMsg());
                return BaseResponse.error((String)renew.getMsg(), (Integer)renew.getCode());
            }
            responseData.setStatus(renew.getData());
            responseData.setMessage(renew.getMsg());
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return responseData;
    }

    @Override
    public BaseResponse oneEncrypt(String dataPath, String key, String user, Date encEnd) {
        BaseResponse responseData = new BaseResponse();
        try {
            GeoResponse data = new GeoResponse(200, "\u6210\u529f");
            Boolean isInit = Optional.ofNullable(this.redisTemplate.hasKey((Object)("encrypt:" + key))).orElse(false);
            this.log.info("\u3010\u6570\u636e\u52a0\u5bc6oneEncrypt\u3011isInit\uff1a" + JSON.toJSONString((Object)isInit));
            if (!isInit.booleanValue()) {
                data = NativeMethod.Init((String)key);
                this.log.info("\u3010\u6570\u636e\u52a0\u5bc6oneEncrypt\u3011Init\uff1a" + JSON.toJSONString((Object)data));
            }
            data = NativeMethod.GetFileState((String)dataPath);
            this.log.info("\u3010\u6570\u636e\u52a0\u5bc6oneEncrypt\u3011GetFileState\uff1a" + JSON.toJSONString((Object)data));
            if (data.getCode() == CommonResponse.FileState_Cipher.getCode()) {
                this.log.info("\u3010\u6570\u636e\u52a0\u5bc6oneEncrypt\u3011\u5df2\u52a0\u5bc6\uff1a" + data.getMsg());
                responseData.setStatus(data.getData());
                responseData.setMessage(data.getMsg());
                return responseData;
            }
            data = NativeMethod.Encrypt3((String)dataPath, (String)user, (Date)DataEncryptServiceImpl.changeDate(encEnd));
            this.log.info("\u3010\u6570\u636e\u52a0\u5bc6oneEncrypt\u3011EncryptFile\uff1a" + JSON.toJSONString((Object)data));
            if (data.getCode() != CommonResponse.Success.getCode()) {
                this.log.info("\u3010\u6570\u636e\u52a0\u5bc6oneEncrypt\u3011\u52a0\u5bc6\u5931\u8d25\uff1a" + data.getMsg());
                return BaseResponse.error((String)data.getMsg(), (Integer)data.getCode());
            }
            responseData.setStatus(data.getData());
            responseData.setMessage(data.getMsg());
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return responseData;
    }

    @Override
    public BaseResponse oneDecrypt(String key, String dataPath) {
        BaseResponse responseData = new BaseResponse();
        try {
            GeoResponse data = new GeoResponse(200, "\u6210\u529f");
            Boolean isInit = Optional.ofNullable(this.redisTemplate.hasKey((Object)("encrypt:" + key))).orElse(false);
            this.log.info("\u3010\u6570\u636e\u52a0\u5bc6oneDecrypt\u3011isInit\uff1a" + JSON.toJSONString((Object)isInit));
            if (!isInit.booleanValue()) {
                data = NativeMethod.Init((String)key);
                this.log.info("\u3010\u6570\u636e\u52a0\u5bc6oneDecrypt\u3011Init\uff1a" + JSON.toJSONString((Object)data));
            }
            data = NativeMethod.GetFileState((String)dataPath);
            this.log.info("\u3010\u6570\u636e\u52a0\u5bc6oneDecrypt\u3011GetFileState\uff1a" + JSON.toJSONString((Object)data));
            if (data.getCode() == CommonResponse.FileState_Plain.getCode()) {
                this.log.info("\u3010\u6570\u636e\u52a0\u5bc6oneDecrypt\u3011\u6587\u4ef6\u5df2\u89e3\u5bc6\uff1a" + data.getMsg());
                responseData.setStatus(data.getData());
                responseData.setMessage(data.getMsg());
                return responseData;
            }
            data = NativeMethod.DecryptFile((String)dataPath);
            this.log.info("\u3010\u6570\u636e\u52a0\u5bc6oneDecrypt\u3011DecryptFile\uff1a" + JSON.toJSONString((Object)data));
            if (data.getCode() != CommonResponse.FileState_Plain.getCode()) {
                this.log.info("\u3010\u6570\u636e\u52a0\u5bc6\u3011\u89e3\u5bc6\u5931\u8d25\uff1a" + data.getMsg());
                return BaseResponse.error((String)data.getMsg(), (Integer)data.getCode());
            }
            responseData.setStatus(data.getData());
            responseData.setMessage(data.getMsg());
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return responseData;
    }

    @Override
    public BaseResponse oneRenew(String dir, String user, Date renewDate, Date start, Date end) {
        BaseResponse responseData = new BaseResponse();
        try {
            Date[] times = new Date[]{DataEncryptServiceImpl.changeDate(start), DataEncryptServiceImpl.changeDate(end)};
            GeoResponse renew = NativeMethod.GenerateRenewAgreement((String)dir, (String)user, (Date)DataEncryptServiceImpl.changeDate(renewDate), (Date[])times);
            this.log.info("\u3010\u6570\u636e\u52a0\u5bc6oneRenew\u3011GenerateRenewAgreement\uff1a" + JSON.toJSONString((Object)renew));
            if (renew.getCode() != CommonResponse.Function_Success.getCode()) {
                this.log.info("\u3010\u6570\u636e\u52a0\u5bc6oneRenew\u3011\u751f\u6210\u7eed\u671f\u8bb8\u53ef\u5931\u8d25\uff1a" + renew.getMsg());
                return BaseResponse.error((String)renew.getMsg(), (Integer)renew.getCode());
            }
            responseData.setStatus(renew.getData());
            responseData.setMessage(renew.getMsg());
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return responseData;
    }

    private static List<List<String>> divide(String dataPath, Integer threadCount) {
        int i;
        String[] paths = dataPath.split(",");
        ArrayList folders = new ArrayList();
        for (String path : paths) {
            DataEncryptServiceImpl.getFolders(path).stream().forEach(f -> folders.add(f));
        }
        ArrayList<List<String>> results = new ArrayList<List<String>>();
        for (i = 0; i < threadCount; ++i) {
            ArrayList temp = new ArrayList();
            results.add(temp);
        }
        i = 0;
        while ((long)i < folders.stream().count()) {
            int num = i % threadCount;
            ((List)results.get(num)).add(folders.get(i));
            ++i;
        }
        return results;
    }

    private static FutureTask<Boolean> encryptFile(List<String> folderPaths) {
        Date end = new Date(122, 0, 1);
        FutureTask<Boolean> ft = new FutureTask<Boolean>(() -> {
            for (String folder : folderPaths) {
                List<File> files = DataEncryptServiceImpl.getListFiles(folder);
                for (File file : files) {
                    GeoResponse state = NativeMethod.GetFileState((String)file.getPath());
                    if (state.getCode() != CommonResponse.FileState_Plain.getCode()) {
                        System.out.println(file.getPath() + ":\u5bc6\u6587\u65e0\u9700\u52a0\u5bc6");
                        continue;
                    }
                    state = NativeMethod.EncryptFile((String)file.getPath(), (String)"\u975e\u6307\u5b9a\u5355\u4f4d", (Date)end);
                    if (state.getCode() == CommonResponse.FileState_Cipher.getCode()) continue;
                    System.out.println(file.getPath() + "\u6570\u636e\u52a0\u5bc6\u5931\u8d25\uff1a" + state.getMsg());
                }
            }
            return true;
        });
        Thread computeThread = new Thread(ft);
        computeThread.start();
        return ft;
    }

    private static FutureTask<Boolean> decryptFile(List<String> folderPaths) {
        FutureTask<Boolean> ft = new FutureTask<Boolean>(() -> {
            for (String folder : folderPaths) {
                List<File> files = DataEncryptServiceImpl.getListFiles(folder);
                for (File file : files) {
                    GeoResponse state = NativeMethod.GetFileState((String)file.getPath());
                    if (state.getCode() == CommonResponse.FileState_Plain.getCode()) {
                        return false;
                    }
                    state = NativeMethod.DecryptFile((String)file.getPath());
                    if (state.getCode() == CommonResponse.FileState_Plain.getCode()) continue;
                    System.out.println("\u6570\u636e\u89e3\u5bc6\u5931\u8d25\uff1a" + state.getMsg());
                    return false;
                }
            }
            return true;
        });
        Thread computeThread = new Thread(ft);
        computeThread.start();
        return ft;
    }

    private static Date changeDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = Optional.ofNullable(calendar.get(1)).orElse(new Date().getYear());
        int month = Optional.ofNullable(calendar.get(2) - 1).orElse(new Date().getMonth());
        int day = Optional.ofNullable(calendar.get(6)).orElse(new Date().getDay());
        return new Date(year, month, day);
    }

    public static List<File> getListFiles(Object obj) {
        File directory = null;
        directory = obj instanceof File ? (File)obj : new File(obj.toString());
        ArrayList<File> files = new ArrayList<File>();
        if (directory.isFile() && (directory.getPath().endsWith("dbf") || directory.getPath().endsWith("shp") || directory.getPath().endsWith("tif") || directory.getPath().endsWith("tif.ovr") || directory.getPath().endsWith("tiff") || directory.getPath().endsWith("tiff.ovr") || directory.getPath().endsWith("img") || directory.getPath().endsWith("img.ovr"))) {
            files.add(directory);
            return files;
        }
        if (directory.isDirectory()) {
            File[] fileArr = directory.listFiles();
            for (int i = 0; i < fileArr.length; ++i) {
                File fileOne = fileArr[i];
                files.addAll(DataEncryptServiceImpl.getListFiles(fileOne));
            }
        }
        return files;
    }

    public static List<String> getFolders(String path) {
        File directory = new File(path);
        File[] fileArr = directory.listFiles();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < fileArr.length; ++i) {
            File fileOne = fileArr[i];
            if (!fileOne.isDirectory()) continue;
            result.add(fileOne.getPath());
        }
        return result;
    }
}

