/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.ReflectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.geoway.ns.sys.support.query.MPJQueryMapperUtil;
import com.geoway.ns.zyfx.domain.ZyfxCatalog;
import com.geoway.ns.zyfx.domain.ZyfxCatalogObject;
import com.geoway.ns.zyfx.domain.ZyfxDataset;
import com.geoway.ns.zyfx.domain.ZyfxObject;
import com.geoway.ns.zyfx.domain.ZyfxObjectApply;
import com.geoway.ns.zyfx.domain.ZyfxToolset;
import com.geoway.ns.zyfx.dto.DataOverviewDTO;
import com.geoway.ns.zyfx.mapper.ZyfxCatalogMapper;
import com.geoway.ns.zyfx.mapper.ZyfxObjectMapper;
import com.geoway.ns.zyfx.service.DataStatisticsService;
import com.geoway.ns.zyfx.service.ZyfxCatalogService;
import com.geoway.ns.zyfx.service.ZyfxObjectApplyService;
import com.geoway.ns.zyfx.service.ZyfxObjectService;
import com.geoway.sso.client.client.UserClient;
import com.geoway.sso.client.rpc.RpcUserOnlineStatDTO;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataStatisticsServiceImpl
implements DataStatisticsService {
    @Autowired
    ZyfxObjectMapper zyfxObjectMapper;
    @Autowired
    ZyfxCatalogService zyfxCatalogService;
    @Autowired
    ZyfxCatalogMapper zyfxCatalogMapper;
    @Autowired
    ZyfxObjectService zyfxObjectService;
    @Autowired
    ZyfxObjectApplyService zyfxObjectApplyService;
    @Autowired
    UserClient userClient;

    @Override
    public DataOverviewDTO dataOverview(String token) throws Exception {
        DataOverviewDTO dataOverviewDTO = new DataOverviewDTO();
        List<Map<String, Object>> objectStaticsSize = this.getObjectStaticsSize();
        objectStaticsSize.forEach(map -> {
            if (map.containsKey("groupType") && map.get("groupType").equals(1)) {
                dataOverviewDTO.setDataTotal(map.containsKey("count") ? (Long)map.get("count") : 0L);
                dataOverviewDTO.setDataSize(map.containsKey("sjl") ? ((BigDecimal)map.get("sjl")).longValue() : 0L);
                dataOverviewDTO.setDataApplySize(map.containsKey("applySize") ? ((BigDecimal)map.get("applySize")).longValue() : 0L);
                dataOverviewDTO.setDataApplyTotal(map.containsKey("applyCount") ? ((BigDecimal)map.get("applyCount")).longValue() : 0L);
            } else if (map.containsKey("groupType") && map.get("groupType").equals(2)) {
                dataOverviewDTO.setServiceTotal(map.containsKey("count") ? (Long)map.get("count") : 0L);
                dataOverviewDTO.setServiceApplyTotal(map.containsKey("applyCount") ? ((BigDecimal)map.get("applyCount")).longValue() : 0L);
                dataOverviewDTO.setServiceCallTotal(map.containsKey("callCount") ? ((BigDecimal)map.get("callCount")).longValue() : 0L);
            } else if (map.containsKey("groupType") && map.get("groupType").equals(3) && map.get("isApplication").equals(0)) {
                dataOverviewDTO.setToolTotal(map.containsKey("count") ? (Long)map.get("count") : 0L);
                dataOverviewDTO.setToolApplyTotal(map.containsKey("applyCount") ? ((BigDecimal)map.get("applyCount")).longValue() : 0L);
            } else if (map.containsKey("groupType") && map.get("groupType").equals(3) && map.get("isApplication").equals(1)) {
                dataOverviewDTO.setAppTotal(map.containsKey("count") ? (Long)map.get("count") : 0L);
                dataOverviewDTO.setAppApplyTotal(map.containsKey("applyCount") ? ((BigDecimal)map.get("applyCount")).longValue() : 0L);
            } else if (map.containsKey("groupType") && map.get("groupType").equals(3) && map.get("isApplication").equals(2)) {
                dataOverviewDTO.setModelTotal(map.containsKey("count") ? (Long)map.get("count") : 0L);
                dataOverviewDTO.setModelApplyTotal(map.containsKey("applyCount") ? ((BigDecimal)map.get("applyCount")).longValue() : 0L);
            }
        });
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper4 = qmu.queryMapper("", "", ZyfxObject.class);
        queryWrapper4.selectSum(ZyfxObject::getAcount);
        List results = this.zyfxObjectMapper.selectObjs((Wrapper)queryWrapper4);
        if (results != null && results.size() > 0) {
            Object objectCount = results.get(0);
            long accessCount = objectCount == null ? 0L : ((BigDecimal)objectCount).longValue();
            dataOverviewDTO.setAccessTotal(accessCount);
        }
        TreeNodeConfig treeNodeConfig = new TreeNodeConfig();
        treeNodeConfig.setIdKey("id");
        treeNodeConfig.setParentIdKey("fatherId");
        List<ZyfxCatalog> catalogList = this.zyfxCatalogService.queryTree("", "SORT_sort_ASC", 0, "2", null, false, "");
        ArrayList unitList = new ArrayList();
        DataStatisticsServiceImpl.treeListToList(catalogList, unitList, treeNodeConfig);
        dataOverviewDTO.setUnitTotal(Long.valueOf(unitList.stream().filter(s -> !"-1".equals(s.getId()) && !"-1".equals(s.getPid())).collect(Collectors.toList()).size()));
        catalogList = this.zyfxCatalogService.queryTree("", "SORT_sort_ASC", 0, "3", null, false, "");
        ArrayList projectList = new ArrayList();
        DataStatisticsServiceImpl.treeListToList(catalogList, projectList, treeNodeConfig);
        dataOverviewDTO.setProjectTotal(Long.valueOf(projectList.stream().filter(s -> !"-1".equals(s.getId()) && !"-1".equals(s.getPid())).collect(Collectors.toList()).size()));
        RpcUserOnlineStatDTO resultObj = this.userClient.getUserOnlineStatInfo();
        if (resultObj == null) {
            dataOverviewDTO.setUserTotal(0L);
            dataOverviewDTO.setOnlineUserTotal(0L);
        } else {
            dataOverviewDTO.setUserTotal((long)resultObj.getAll() + 0L);
            dataOverviewDTO.setOnlineUserTotal((long)resultObj.getOnline() + 0L);
        }
        return dataOverviewDTO;
    }

    public static <T> List<T> treeListToList(List<T> tList, final List<T> all, final TreeNodeConfig treeNodeConfig) {
        tList.stream().forEach(new Consumer<T>(){

            @Override
            public void accept(T t) {
                List childT = (List)ReflectUtil.getFieldValue(t, (String)treeNodeConfig.getChildrenKey());
                ReflectUtil.setFieldValue(t, (String)treeNodeConfig.getChildrenKey(), null);
                if (childT != null && childT.size() > 0) {
                    DataStatisticsServiceImpl.treeListToList(childT, all, treeNodeConfig);
                } else {
                    all.add(t);
                }
            }
        });
        return new ArrayList();
    }

    @Override
    public Map<String, Object> datasetsStaticsByType(String staticType, String filterParam) throws Exception {
        HashMap<String, Object> dataList = new HashMap<String, Object>();
        Map<String, Object> objectMap = this.datasetsStatics(1, staticType, null, filterParam);
        this.mergeMap(dataList, objectMap);
        objectMap = this.datasetsStatics(2, staticType, null, filterParam);
        this.mergeMap(dataList, objectMap);
        objectMap = this.datasetsStatics(3, staticType, null, filterParam);
        this.mergeMap(dataList, objectMap);
        return dataList;
    }

    public Map<String, Object> mergeMap(Map<String, Object> alldata, Map<String, Object> data) {
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (alldata.containsKey(entry.getKey())) {
                List list1 = (List)alldata.get(entry.getKey());
                List list2 = (List)entry.getValue();
                for (Object item : list2) {
                    Map datasetsStaticsDTO = (Map)item;
                    String time = datasetsStaticsDTO.get("time").toString();
                    if (list1.stream().anyMatch(o -> ((Map)o).get("time").equals(time))) {
                        Map map = (Map)list1.stream().filter(o -> ((Map)o).get("time").equals(time)).findFirst().get();
                        Long count = datasetsStaticsDTO.get("count") == null ? 0L : Long.parseLong(datasetsStaticsDTO.get("count").toString());
                        Long sjl = datasetsStaticsDTO.get("sjl") == null ? 0L : Long.parseLong(datasetsStaticsDTO.get("sjl").toString());
                        Long accessCount = datasetsStaticsDTO.get("accessCount") == null ? 0L : Long.parseLong(datasetsStaticsDTO.get("accessCount").toString());
                        map.put("count", count + Long.parseLong(map.get("count").toString()));
                        map.put("sjl", sjl + Long.parseLong(map.get("sjl").toString()));
                        map.put("accessCount", accessCount + Long.parseLong(map.get("accessCount").toString()));
                        continue;
                    }
                    list1.add(item);
                }
                continue;
            }
            alldata.put(entry.getKey(), entry.getValue());
        }
        return alldata;
    }

    @Override
    public Map<String, Object> datasetsStatics(int groupType, String staticType, String isApplication, String filterParam) throws Exception {
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, ZyfxCatalog.class);
        HashMap<String, Object> dataList = new HashMap<String, Object>();
        String pid = "-1";
        if (groupType == 1) {
            pid = "1001";
        } else if (groupType == 2) {
            pid = "1002";
        } else if (groupType == 3) {
            pid = "1003";
        }
        queryWrapper.eq(ZyfxCatalog::getPid, (Object)pid);
        List zyfxCatalogs = this.zyfxCatalogMapper.selectList((Wrapper)queryWrapper);
        for (ZyfxCatalog zyfxCatalog : zyfxCatalogs) {
            MPJQueryMapperUtil qmu2 = new MPJQueryMapperUtil();
            MPJLambdaWrapper queryWrapper2 = qmu2.queryMapper(filterParam, ZyfxObject.class);
            queryWrapper2.leftJoin(ZyfxCatalogObject.class, ZyfxCatalogObject::getObjectid, ZyfxObject::getId);
            queryWrapper2.eq(ZyfxCatalogObject::getSchemeid, (Object)"1");
            queryWrapper2.selectCount(ZyfxObject::getId, "count");
            queryWrapper2.selectSum(ZyfxObject::getAcount, "\"accessCount\"");
            queryWrapper2.select(new String[]{"TO_CHAR(f_createtime, '" + staticType + "') as time"});
            queryWrapper2.groupBy((Object)("TO_CHAR(f_createtime, '" + staticType + "') "));
            queryWrapper2.select(new String[]{"'" + zyfxCatalog.getName() + "' as name "});
            queryWrapper2.likeRight(ZyfxCatalogObject::getCatalogcode, (Object)zyfxCatalog.getCode());
            queryWrapper2.leftJoin(" (SELECT COUNT(zoa.f_id) AS \"applyCount\", sum(zd.f_sjl) as \"applySize\",f_objectid FROM tb_zyfx_object_apply zoa left join tb_zyfx_dataset zd on (zd.f_id = zoa.f_objectid) GROUP BY zoa.f_objectid) applyData on (applyData.f_objectid = t.f_id) ");
            queryWrapper2.select(new String[]{" sum(applyData.\"applyCount\") as \"applyCount\" "});
            if (groupType == 1) {
                queryWrapper2.leftJoin(ZyfxDataset.class, ZyfxDataset::getId, ZyfxObject::getId);
                queryWrapper2.selectSum(ZyfxDataset::getSjl);
                queryWrapper2.select(new String[]{"sum(applyData.\"applySize\") as \"applySize\""});
            } else if (groupType == 2) {
                queryWrapper2.leftJoin("(select sum(f_accesscount) as \"accessCount\",f_resourceid from tb_proxy_access_statistics GROUP BY f_resourceid) accessStatistics on (accessStatistics.f_resourceid = t.f_id)");
                queryWrapper2.select(new String[]{"sum(accessStatistics.\"accessCount\") as \"callCount\""});
            } else if (groupType == 3 && isApplication != null) {
                queryWrapper2.leftJoin(ZyfxToolset.class, "zt", ZyfxToolset::getId, ZyfxCatalogObject::getObjectid);
                queryWrapper2.eq(ZyfxToolset::getIsapplication, (Object)Integer.valueOf(isApplication));
            }
            List maps = this.zyfxObjectService.listMaps((Wrapper)queryWrapper2);
            dataList.put(zyfxCatalog.getName(), maps);
        }
        return dataList;
    }

    @Override
    public List<Map<String, Object>> applyDataStatic(String filterParam, int maxCount) throws Exception {
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, ZyfxObjectApply.class);
        queryWrapper.innerJoin(ZyfxDataset.class, ZyfxDataset::getId, ZyfxObjectApply::getObjectid);
        queryWrapper.selectSum(ZyfxDataset::getSjl);
        queryWrapper.selectCount(ZyfxObjectApply::getId, "count");
        queryWrapper.selectMax(ZyfxObjectApply::getObjectname);
        queryWrapper.selectMax(ZyfxObjectApply::getCreatetime);
        queryWrapper.orderByDesc((Object)"count(t.f_id) ");
        queryWrapper.last(" NULLS LAST LIMIT " + maxCount);
        queryWrapper.groupBy(ZyfxObjectApply::getObjectid);
        List maps = this.zyfxObjectApplyService.listMaps((Wrapper)queryWrapper);
        return maps;
    }

    @Override
    public List<Map<String, Object>> dataTypeStatic(String filterParam) throws Exception {
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, ZyfxObject.class);
        queryWrapper.eq(ZyfxObject::getGrouptype, (Object)1);
        queryWrapper.leftJoin(ZyfxCatalogObject.class, ZyfxCatalogObject::getObjectid, ZyfxObject::getId);
        queryWrapper.eq(ZyfxCatalogObject::getSchemeid, (Object)"1");
        queryWrapper.leftJoin(ZyfxDataset.class, ZyfxDataset::getId, ZyfxObject::getId);
        queryWrapper.groupBy(ZyfxObject::getGs);
        queryWrapper.selectSum(ZyfxDataset::getSjl);
        queryWrapper.selectCount(ZyfxObject::getId, "count");
        queryWrapper.selectAs(ZyfxObject::getGs, "gs");
        List maps = this.zyfxObjectService.listMaps((Wrapper)queryWrapper);
        return maps;
    }

    @Override
    public List<Map<String, Object>> applyTypeStatic(String filterParam, String staticType) throws Exception {
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, ZyfxObjectApply.class);
        queryWrapper.gt(ZyfxObjectApply::getCheckstatus, (Object)0);
        queryWrapper.groupBy(ZyfxObjectApply::getGrouptype);
        queryWrapper.groupBy((Object)("TO_CHAR(f_createtime, '" + staticType + "') "));
        queryWrapper.selectCount(ZyfxObjectApply::getId, "count");
        queryWrapper.select(new String[]{"TO_CHAR(f_createtime, '" + staticType + "') as time"});
        queryWrapper.selectAs(ZyfxObjectApply::getGrouptype, "grouptype");
        List maps = this.zyfxObjectApplyService.listMaps((Wrapper)queryWrapper);
        return maps;
    }

    public Long getObjectCount(int groupType, int application) throws Exception {
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = qmu.queryMapper("", "", ZyfxObject.class);
        queryWrapper.eq(ZyfxObject::getGrouptype, (Object)groupType);
        queryWrapper.leftJoin(ZyfxCatalogObject.class, ZyfxCatalogObject::getObjectid, ZyfxObject::getId);
        queryWrapper.eq(ZyfxCatalogObject::getSchemeid, (Object)"1");
        if (groupType == 3) {
            queryWrapper.leftJoin(ZyfxToolset.class, "zt", ZyfxToolset::getId, ZyfxObject::getId);
            queryWrapper.eq(ZyfxToolset::getIsapplication, (Object)application);
        }
        return this.zyfxObjectMapper.selectCount((Wrapper)queryWrapper);
    }

    public List<Map<String, Object>> getObjectStaticsSize() throws Exception {
        MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = qmu.queryMapper("", "", ZyfxObject.class);
        queryWrapper.leftJoin(ZyfxCatalogObject.class, ZyfxCatalogObject::getObjectid, ZyfxObject::getId);
        queryWrapper.inSql(ZyfxCatalogObject::getSchemeid, "select f_id from tb_zyfx_catalog_scheme where f_pid ='1'");
        queryWrapper.leftJoin(ZyfxDataset.class, "zd", ZyfxDataset::getId, ZyfxObject::getId);
        queryWrapper.selectSum(ZyfxDataset::getSjl);
        queryWrapper.leftJoin(" (SELECT COUNT(zoa.f_id) AS \"applyCount\", sum(zd.f_sjl) as \"applySize\",f_objectid FROM tb_zyfx_object_apply zoa left join tb_zyfx_dataset zd on (zd.f_id = zoa.f_objectid) GROUP BY zoa.f_objectid) applyData on (applyData.f_objectid = t.f_id) ");
        queryWrapper.select(new String[]{" sum(applyData.\"applyCount\") as \"applyCount\" "});
        queryWrapper.select(new String[]{"sum(applyData.\"applySize\") as \"applySize\""});
        queryWrapper.selectCount(ZyfxObject::getId, "count");
        queryWrapper.leftJoin("(select sum(f_accesscount) as \"accessCount\",f_resourceid from tb_proxy_access_statistics GROUP BY f_resourceid) accessStatistics on (accessStatistics.f_resourceid = t.f_id)");
        queryWrapper.select(new String[]{"sum(accessStatistics.\"accessCount\") as \"callCount\""});
        queryWrapper.leftJoin(ZyfxToolset.class, "zt", ZyfxToolset::getId, ZyfxObject::getId);
        queryWrapper.groupBy(ZyfxObject::getGrouptype);
        queryWrapper.groupBy(ZyfxToolset::getIsapplication);
        queryWrapper.selectAs(ZyfxObject::getGrouptype, "\"groupType\"");
        queryWrapper.selectAs(ZyfxToolset::getIsapplication, "\"isApplication\"");
        List zyfxObjects = this.zyfxObjectService.listMaps((Wrapper)queryWrapper);
        return zyfxObjects;
    }
}

