/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.ns.zyfx.domain.ZyfxDataExportTask;
import com.geoway.ns.zyfx.domain.ZyfxDataset;
import com.geoway.ns.zyfx.domain.ZyfxObjectApply;
import com.geoway.ns.zyfx.dto.ZyfxObjectDetail;
import com.geoway.ns.zyfx.mapper.ZyfxDataExportTaskMapper;
import com.geoway.ns.zyfx.service.ExportTaskParamsService;
import com.geoway.ns.zyfx.service.ZyfxDataExportTaskService;
import com.geoway.ns.zyfx.service.ZyfxObjectService;
import com.geoway.webstore.export.constant.ExportDataTypeEnum;
import com.geoway.webstore.export.constant.ExportTaskStatusEnum;
import com.geoway.webstore.export.dto.ExportCustomTaskUnitDTO;
import com.geoway.webstore.export.dto.ExportParamsDTO;
import com.geoway.webstore.export.dto.ExportTaskDTO;
import com.geoway.webstore.export.entity.ExportTask;
import com.geoway.webstore.export.service.ExportTaskService;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ZyfxDataExportTaskServiceImpl
extends ServiceImpl<ZyfxDataExportTaskMapper, ZyfxDataExportTask>
implements ZyfxDataExportTaskService {
    @Value(value="${project.workDir:cache}")
    protected String outputPath;
    @Autowired
    private ExportTaskService exportTaskService;
    @Autowired
    private ZyfxObjectService zyfxObjectService;
    @Resource
    private DataSourceService dataSourceService;

    @Override
    public void addTask(ZyfxObjectApply applyDetail) {
        if (applyDetail == null) {
            throw new RuntimeException("\u521b\u5efa\u6570\u636e\u63d0\u53d6\u4efb\u52a1\u5931\u8d25\uff01");
        }
        String taskName = String.format("%s_%s", applyDetail.getObjectname(), DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm-ss-SSS"));
        File targetDir = Paths.get(this.outputPath, "output", taskName).toFile().getAbsoluteFile();
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        ExportParamsDTO exportParamsDTO = new ExportParamsDTO();
        exportParamsDTO.setTaskName(taskName);
        exportParamsDTO.setTaskDesc(taskName);
        exportParamsDTO.setDataType(ExportDataTypeEnum.Custom);
        ArrayList<ExportCustomTaskUnitDTO> customTaskUnitDTOS = new ArrayList<ExportCustomTaskUnitDTO>();
        ZyfxObjectDetail zyfxObjectDetail = this.zyfxObjectService.findDetailById(applyDetail.getObjectid(), false, false);
        ZyfxDataset zyfxDataset = (ZyfxDataset)zyfxObjectDetail.getDetail();
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetailWithoutPwd(zyfxDataset.getDataid());
        ExportTaskParamsService taskParamsService = ExportTaskParamsService.getInstance(DatasetTypeEnum.getByValue((Integer)datasetDTO.getType()));
        JSONObject params = JSONObject.parseObject((String)applyDetail.getParams());
        if (params.containsKey((Object)"fields") && !StringUtils.isEmpty((CharSequence)params.getString("fields")) && "*".equals(params.getString("fields"))) {
            params.put("fields", (Object)StringUtils.join((Object[])((FeatureClassDTO)datasetDTO).getFields().stream().map(s -> s.getName()).toArray(), (String)","));
            applyDetail.setParams(params.toJSONString());
        }
        customTaskUnitDTOS.add(taskParamsService.toExportTaskLayerParams(targetDir.getPath(), applyDetail));
        ExportTask task = this.exportTaskService.addTaskCustom(exportParamsDTO, customTaskUnitDTOS);
        this.exportTaskService.execute(task.getId());
        ZyfxDataExportTask shareDataExportTask = new ZyfxDataExportTask();
        shareDataExportTask.setApplyId(applyDetail.getId());
        shareDataExportTask.setExportPath(targetDir.getPath());
        shareDataExportTask.setExportStatus(ExportTaskStatusEnum.INITIALIZED.value);
        shareDataExportTask.setTaskName(task.getName());
        shareDataExportTask.setId(task.getId().toString());
        this.saveOrUpdate(shareDataExportTask, (Wrapper)Wrappers.lambdaQuery(ZyfxDataExportTask.class).eq(ZyfxDataExportTask::getApplyId, (Object)applyDetail.getId()));
    }

    @Override
    public List<ZyfxDataExportTask> listByApplyIds(List<String> applyIds) {
        List dataExportTasks = this.list((Wrapper)Wrappers.lambdaQuery(ZyfxDataExportTask.class).in(ZyfxDataExportTask::getApplyId, applyIds));
        for (ZyfxDataExportTask dataExportTask : dataExportTasks) {
            try {
                ExportTaskDTO adfTaskDTO = this.exportTaskService.getDetail(Integer.valueOf(Integer.parseInt(dataExportTask.getId())));
                dataExportTask.setExportStatus(adfTaskDTO.getStatus());
                dataExportTask.setSucceed(adfTaskDTO.getProgSuccess().equals(adfTaskDTO.getProgTotal()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return dataExportTasks;
    }
}

