/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.ns.monitor.service.AuthorizeTokenService;
import com.geoway.ns.proxy.constant.enums.AccessType;
import com.geoway.ns.proxy.constant.enums.TokenModel;
import com.geoway.ns.proxy.dto.ProxyObjectLimit;
import com.geoway.ns.proxy.entity.ProxyObject;
import com.geoway.ns.proxy.mapper.ProxyObjectMapper;
import com.geoway.ns.proxy.service.ProxyObjectService;
import com.geoway.ns.proxy.service.ProxyTokenService;
import com.geoway.ns.sys.domain.SysPowerGj;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.SysPowerGjService;
import com.geoway.ns.zyfx.constant.EnumCheckStatus;
import com.geoway.ns.zyfx.constant.datacenter.EnumDataDownloadStatus;
import com.geoway.ns.zyfx.constant.datacenter.EnumDataExportStatus;
import com.geoway.ns.zyfx.domain.ZyfxApplyOrder;
import com.geoway.ns.zyfx.domain.ZyfxApplyToken;
import com.geoway.ns.zyfx.domain.ZyfxDataApply;
import com.geoway.ns.zyfx.domain.ZyfxDataExportTask;
import com.geoway.ns.zyfx.domain.ZyfxDataset;
import com.geoway.ns.zyfx.domain.ZyfxObject;
import com.geoway.ns.zyfx.domain.ZyfxObjectApply;
import com.geoway.ns.zyfx.domain.ZyfxObjectApproval;
import com.geoway.ns.zyfx.domain.ZyfxServiceset;
import com.geoway.ns.zyfx.dto.ZyfxApplyFilterDTO;
import com.geoway.ns.zyfx.dto.ZyfxObjectDetail;
import com.geoway.ns.zyfx.mapper.ZyfxObjectApplyMapper;
import com.geoway.ns.zyfx.mapper.ZyfxObjectApprovalMapper;
import com.geoway.ns.zyfx.mapper.ZyfxObjectMapper;
import com.geoway.ns.zyfx.service.ZyfxApplyOrderService;
import com.geoway.ns.zyfx.service.ZyfxApplyTokenService;
import com.geoway.ns.zyfx.service.ZyfxDataApplyService;
import com.geoway.ns.zyfx.service.ZyfxDataExportTaskService;
import com.geoway.ns.zyfx.service.ZyfxObjectApplyService;
import com.geoway.ns.zyfx.service.ZyfxObjectApprovalService;
import com.geoway.ns.zyfx.service.ZyfxObjectService;
import com.geoway.webstore.export.constant.ExportTaskStatusEnum;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZyfxObjectApplyServiceImpl
extends ServiceImpl<ZyfxObjectApplyMapper, ZyfxObjectApply>
implements ZyfxObjectApplyService {
    @Resource
    ZyfxApplyTokenService zyfxApplyTokenService;
    @Resource
    ZyfxDataApplyService zyfxDataApplyService;
    @Resource
    ZyfxObjectService zyfxObjectService;
    @Resource
    ZyfxObjectMapper zyfxObjectMapper;
    @Resource
    ZyfxObjectApprovalMapper zyfxObjectApprovalMapper;
    @Autowired
    private AuthorizeTokenService authorizeTokenService;
    @Resource
    private ZyfxObjectApprovalService zyfxObjectApprovalService;
    @Resource
    private ZyfxDataExportTaskService zyfxDataExportTaskService;
    @Resource
    ZyfxApplyOrderService zyfxApplyOrderService;
    @Resource
    ProxyObjectMapper proxyObjectMapper;
    @Resource
    ProxyObjectService proxyObjectService;
    @Resource
    ProxyTokenService proxyTokenService;
    @Resource
    SysPowerGjService sysPowerGjService;

    @Override
    public IPage<ZyfxObjectApply> queryPageByFilter(ZyfxApplyFilterDTO dataApplyFilterDTO) throws Exception {
        LambdaQueryWrapper pageQueryWrapper = Wrappers.lambdaQuery(ZyfxObjectApply.class);
        pageQueryWrapper.orderByDesc(ZyfxObjectApply::getCreatetime);
        if (dataApplyFilterDTO.getStatus() != null && dataApplyFilterDTO.getStatus() != -1) {
            if (EnumCheckStatus.findEnumByValue(dataApplyFilterDTO.getStatus()) != null) {
                pageQueryWrapper.eq(ZyfxObjectApply::getCheckstatus, (Object)dataApplyFilterDTO.getStatus());
            } else if (dataApplyFilterDTO.getStatus() == -2) {
                pageQueryWrapper.ge(ZyfxObjectApply::getCheckstatus, (Object)2);
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)dataApplyFilterDTO.getName())) {
            pageQueryWrapper.like(ZyfxObjectApply::getObjectname, (Object)dataApplyFilterDTO.getName());
        }
        if (StrUtil.isNotEmpty((CharSequence)dataApplyFilterDTO.getUserId())) {
            pageQueryWrapper.eq(ZyfxObjectApply::getUserid, (Object)dataApplyFilterDTO.getUserId());
        }
        if (dataApplyFilterDTO.getBeginTime() != null) {
            pageQueryWrapper.ge(ZyfxObjectApply::getCreatetime, (Object)dataApplyFilterDTO.getBeginTime());
        }
        if (dataApplyFilterDTO.getEndTime() != null) {
            pageQueryWrapper.le(ZyfxObjectApply::getCreatetime, (Object)dataApplyFilterDTO.getEndTime());
        }
        if (dataApplyFilterDTO.getGrouptype() != null && dataApplyFilterDTO.getGrouptype() != 0) {
            pageQueryWrapper.eq(ZyfxObjectApply::getGrouptype, (Object)dataApplyFilterDTO.getGrouptype());
        }
        Page resultPage = new Page((long)dataApplyFilterDTO.getPage().intValue(), (long)dataApplyFilterDTO.getSize().intValue());
        IPage result = this.page((IPage)resultPage, (Wrapper)pageQueryWrapper);
        List listResults = result.getRecords();
        this.wrapperDatailInfoAndApproval(listResults);
        this.resetExportStatus(listResults);
        return result;
    }

    @Override
    public IPage<ZyfxApplyOrder> queryOrderPageByFilter(ZyfxApplyFilterDTO dataApplyFilterDTO) throws Exception {
        LambdaQueryWrapper pageQueryWrapper = Wrappers.lambdaQuery(ZyfxApplyOrder.class);
        pageQueryWrapper.orderByDesc(ZyfxApplyOrder::getCreatetime);
        if (dataApplyFilterDTO.getStatus() != null && dataApplyFilterDTO.getStatus() != -1) {
            if (EnumCheckStatus.findEnumByValue(dataApplyFilterDTO.getStatus()) != null) {
                pageQueryWrapper.eq(ZyfxApplyOrder::getStatus, (Object)dataApplyFilterDTO.getStatus());
            } else if (dataApplyFilterDTO.getStatus() == -2) {
                pageQueryWrapper.ge(ZyfxApplyOrder::getStatus, (Object)2);
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)dataApplyFilterDTO.getName())) {
            pageQueryWrapper.like(ZyfxApplyOrder::getName, (Object)dataApplyFilterDTO.getName());
        }
        if (StrUtil.isNotEmpty((CharSequence)dataApplyFilterDTO.getUserId())) {
            pageQueryWrapper.eq(ZyfxApplyOrder::getUserid, (Object)dataApplyFilterDTO.getUserId());
        }
        if (dataApplyFilterDTO.getBeginTime() != null) {
            pageQueryWrapper.ge(ZyfxApplyOrder::getCreatetime, (Object)dataApplyFilterDTO.getBeginTime());
        }
        if (dataApplyFilterDTO.getEndTime() != null) {
            pageQueryWrapper.le(ZyfxApplyOrder::getCreatetime, (Object)dataApplyFilterDTO.getEndTime());
        }
        if (dataApplyFilterDTO.getGrouptype() != null && dataApplyFilterDTO.getGrouptype() != 0) {
            pageQueryWrapper.eq(ZyfxApplyOrder::getGrouptype, (Object)dataApplyFilterDTO.getGrouptype());
        }
        Page resultPage = new Page((long)dataApplyFilterDTO.getPage().intValue(), (long)dataApplyFilterDTO.getSize().intValue());
        IPage result = this.zyfxApplyOrderService.page((IPage)resultPage, (Wrapper)pageQueryWrapper);
        if (dataApplyFilterDTO.getGrouptype().equals(1) && (dataApplyFilterDTO.getStatus().equals(-2) || dataApplyFilterDTO.getStatus().equals(2))) {
            result.getRecords().forEach(p -> {
                AtomicReference<Integer> dataExprotStatus = new AtomicReference<Integer>(3);
                List applies = this.list((Wrapper)Wrappers.lambdaQuery(ZyfxObjectApply.class).in(ZyfxObjectApply::getOrderid, new Object[]{p.getId()}));
                this.resetExportStatus(applies);
                applies.forEach(a -> {
                    if (((Integer)dataExprotStatus.get()).equals(2) || a.getDataExprotStatus().equals(2)) {
                        dataExprotStatus.set(2);
                    } else if (((Integer)dataExprotStatus.get()).equals(3) && a.getDataExprotStatus().equals(3)) {
                        dataExprotStatus.set(3);
                    } else if (a.getDataExprotStatus().equals(1)) {
                        dataExprotStatus.set(1);
                    } else {
                        dataExprotStatus.set(0);
                    }
                });
                p.setDataExprotStatus(dataExprotStatus.get());
            });
        }
        return result;
    }

    private void resetExportStatus(List<ZyfxObjectApply> shareDataApplyInfos) {
        if (shareDataApplyInfos == null || shareDataApplyInfos.size() == 0) {
            return;
        }
        List<String> applyIds = shareDataApplyInfos.stream().map(f -> f.getId()).collect(Collectors.toList());
        List<ZyfxDataExportTask> dataExportTasks = this.zyfxDataExportTaskService.listByApplyIds(applyIds);
        for (ZyfxObjectApply applyInfo : shareDataApplyInfos) {
            ZyfxDataExportTask exportTask = dataExportTasks.stream().filter(f -> f.getApplyId().equals(applyInfo.getId())).findAny().orElse(null);
            if (exportTask == null) {
                applyInfo.setDataExprotStatus(EnumDataExportStatus.NotExport.value);
                applyInfo.setDownloadstatus(EnumDataDownloadStatus.UnDownload.value);
                continue;
            }
            ExportTaskStatusEnum statusEnum = ExportTaskStatusEnum.getByValue((Integer)exportTask.getExportStatus());
            switch (statusEnum) {
                case INITIALIZED: 
                case PROCESSING: {
                    applyInfo.setDataExprotStatus(EnumDataExportStatus.Exproting.value);
                    applyInfo.setDownloadstatus(EnumDataDownloadStatus.ErrorDownload.value);
                    break;
                }
                case PAUSED: {
                    applyInfo.setDataExprotStatus(EnumDataExportStatus.Paused.value);
                    applyInfo.setDownloadstatus(EnumDataDownloadStatus.ErrorDownload.value);
                    break;
                }
                case FINISHED: {
                    this.handleFinishedStatus(applyInfo, exportTask);
                }
            }
        }
    }

    private void handleFinishedStatus(ZyfxObjectApply applyInfo, ZyfxDataExportTask exportTask) {
        Integer downloadStatus;
        Integer exportStatus;
        if (!exportTask.getSucceed().booleanValue()) {
            applyInfo.setDataExprotStatus(EnumDataExportStatus.Failed.value);
            applyInfo.setDownloadstatus(EnumDataDownloadStatus.ErrorDownload.value);
            this.log.debug("[\u5bfc\u51fa\u4efb\u52a1\u5931\u8d25] applyId:{" + applyInfo.getId() + "}\uff0ctaskId:{" + exportTask.getId() + "}");
            return;
        }
        boolean isEncryptionWatermarkOpen = false;
        String params = applyInfo.getParams();
        try {
            if (StrUtil.isNotBlank((CharSequence)params)) {
                JSONObject paramsJson = JSONObject.parseObject((String)params);
                boolean dataEncryption = paramsJson.getBooleanValue("dataEncryption");
                boolean dataWatermark = paramsJson.getBooleanValue("dataWatermark");
                boolean bl = isEncryptionWatermarkOpen = dataEncryption || dataWatermark;
                if (isEncryptionWatermarkOpen) {
                    if (paramsJson.containsKey((Object)"EncryptionWatermarkStatus")) {
                        boolean encryptionWatermarkStatus = paramsJson.getBooleanValue("EncryptionWatermarkStatus");
                        if (encryptionWatermarkStatus) {
                            exportStatus = EnumDataExportStatus.Succeed.value;
                            downloadStatus = EnumDataDownloadStatus.Download.value;
                            this.log.debug("[\u5bfc\u51fa\u5b8c\u6210] applyId:{" + applyInfo.getId() + "}\uff0c\u52a0\u5bc6\u6c34\u5370\u72b6\u6001\u5b8c\u6210");
                        } else {
                            exportStatus = EnumDataExportStatus.Failed.value;
                            downloadStatus = EnumDataDownloadStatus.ErrorDownload.value;
                            this.log.warn("[\u5bfc\u51fa\u5931\u8d25] applyId:{" + applyInfo.getId() + "}\uff0c\u52a0\u5bc6\u6c34\u5370\u72b6\u6001\u4e3afalse");
                        }
                    } else {
                        exportStatus = EnumDataExportStatus.Exproting.value;
                        downloadStatus = EnumDataDownloadStatus.ErrorDownload.value;
                        this.log.warn("[\u6b63\u5728\u5bfc\u51fa] applyId:{" + applyInfo.getId() + "}\uff0c\u5f00\u542f\u52a0\u5bc6/\u6c34\u5370\u4f46\u7f3a\u5931EncryptionWatermarkStatus\u5b57\u6bb5");
                    }
                } else {
                    exportStatus = EnumDataExportStatus.Succeed.value;
                    downloadStatus = EnumDataDownloadStatus.Download.value;
                }
            } else {
                exportStatus = EnumDataExportStatus.Succeed.value;
                downloadStatus = EnumDataDownloadStatus.Download.value;
            }
        }
        catch (JSONException e) {
            exportStatus = EnumDataExportStatus.Failed.value;
            downloadStatus = EnumDataDownloadStatus.ErrorDownload.value;
            this.log.error("[\u89e3\u6790\u5931\u8d25] applyId:{" + applyInfo.getId() + "}\uff0cparams\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        applyInfo.setDataExprotStatus(exportStatus);
        applyInfo.setDownloadstatus(downloadStatus);
    }

    @Override
    public ZyfxObjectApply findDetailById(String applyId) {
        final ZyfxObjectApply shareServiceApplyInfo = (ZyfxObjectApply)this.getById((Serializable)((Object)applyId));
        if (shareServiceApplyInfo.getGrouptype() == 1) {
            List zyfxDataApplies = this.zyfxDataApplyService.list((Wrapper)Wrappers.lambdaQuery(ZyfxDataApply.class).in(ZyfxDataApply::getApplyid, new Object[]{applyId}));
            if (zyfxDataApplies != null && zyfxDataApplies.size() > 0) {
                shareServiceApplyInfo.setDataDetail((ZyfxDataApply)zyfxDataApplies.get(0));
            }
            this.resetExportStatus((List<ZyfxObjectApply>)new ArrayList<ZyfxObjectApply>(){
                {
                    this.add(shareServiceApplyInfo);
                }
            });
        } else {
            List tokens = this.zyfxApplyTokenService.list((Wrapper)Wrappers.lambdaQuery(ZyfxApplyToken.class).in(ZyfxApplyToken::getApplyid, new Object[]{applyId}));
            if (tokens != null && tokens.size() > 0) {
                shareServiceApplyInfo.setServiceDetail((ZyfxApplyToken)tokens.get(0));
            }
        }
        List zyfxObjectApprovalList = this.zyfxObjectApprovalService.list((Wrapper)Wrappers.lambdaQuery(ZyfxObjectApproval.class).in(ZyfxObjectApproval::getObjectid, new Object[]{applyId}));
        zyfxObjectApprovalList.forEach(p -> {
            List proxyObjectlList = this.proxyObjectMapper.selectList((Wrapper)Wrappers.lambdaQuery(ProxyObject.class).in(ProxyObject::getApplyid, new Object[]{applyId}));
            if (proxyObjectlList.size() > 0) {
                p.setFrequency(((ProxyObject)proxyObjectlList.get(0)).getFrequency());
                p.setExpiretime(((ProxyObject)proxyObjectlList.get(0)).getExpiretime());
                p.setIpScope(((ProxyObject)proxyObjectlList.get(0)).getIpscope());
            }
        });
        shareServiceApplyInfo.setApprovals(zyfxObjectApprovalList);
        return shareServiceApplyInfo;
    }

    @Override
    public ZyfxApplyOrder findOrderDetailById(String orderid) {
        ZyfxApplyOrder zyfxApplyOrder = (ZyfxApplyOrder)this.zyfxApplyOrderService.getById((Serializable)((Object)orderid));
        List applies = this.list((Wrapper)Wrappers.lambdaQuery(ZyfxObjectApply.class).in(ZyfxObjectApply::getOrderid, new Object[]{orderid}));
        zyfxApplyOrder.setDetails(applies);
        return zyfxApplyOrder;
    }

    @Override
    public boolean deleteAllById(String applyId) {
        List approvals;
        ZyfxObjectApply shareServiceApplyInfo = (ZyfxObjectApply)this.getById((Serializable)((Object)applyId));
        if (shareServiceApplyInfo.getGrouptype() == 1) {
            List zyfxDataApplies = this.zyfxDataApplyService.list((Wrapper)Wrappers.lambdaQuery(ZyfxDataApply.class).in(ZyfxDataApply::getApplyid, new Object[]{applyId}));
            if (zyfxDataApplies != null && zyfxDataApplies.size() > 0) {
                this.zyfxDataApplyService.removeBatchByIds(zyfxDataApplies);
            }
        } else {
            List tokens = this.zyfxApplyTokenService.list((Wrapper)Wrappers.lambdaQuery(ZyfxApplyToken.class).in(ZyfxApplyToken::getApplyid, new Object[]{applyId}));
            if (tokens != null && tokens.size() > 0) {
                this.zyfxApplyTokenService.removeBatchByIds(tokens);
            }
        }
        List applies = this.list((Wrapper)Wrappers.lambdaQuery(ZyfxObjectApply.class).in(ZyfxObjectApply::getId, new Object[]{applyId}));
        if (applies != null && applies.size() > 0) {
            this.removeBatchByIds(applies);
        }
        if ((approvals = this.zyfxObjectApprovalService.list((Wrapper)Wrappers.lambdaQuery(ZyfxObjectApproval.class).in(ZyfxObjectApproval::getObjectid, new Object[]{applyId}))) != null && approvals.size() > 0) {
            this.zyfxObjectApprovalService.removeBatchByIds(approvals);
        }
        return true;
    }

    @Override
    public void saveOne(ZyfxObjectApply shareDataApplyInfo) {
        ZyfxApplyOrder order = (ZyfxApplyOrder)this.zyfxApplyOrderService.getById((Serializable)((Object)shareDataApplyInfo.getOrderid()));
        if (order == null) {
            order = new ZyfxApplyOrder();
            order.setUsername(shareDataApplyInfo.getUsername());
            order.setUserid(shareDataApplyInfo.getUserid());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            String code = dateFormat.format(new Date());
            order.setCode(code);
            order.setCreatetime(LocalDateTime.now());
            order.setGrouptype(shareDataApplyInfo.getGrouptype());
            order.setName(shareDataApplyInfo.getObjectname());
            order.setStatus(EnumCheckStatus.NotCheck.value);
            this.zyfxApplyOrderService.save(order);
            shareDataApplyInfo.setOrderid(order.getId());
        } else {
            order.setStatus(shareDataApplyInfo.getCheckstatus());
        }
        this.saveOrUpdate(shareDataApplyInfo);
        if (shareDataApplyInfo.getApprovals() != null) {
            shareDataApplyInfo.getApprovals().forEach(f -> {
                f.setObjectid(shareDataApplyInfo.getId());
                f.setCheckstatus(shareDataApplyInfo.getCheckstatus() + "");
            });
            this.zyfxObjectApprovalService.saveOrUpdateBatch(shareDataApplyInfo.getApprovals());
        }
    }

    @Override
    public ZyfxApplyOrder saveAll(List<ZyfxObjectApply> shareDataApplyInfo) {
        if (shareDataApplyInfo == null || shareDataApplyInfo.size() == 0) {
            return null;
        }
        ZyfxApplyOrder order = (ZyfxApplyOrder)this.zyfxApplyOrderService.getById((Serializable)((Object)shareDataApplyInfo.get(0).getOrderid()));
        if (order == null) {
            order = new ZyfxApplyOrder();
            order.setUsername(shareDataApplyInfo.get(0).getUsername());
            order.setUserid(shareDataApplyInfo.get(0).getUserid());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            String code = dateFormat.format(new Date());
            order.setCode(code);
            order.setCreatetime(LocalDateTime.now());
            order.setGrouptype(shareDataApplyInfo.get(0).getGrouptype());
            List objectNames = shareDataApplyInfo.stream().map(i -> i.getObjectname()).collect(Collectors.toList());
            String name = String.join((CharSequence)",", objectNames);
            if (name.length() > 20) {
                order.setName(name.substring(0, 19) + "...");
            } else {
                order.setName(name);
            }
            order.setStatus(EnumCheckStatus.NotCheck.value);
        } else {
            order.setStatus(shareDataApplyInfo.get(0).getCheckstatus());
        }
        this.zyfxApplyOrderService.save(order);
        String orderId = order.getId();
        shareDataApplyInfo.forEach(f -> f.setOrderid(orderId));
        this.saveOrUpdateBatch(shareDataApplyInfo);
        return order;
    }

    @Override
    public void check(ZyfxObjectApply shareDataApplyInfo, ProxyObjectLimit proxyObjectLimit) throws Exception {
        if (EnumCheckStatus.getEnumByValue(shareDataApplyInfo.getCheckstatus()).equals((Object)EnumCheckStatus.Reject)) {
            this.saveOne(shareDataApplyInfo);
            return;
        }
        final ZyfxObjectDetail detail = this.zyfxObjectService.findDetailById(shareDataApplyInfo.getObjectid(), false, false);
        if (shareDataApplyInfo.getGrouptype() == 1) {
            ZyfxDataset zyfxDataset = (ZyfxDataset)detail.getDetail();
            if (!StringUtils.isEmpty((String)zyfxDataset.getDataid())) {
                this.zyfxDataExportTaskService.addTask(shareDataApplyInfo);
            }
            this.saveOne(shareDataApplyInfo);
        } else if (shareDataApplyInfo.getGrouptype() == 2) {
            JSONObject objectInfo;
            String token = this.proxyTokenService.fetchToken(shareDataApplyInfo.getUserid(), shareDataApplyInfo.getUsername(), TokenModel.User);
            ProxyObject proxyObject = new ProxyObject();
            proxyObject.setToken(token);
            proxyObject.setApplyid(shareDataApplyInfo.getId());
            proxyObject.setServiceid(detail.getBase().getId());
            proxyObject.setServicename(detail.getBase().getName());
            proxyObject.setServicetype(detail.getBase().getGs());
            proxyObject.setExpiretime(shareDataApplyInfo.getExpiretime());
            proxyObject.setAuthtype(Integer.valueOf(AccessType.USER.value));
            proxyObject.setAuthway(Integer.valueOf(1));
            if (proxyObjectLimit != null) {
                proxyObject.setFrequency(proxyObjectLimit.getFrequency());
                proxyObject.setIpscope(proxyObjectLimit.getIpScope());
                proxyObject.setXzqlimit(proxyObjectLimit.getXzqlimit());
                proxyObject.setExpiretime(proxyObjectLimit.getExpiretime());
            }
            HashMap<String, Object> map = new HashMap<String, Object>(){
                {
                    this.put("sourceName", detail.getBase().getName());
                    this.put("sourceGroupType", detail.getBase().getGs());
                }
            };
            if (StrUtil.isNotEmpty((CharSequence)((ZyfxServiceset)detail.getDetail()).getInputparams()) && JsonParser.parseString((String)((ZyfxServiceset)detail.getDetail()).getInputparams()).isJsonObject() && (objectInfo = JSON.parseObject((String)((ZyfxServiceset)detail.getDetail()).getInputparams())).containsKey((Object)"styles")) {
                JSONArray jsonArray = objectInfo.getJSONArray("styles");
                String styleIds = "";
                if (jsonArray != null && jsonArray.size() > 0) {
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        styleIds = i == 0 ? jsonArray.getJSONObject(i).getString("styleId") : styleIds + "," + jsonArray.getJSONObject(i).getString("styleId");
                    }
                }
                map.put("sourceStyle", styleIds);
            }
            proxyObject.setParams(JSON.toJSONString((Object)map));
            this.proxyObjectService.saveOneProxyObject(1, proxyObject);
            ZyfxApplyToken zyfxApplyToken = new ZyfxApplyToken();
            zyfxApplyToken.setApplyid(shareDataApplyInfo.getId());
            zyfxApplyToken.setCreatetime(LocalDateTime.now());
            zyfxApplyToken.setToken(token);
            shareDataApplyInfo.setServiceDetail(zyfxApplyToken);
            this.saveOne(shareDataApplyInfo);
        } else if (shareDataApplyInfo.getGrouptype() == 3) {
            SysPowerGj sysPowerGj = new SysPowerGj();
            sysPowerGj.setMandateId(detail.getBase().getId());
            sysPowerGj.setMandateName(detail.getBase().getName());
            sysPowerGj.setMandateType(Integer.valueOf(1));
            sysPowerGj.setRelationType("user");
            sysPowerGj.setRelationId(shareDataApplyInfo.getUserid());
            this.sysPowerGjService.saveOrUpdate((Object)sysPowerGj);
            this.saveOne(shareDataApplyInfo);
        } else {
            this.saveOne(shareDataApplyInfo);
        }
    }

    @Override
    public void reExport(String applyId) {
        ZyfxObjectApply zyfxObjectApply = this.findDetailById(applyId);
        this.zyfxDataExportTaskService.addTask(zyfxObjectApply);
    }

    @Override
    public void download(final String applyId) {
        ZyfxObjectApply applyInfo = this.findDetailById(applyId);
        if (applyInfo == null) {
            throw new RuntimeException("\u7533\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        if (!applyInfo.getCheckstatus().equals(EnumCheckStatus.Pass.value)) {
            throw new RuntimeException("\u7533\u8bf7\u672a\u901a\u8fc7,\u7981\u6b62\u4e0b\u8f7d\uff01");
        }
        if (!applyInfo.getDataExprotStatus().equals(EnumDataExportStatus.Succeed.value)) {
            throw new RuntimeException("\u6570\u636e\u5c1a\u672a\u51c6\u5907\u597d\uff0c\u8bf7\u7a0d\u540e\uff01");
        }
        List<ZyfxDataExportTask> dataExportTasks = this.zyfxDataExportTaskService.listByApplyIds((List<String>)new ArrayList<String>(){
            {
                this.add(applyId);
            }
        });
        ZyfxDataExportTask dataExportTask = dataExportTasks.get(0);
        final File targetFile = new File(dataExportTasks.get(0).getExportPath());
        this.updateById(applyInfo);
        DownloadUtil.downloadZipFile((List)new ArrayList<File>(){
            {
                this.add(targetFile);
            }
        }, (String)targetFile.getParent(), (String)(dataExportTask.getTaskName() + ".zip"));
    }

    private void wrapperDatailInfoAndApproval(List<ZyfxObjectApply> listResults) throws Exception {
        if (listResults.size() > 0) {
            List zyfxObjects = new ArrayList();
            List zyfxObjectApprovals = new ArrayList();
            List objectIds = listResults.stream().map(i -> i.getObjectid()).collect(Collectors.toList());
            List ids = listResults.stream().map(i -> i.getId()).collect(Collectors.toList());
            LambdaQueryWrapper subQueryWrapper1 = Wrappers.lambdaQuery();
            subQueryWrapper1.in(ZyfxObject::getId, objectIds);
            zyfxObjects = this.zyfxObjectMapper.selectList((Wrapper)subQueryWrapper1);
            LambdaQueryWrapper subQueryWrapper2 = Wrappers.lambdaQuery();
            subQueryWrapper2.in(ZyfxObjectApproval::getObjectid, ids);
            zyfxObjectApprovals = this.zyfxObjectApprovalMapper.selectList((Wrapper)subQueryWrapper2);
            for (ZyfxObjectApply zyfxObjectApply : listResults) {
                List zyfxObjects1 = zyfxObjects.stream().filter(i -> i.getId().equals(zyfxObjectApply.getObjectid())).collect(Collectors.toList());
                if (zyfxObjects1 != null && zyfxObjects1.size() > 0) {
                    if (zyfxObjectApply.getGrouptype() == 1) {
                        zyfxObjectApply.setOriginalDataInfo((ZyfxObject)zyfxObjects1.get(0));
                    } else {
                        zyfxObjectApply.setOriginalDataInfo((ZyfxObject)zyfxObjects1.get(0));
                    }
                }
                List<ZyfxObjectApproval> zyfxObjectApprovals1 = zyfxObjectApprovals.stream().filter(i -> i.getObjectid().equals(zyfxObjectApply.getId())).collect(Collectors.toList());
                zyfxObjectApply.setApprovals(zyfxObjectApprovals1);
            }
        }
    }

    @Override
    public List<ZyfxObjectApply> orderCheck(SysUserDTO sysUser, ProxyObjectLimit proxyObjectLimit, Integer checkstatus, String comment, String orderid) throws Exception {
        List applies = this.list((Wrapper)Wrappers.lambdaQuery(ZyfxObjectApply.class).in(ZyfxObjectApply::getOrderid, new Object[]{orderid}));
        ZyfxApplyOrder zyfxApplyOrder = (ZyfxApplyOrder)this.zyfxApplyOrderService.getById((Serializable)((Object)orderid));
        zyfxApplyOrder.setStatus(checkstatus);
        for (ZyfxObjectApply zyfxObjectApply : applies) {
            zyfxObjectApply.setCheckstatus(checkstatus);
            if (zyfxObjectApply.getApprovals() == null || zyfxObjectApply.getApprovals().size() == 0) {
                final ZyfxObjectApproval zyfxObjectApproval = new ZyfxObjectApproval();
                zyfxObjectApproval.setObjectid(zyfxObjectApply.getId());
                zyfxObjectApproval.setCheckstatus(checkstatus + "");
                zyfxObjectApproval.setCheckuserid(sysUser.getId());
                zyfxObjectApproval.setCheckusername(sysUser.getUsername());
                zyfxObjectApproval.setComment(comment);
                zyfxObjectApproval.setObjectname(zyfxObjectApply.getObjectname());
                zyfxObjectApproval.setCreatetime(LocalDateTime.now());
                zyfxObjectApproval.setUpdatetime(LocalDateTime.now());
                zyfxObjectApply.setApprovals((List<ZyfxObjectApproval>)new ArrayList<ZyfxObjectApproval>(){
                    {
                        this.add(zyfxObjectApproval);
                    }
                });
            }
            this.check(zyfxObjectApply, proxyObjectLimit);
        }
        this.zyfxApplyOrderService.updateById(zyfxApplyOrder);
        return applies;
    }
}

