/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.base.exception.BizException;
import com.geoway.ns.zyfx.domain.ZyfxObject;
import com.geoway.ns.zyfx.domain.ZyfxToolCenterGroup;
import com.geoway.ns.zyfx.domain.ZyfxToolCenterGroupRel;
import com.geoway.ns.zyfx.domain.ZyfxToolset;
import com.geoway.ns.zyfx.dto.ToolCenterToolDTO;
import com.geoway.ns.zyfx.mapper.ZyfxToolCenterGroupMapper;
import com.geoway.ns.zyfx.service.ZyfxObjectService;
import com.geoway.ns.zyfx.service.ZyfxToolCenterGroupRelService;
import com.geoway.ns.zyfx.service.ZyfxToolCenterGroupService;
import com.geoway.ns.zyfx.service.ZyfxToolsetService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class ZyfxToolCenterGroupServiceImpl
extends ServiceImpl<ZyfxToolCenterGroupMapper, ZyfxToolCenterGroup>
implements ZyfxToolCenterGroupService {
    @Autowired
    private ZyfxToolCenterGroupRelService groupRelService;
    @Autowired
    private ZyfxToolsetService toolsetService;
    @Autowired
    private ZyfxObjectService objectService;

    @Override
    public List<ZyfxToolCenterGroup> listBySchemeId(String schemeId) {
        return ((ZyfxToolCenterGroupMapper)this.baseMapper).selectBySchemeId(schemeId);
    }

    @Override
    public List<ZyfxToolCenterGroup> listBySchemeIdWithToolsets(String schemeId) {
        List<ZyfxToolCenterGroup> groups = this.listBySchemeId(schemeId);
        if (groups == null || groups.isEmpty()) {
            return new ArrayList<ZyfxToolCenterGroup>();
        }
        List<String> groupIds = groups.stream().filter(g -> g != null && g.getId() != null).map(ZyfxToolCenterGroup::getId).collect(Collectors.toList());
        if (groupIds.isEmpty()) {
            return groups;
        }
        List<ZyfxToolCenterGroupRel> rels = this.groupRelService.listByGroupIds(groupIds);
        Map groupToolsetMap = rels.stream().collect(Collectors.groupingBy(ZyfxToolCenterGroupRel::getGroupId, Collectors.mapping(ZyfxToolCenterGroupRel::getToolsetId, Collectors.toList())));
        List allToolsetIds = rels.stream().map(ZyfxToolCenterGroupRel::getToolsetId).distinct().collect(Collectors.toList());
        HashMap toolsetMap = allToolsetIds.isEmpty() ? new HashMap() : this.toolsetService.listByIds(allToolsetIds).stream().filter(t -> t != null && t.getId() != null).collect(Collectors.toMap(ZyfxToolset::getId, t -> t));
        HashMap objectMap = allToolsetIds.isEmpty() ? new HashMap() : this.objectService.listByIds(allToolsetIds).stream().filter(o -> o != null && o.getId() != null).collect(Collectors.toMap(ZyfxObject::getId, o -> o));
        for (ZyfxToolCenterGroup group : groups) {
            if (group == null || group.getId() == null) continue;
            List toolsetIds = groupToolsetMap.getOrDefault(group.getId(), new ArrayList());
            List<Object> tools = toolsetIds.stream().filter(tid -> tid != null).map(tid -> {
                ZyfxObject object = (ZyfxObject)objectMap.get(tid);
                ZyfxToolset toolset = (ZyfxToolset)toolsetMap.get(tid);
                return ToolCenterToolDTO.from(object, toolset);
            }).filter(dto -> dto != null).collect(Collectors.toList());
            group.setToolsets(tools);
        }
        return groups;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOne(ZyfxToolCenterGroup group) throws BizException {
        if (!StringUtils.hasText((String)group.getName())) {
            throw new BizException("\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)group.getSchemeId())) {
            throw new BizException("\u6240\u5c5e\u65b9\u6848ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.hasText((String)group.getId())) {
            group.setUpdatetime(new Date());
            this.updateById(group);
        } else {
            group.setCreatetime(new Date());
            this.save(group);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteOne(String id) throws BizException {
        if (!StringUtils.hasText((String)id)) {
            throw new BizException("\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ZyfxToolCenterGroupRel::getGroupId, (Object)id);
        this.groupRelService.remove((Wrapper)wrapper);
        this.removeById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addToolsets(String groupId, List<String> toolsetIds) throws BizException {
        if (!StringUtils.hasText((String)groupId)) {
            throw new BizException("\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (toolsetIds == null || toolsetIds.isEmpty()) {
            return;
        }
        List<String> existingIds = this.groupRelService.getToolsetIdsByGroupId(groupId);
        ArrayList<ZyfxToolCenterGroupRel> rels = new ArrayList<ZyfxToolCenterGroupRel>();
        int sort = 0;
        for (String toolsetId : toolsetIds) {
            if (existingIds.contains(toolsetId)) continue;
            ZyfxToolCenterGroupRel rel = new ZyfxToolCenterGroupRel();
            rel.setGroupId(groupId);
            rel.setToolsetId(toolsetId);
            rel.setSort(sort++);
            rel.setCreatetime(new Date());
            rels.add(rel);
        }
        if (!rels.isEmpty()) {
            this.groupRelService.saveBatch(rels);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeToolsets(String groupId, List<String> toolsetIds) throws BizException {
        if (!StringUtils.hasText((String)groupId)) {
            throw new BizException("\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (toolsetIds == null || toolsetIds.isEmpty()) {
            return;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(ZyfxToolCenterGroupRel::getGroupId, (Object)groupId)).in(ZyfxToolCenterGroupRel::getToolsetId, toolsetIds);
        this.groupRelService.remove((Wrapper)wrapper);
    }

    @Override
    public List<ZyfxToolCenterGroup> listBySchemeIdOrDefault(String schemeId, Boolean withToolsets) {
        String targetSchemeId = schemeId;
        if (!StringUtils.hasText((String)targetSchemeId)) {
            return new ArrayList<ZyfxToolCenterGroup>();
        }
        return withToolsets != null && withToolsets != false ? this.listBySchemeIdWithToolsets(targetSchemeId) : this.listBySchemeId(targetSchemeId);
    }
}

