/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.utils;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.ns.proxy.service.RedisTemplateService;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.zyfx.domain.ZyfxDataExportTask;
import com.geoway.ns.zyfx.domain.ZyfxObjectApply;
import com.geoway.ns.zyfx.service.DataEncryptService;
import com.geoway.ns.zyfx.service.ZyfxDataExportTaskService;
import com.geoway.ns.zyfx.service.ZyfxObjectApplyService;
import com.geoway.ns.zyfx.utils.WatermarkTaskClient;
import com.geoway.webstore.export.constant.ExportTaskStatusEnum;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class GeomarkScheduler {
    @Value(value="${geomark.query.enable:false}")
    private Boolean enable;
    private static final String REDIS_KEY_PREFIX = "geomark:%s";
    private static final String REDIS_VALUE_PROCESSING = "1";
    private static final Integer CHECK_STATUS_APPROVED = 2;
    private static final Integer REDIS_KEY_EXPIRE_HOURS = 24;
    private static final String REDIS_WATERMARK_TASK_PREFIX = "watermark:task:%s";
    private static final String TASK_STATUS_FINISHED = "SUCCESS";
    private static final String TASK_STATUS_FAILED = "FAIL";
    private final Logger log = LoggerFactory.getLogger(GeomarkScheduler.class);
    @Resource
    private ZyfxDataExportTaskService zyfxDataExportTaskService;
    @Resource
    private ZyfxObjectApplyService applyService;
    @Autowired
    DataEncryptService dataEncryptService;
    @Autowired
    private RedisTemplateService redisTemplateService;

    @Scheduled(cron="${geomark.query.cron:0/3 * * * * ?}")
    public void pollingTask() {
        if (!this.enable.booleanValue()) {
            return;
        }
        try {
            LocalDateTime twentyFourHoursAgo = LocalDateTime.now().minusHours(24L);
            Date startTime = Date.from(twentyFourHoursAgo.atZone(ZoneId.systemDefault()).toInstant());
            List applies = this.applyService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ZyfxObjectApply.class).ge(ZyfxObjectApply::getCreatetime, (Object)startTime)).eq(ZyfxObjectApply::getCheckstatus, (Object)CHECK_STATUS_APPROVED));
            if (CollectionUtils.isEmpty((Collection)applies)) {
                this.log.info("\u672a\u67e5\u8be2\u523024\u5c0f\u65f6\u5185\u5ba1\u6838\u901a\u8fc7\u7684\u7533\u8bf7\u6570\u636e\uff0c\u8df3\u8fc7\u672c\u6b21\u5904\u7406");
                return;
            }
            this.log.info("\u672c\u6b21\u8f6e\u8be2\u67e5\u8be2\u5230{}\u676124\u5c0f\u65f6\u5185\u5ba1\u6838\u901a\u8fc7\u7684\u7533\u8bf7\u6570\u636e", (Object)applies.size());
            List<String> needProcessApplyIds = applies.stream().map(ZyfxObjectApply::getId).filter(applyId -> {
                String redisKey = String.format(REDIS_KEY_PREFIX, applyId);
                boolean exists = this.redisTemplateService.isHasKey(redisKey);
                if (exists) {
                    this.log.info("\u7533\u8bf7ID:{}\u5df2\u5728Redis\u4e2d\u6807\u8bb0\uff0c\u8df3\u8fc7\u5904\u7406", applyId);
                }
                return !exists;
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(needProcessApplyIds)) {
                this.log.info("\u6240\u6709\u7b26\u5408\u6761\u4ef6\u7684\u7533\u8bf7\u5747\u5df2\u5904\u7406\uff0c\u8df3\u8fc7\u672c\u6b21\u6267\u884c");
                return;
            }
            this.log.info("\u672c\u6b21\u9700\u8981\u5904\u7406\u52a0\u5bc6\u6c34\u5370\u7684\u7533\u8bf7\u6570\u91cf\uff1a{}", (Object)needProcessApplyIds.size());
            List<ZyfxDataExportTask> dataExportTasks = this.zyfxDataExportTaskService.listByApplyIds(needProcessApplyIds);
            HashSet<String> processedApplyIds = new HashSet<String>();
            for (ZyfxObjectApply applyInfo : applies) {
                String applyId2 = applyInfo.getId();
                if (!needProcessApplyIds.contains(applyId2) || processedApplyIds.contains(applyId2)) continue;
                String redisKey = String.format(REDIS_KEY_PREFIX, applyId2);
                ZyfxDataExportTask exportTask = dataExportTasks.stream().filter(task -> applyId2.equals(task.getApplyId())).findAny().orElse(null);
                if (exportTask == null) {
                    this.log.warn("\u7533\u8bf7ID:{}\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5bfc\u51fa\u4efb\u52a1\uff0c\u8df3\u8fc7\u5904\u7406", (Object)applyId2);
                    this.redisTemplateService.setInfoByBoundValueOps(redisKey, null, REDIS_KEY_EXPIRE_HOURS, TimeUnit.HOURS);
                    processedApplyIds.add(applyId2);
                    continue;
                }
                ExportTaskStatusEnum statusEnum = ExportTaskStatusEnum.getByValue((Integer)exportTask.getExportStatus());
                if (statusEnum != ExportTaskStatusEnum.FINISHED) {
                    this.log.info("\u7533\u8bf7ID:{}\u7684\u5bfc\u51fa\u4efb\u52a1\u72b6\u6001\u4e3a{}\uff0c\u672a\u5b8c\u6210\u63d0\u53d6\uff0c\u8df3\u8fc7\u5904\u7406", (Object)applyId2, (Object)statusEnum);
                    processedApplyIds.add(applyId2);
                    continue;
                }
                this.redisTemplateService.setInfoByBoundValueOps(redisKey, null, REDIS_KEY_EXPIRE_HOURS, TimeUnit.HOURS);
                processedApplyIds.add(applyId2);
                this.handleEncryptionAndWatermark(applyInfo, exportTask, applyId2);
            }
        }
        catch (Exception e) {
            this.log.error("\u52a0\u5bc6\u6c34\u5370\u8f6e\u8be2\u4efb\u52a1\u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
    }

    @Scheduled(cron="0/10 * * * * ?")
    public void watermarkResultPollingTask() {
        if (!this.enable.booleanValue()) {
            return;
        }
        try {
            Set taskKeys = this.redisTemplateService.keys(String.format(REDIS_WATERMARK_TASK_PREFIX, "*"));
            if (CollectionUtils.isEmpty((Collection)taskKeys)) {
                this.log.info("\u6ca1\u6709\u5f85\u67e5\u8be2\u7684\u6c34\u5370\u4efb\u52a1\uff0c\u8df3\u8fc7\u672c\u6b21\u6267\u884c");
                return;
            }
            for (String taskKey : taskKeys) {
                String purePrefix = String.format(REDIS_WATERMARK_TASK_PREFIX, "");
                String applyId = taskKey.substring(purePrefix.length());
                String taskId = this.redisTemplateService.getInfoByBoundValueOps(taskKey).replace("\"", "");
                if (StrUtil.isBlank((CharSequence)taskId)) {
                    this.log.warn("\u7533\u8bf7ID:{}\u7684\u6c34\u5370\u4efb\u52a1ID\u4e3a\u7a7a\uff0c\u5220\u9664\u65e0\u6548\u7f13\u5b58", (Object)applyId);
                    this.redisTemplateService.deleteKey(taskKey);
                    continue;
                }
                try {
                    JSONObject taskDetail = WatermarkTaskClient.getInstance().getTaskDetail(taskId);
                    String status = taskDetail.getString("status").toUpperCase();
                    if (TASK_STATUS_FINISHED.equals(status)) {
                        JSONObject result = WatermarkTaskClient.getInstance().getTaskResult(taskId, 1, 10);
                        this.log.info("\u7533\u8bf7ID:{}\u7684\u6c34\u5370\u4efb\u52a1\u6267\u884c\u6210\u529f\uff0c\u7ed3\u679c:{}", (Object)applyId, (Object)JSON.toJSONString((Object)result));
                        this.updateWatermarkStatus(applyId, true);
                        continue;
                    }
                    if (TASK_STATUS_FAILED.equals(status)) {
                        this.log.error("\u7533\u8bf7ID:{}\u7684\u6c34\u5370\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Object)applyId);
                        this.updateWatermarkStatus(applyId, false);
                        continue;
                    }
                    this.log.info("\u7533\u8bf7ID:{}\u7684\u6c34\u5370\u4efb\u52a1\u4ecd\u5728\u5904\u7406\u4e2d\uff0c\u72b6\u6001:{}", (Object)applyId, (Object)status);
                }
                catch (Exception e) {
                    this.log.error("\u67e5\u8be2\u7533\u8bf7ID:{}\u7684\u6c34\u5370\u4efb\u52a1\u7ed3\u679c\u5f02\u5e38", (Object)applyId, (Object)e);
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u6c34\u5370\u7ed3\u679c\u67e5\u8be2\u4efb\u52a1\u6267\u884c\u5f02\u5e38", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateWatermarkStatus(String applyId, boolean success) {
        try {
            ZyfxObjectApply applyInfo = (ZyfxObjectApply)this.applyService.getById((Serializable)((Object)applyId));
            if (applyInfo == null) {
                this.log.error("\u7533\u8bf7ID:{}\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u66f4\u65b0\u6c34\u5370\u72b6\u6001", (Object)applyId);
                return;
            }
            String params = applyInfo.getParams();
            if (StrUtil.isBlank((CharSequence)params)) {
                this.log.error("\u7533\u8bf7ID:{}\u7684params\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0\u6c34\u5370\u72b6\u6001", (Object)applyId);
                return;
            }
            JSONObject paramsNode = JSONObject.parseObject((String)params);
            boolean hasDataEncryption = paramsNode.getBooleanValue("dataEncryption");
            if (hasDataEncryption) {
                if (!paramsNode.containsKey((Object)"EncryptionStatus")) {
                    this.log.info("\u7533\u8bf7ID:{}\u7684\u52a0\u5bc6\u4efb\u52a1\u5c1a\u672a\u5b8c\u6210\uff0c\u6682\u4e0d\u66f4\u65b0\u6700\u7ec8\u72b6\u6001", (Object)applyId);
                    return;
                }
                boolean encryptionSuccess = paramsNode.getBooleanValue("EncryptionStatus");
                paramsNode.put("EncryptionWatermarkStatus", (Object)(encryptionSuccess && success ? 1 : 0));
            } else {
                paramsNode.put("EncryptionWatermarkStatus", (Object)success);
            }
            applyInfo.setParams(paramsNode.toJSONString());
            this.applyService.updateById(applyInfo);
            this.log.info("\u7533\u8bf7ID:{}\u7684\u6c34\u5370\u72b6\u6001\u5df2\u66f4\u65b0\u4e3a:{}", (Object)applyId, (Object)success);
            String taskKey = String.format(REDIS_WATERMARK_TASK_PREFIX, applyId);
            this.redisTemplateService.deleteKey(taskKey);
            return;
        }
        catch (Exception e) {
            this.log.error("\u66f4\u65b0\u7533\u8bf7ID:{}\u7684\u6c34\u5370\u72b6\u6001\u5f02\u5e38", (Object)applyId, (Object)e);
        }
    }

    private void handleEncryptionAndWatermark(ZyfxObjectApply applyInfo, ZyfxDataExportTask exportTask, String applyId) {
        String rootExportPath = exportTask.getExportPath();
        if (StrUtil.isBlank((CharSequence)rootExportPath)) {
            this.log.error("\u7533\u8bf7ID:{}\u7684\u5bfc\u51fa\u4efb\u52a1\u8def\u5f84\u4e3a\u7a7a\uff0c\u52a0\u5bc6\u6c34\u5370\u64cd\u4f5c\u5931\u8d25", (Object)applyId);
            this.updateEncryptionWatermarkStatus(applyInfo, false);
            return;
        }
        File rootDir = new File(rootExportPath);
        if (!rootDir.exists() || !rootDir.isDirectory()) {
            this.log.error("\u7533\u8bf7ID:{}\u7684\u5bfc\u51fa\u8def\u5f84\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u6587\u4ef6\u5939:{}", (Object)applyId, (Object)rootExportPath);
            this.updateEncryptionWatermarkStatus(applyInfo, false);
            return;
        }
        String params = applyInfo.getParams();
        if (StrUtil.isBlank((CharSequence)params)) {
            this.log.info("\u7533\u8bf7ID:{}\u7684params\u4e3a\u7a7a\uff0c\u65e0\u9700\u5904\u7406\u52a0\u5bc6\u6c34\u5370", (Object)applyId);
            return;
        }
        try {
            JSONObject paramsNode = JSONObject.parseObject((String)params);
            if (paramsNode.containsKey((Object)"EncryptionWatermarkStatus")) {
                this.log.info("\u7533\u8bf7ID:{}\u5df2\u5b58\u5728EncryptionWatermarkStatus\u5b57\u6bb5\uff0c\u8df3\u8fc7\u52a0\u5bc6\u6c34\u5370\u5904\u7406", (Object)applyId);
                return;
            }
            boolean hasDataEncryption = paramsNode.getBooleanValue("dataEncryption");
            boolean hasDataWatermark = paramsNode.getBooleanValue("dataWatermark");
            if (!hasDataEncryption && !hasDataWatermark) {
                this.log.info("\u7533\u8bf7ID:{}\u672a\u5f00\u542f\u52a0\u5bc6\u548c\u6c34\u5370\uff0c\u65e0\u9700\u5904\u7406", (Object)applyId);
                this.updateEncryptionWatermarkStatus(applyInfo, true);
                return;
            }
            String exportFormat = paramsNode.getString("exportFormat");
            if (StrUtil.isBlank((CharSequence)exportFormat) || exportFormat.toLowerCase().equals("shp")) {
                this.log.info("\u7533\u8bf7ID:{}\u52a0\u5bc6\u52a0\u6c34\u5370\u4e0d\u652f\u6301shp\u683c\u5f0f\uff0c\u65e0\u9700\u5904\u7406", (Object)applyId);
                this.updateEncryptionWatermarkStatus(applyInfo, true);
                return;
            }
            ArrayList<File> allFolders = new ArrayList<File>();
            this.collectAllFolders(rootDir, allFolders);
            this.log.info("\u7533\u8bf7ID:{}\u5171\u53d1\u73b0{}\u4e2a\u6587\u4ef6\u5939\u9700\u8981\u5904\u7406", (Object)applyId, (Object)allFolders.size());
            if (allFolders.isEmpty()) {
                this.log.error("\u7533\u8bf7ID:{}\u7684\u5bfc\u51fa\u8def\u5f84\u4e0b\u672a\u627e\u5230\u4efb\u4f55\u6587\u4ef6\u5939:{}", (Object)applyId, (Object)rootExportPath);
                this.updateEncryptionWatermarkStatus(applyInfo, false);
                return;
            }
            if (hasDataEncryption) {
                String encryptUser = paramsNode.getString("Encryptuser");
                LocalDate localDate = LocalDate.parse(paramsNode.getString("Encryptendtime"));
                Date encryptEndtime = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                String encryptStrKey = paramsNode.getString("EncryptstrKey");
                boolean allEncryptionSuccess = true;
                for (File folder : allFolders) {
                    String folderPath = folder.getAbsolutePath();
                    boolean encryptionSuccess = this.executeEncryption(folderPath, applyId, encryptUser, encryptEndtime, encryptStrKey);
                    if (encryptionSuccess) continue;
                    allEncryptionSuccess = false;
                    this.log.error("\u7533\u8bf7ID:{}\u7684\u6587\u4ef6\u5939{}\u52a0\u5bc6\u5931\u8d25", (Object)applyId, (Object)folderPath);
                }
                paramsNode.put("EncryptionStatus", (Object)allEncryptionSuccess);
                applyInfo.setParams(paramsNode.toJSONString());
                this.applyService.updateById(applyInfo);
                if (!hasDataWatermark) {
                    this.updateEncryptionWatermarkStatus(applyInfo, allEncryptionSuccess);
                }
            }
            if (hasDataWatermark) {
                String watermarkUserInfor = paramsNode.getString("WatermarkUserInfor");
                String watermarkDistributor = paramsNode.getString("WatermarkDistributor");
                String watermarkDistributionOperator = paramsNode.getString("WatermarkDistributionOperator");
                String watermarkRemark = paramsNode.getString("WatermarkRemark");
                for (File folder : allFolders) {
                    String folderPath = folder.getAbsolutePath();
                    this.executeWatermark(folderPath, applyId, watermarkUserInfor, watermarkDistributor, watermarkDistributionOperator, watermarkRemark);
                }
            }
        }
        catch (JSONException e) {
            this.log.error("\u7533\u8bf7ID:{}\u7684params\u89e3\u6790JSON\u5f02\u5e38", (Object)applyId, (Object)e);
            this.handleProcessError(applyId);
        }
        catch (Exception e) {
            this.log.error("\u7533\u8bf7ID:{}\u52a0\u5bc6\u6c34\u5370\u5904\u7406\u5f02\u5e38", (Object)applyId, (Object)e);
            this.handleProcessError(applyId);
        }
    }

    private void updateEncryptionWatermarkStatus(ZyfxObjectApply applyInfo, boolean success) {
        try {
            JSONObject paramsNode = JSONObject.parseObject((String)applyInfo.getParams());
            paramsNode.put("EncryptionWatermarkStatus", (Object)success);
            applyInfo.setParams(paramsNode.toJSONString());
            this.applyService.updateById(applyInfo);
        }
        catch (JSONException e) {
            this.log.error("\u66f4\u65b0\u52a0\u5bc6\u6c34\u5370\u72b6\u6001\u5931\u8d25", (Throwable)e);
        }
    }

    private void handleProcessError(String applyId) {
        String redisKey = String.format(REDIS_KEY_PREFIX, applyId);
        this.redisTemplateService.deleteKey(redisKey);
    }

    private void collectAllFolders(File currentDir, List<File> folders) {
        if (currentDir == null || !currentDir.exists() || !currentDir.isDirectory()) {
            return;
        }
        File[] subFiles = currentDir.listFiles();
        if (subFiles != null) {
            for (File subFile : subFiles) {
                if (!subFile.isDirectory()) continue;
                folders.add(subFile);
            }
        }
    }

    private boolean executeEncryption(String exportPath, String applyId, String encryptUser, Date encryptEndtime, String encryptStrKey) {
        try {
            this.log.info("\u5f00\u59cb\u5904\u7406\u7533\u8bf7ID:{}\u7684\u6570\u636e\u52a0\u5bc6\uff0c\u5bfc\u51fa\u8def\u5f84\uff1a{}", (Object)applyId, (Object)exportPath);
            BaseResponse encryptData = this.dataEncryptService.oneEncrypt(exportPath, encryptStrKey, encryptUser, encryptEndtime);
            this.log.info("\u7533\u8bf7ID:{}\u52a0\u5bc6\u64cd\u4f5c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)applyId, (Object)JSON.toJSONString((Object)encryptData));
            if (encryptData.getCode() != 200) {
                this.log.error("\u7533\u8bf7ID:{}\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25\uff0c\u8fd4\u56de\u7801\uff1a{}", (Object)applyId, (Object)encryptData.getCode());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("\u7533\u8bf7ID:{}\u52a0\u5bc6\u64cd\u4f5c\u6267\u884c\u5f02\u5e38", (Object)applyId, (Object)e);
            return false;
        }
    }

    private boolean executeWatermark(String exportPath, String applyId, String watermarkUserInfor, String watermarkDistributor, String watermarkDistributionOperator, String watermarkRemark) {
        try {
            this.log.info("\u5f00\u59cb\u53d1\u8d77\u7533\u8bf7ID:{}\u7684\u6570\u636e\u6c34\u5370\u4efb\u52a1\uff0c\u5bfc\u51fa\u8def\u5f84\uff1a{}", (Object)applyId, (Object)exportPath);
            String agentId = WatermarkTaskClient.getInstance().getAgentId();
            this.log.info("\u7533\u8bf7ID:{}\u83b7\u53d6\u5230\u7684\u4ee3\u7406ID:{}", (Object)applyId, (Object)agentId);
            this.log.info("\u7533\u8bf7ID:{}\u6570\u636e\u6c34\u5370\u53c2\u6570\uff1aUserInfor\uff1a{}\uff0cexportPath\uff1a{}\uff0cwatermarkDistributor\uff1a{}\uff0cwatermarkDistributionOperator\uff1a{}", new Object[]{applyId, watermarkUserInfor, exportPath, watermarkDistributor, watermarkDistributionOperator});
            String taskId = WatermarkTaskClient.getInstance().addEmbedTask(agentId, watermarkUserInfor, exportPath, null, false, applyId, watermarkDistributor, watermarkDistributionOperator, watermarkRemark);
            this.log.info("\u7533\u8bf7ID:{}\u7684\u6c34\u5370\u4efb\u52a1\u5df2\u53d1\u8d77\uff0c\u4efb\u52a1ID:{}", (Object)applyId, (Object)taskId);
            String redisKey = String.format(REDIS_WATERMARK_TASK_PREFIX, applyId);
            this.redisTemplateService.setInfoByBoundValueOps(redisKey, (Object)taskId, REDIS_KEY_EXPIRE_HOURS, TimeUnit.HOURS);
            return true;
        }
        catch (Exception e) {
            this.log.error("\u7533\u8bf7ID:{}\u53d1\u8d77\u6c34\u5370\u4efb\u52a1\u5f02\u5e38", (Object)applyId, (Object)e);
            return false;
        }
    }
}

