/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.zyfx.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WatermarkTaskClient {
    @Value(value="${geomark.waterMark.apiUrl:http://192.168.23.31:8079}")
    private String apiUrl;
    @Value(value="${geomark.waterMark.openApiUrl:http://192.168.23.31:8000}")
    private String baseUrl;
    private static WatermarkTaskClient instance;
    private static final String AGENT_INFO_PATH = "/api/v1/gm/agentInfo/get";
    private static final String ADD_EMBED_TASK_PATH = "/open-api/v1/task/watermark/addEmbedTask";
    private static final String ADD_DETECT_TASK_PATH = "/open-api/v1/task/watermark/addDetectTask";
    private static final String GET_TASK_DETAIL_PATH = "/open-api/v1/task/getTask?id=";
    private static final String GET_TASK_RESULT_PATH = "/open-api/v1/task/getResult?id=";

    @PostConstruct
    public void init() {
        instance = this;
        if (this.baseUrl == null || this.baseUrl.trim().isEmpty()) {
            throw new IllegalArgumentException("geomark.waterMark.url \u914d\u7f6e\u672a\u6ce8\u5165\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
        }
    }

    public static WatermarkTaskClient getInstance() {
        if (instance == null) {
            throw new IllegalStateException("WatermarkTaskClient \u5c1a\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u786e\u4fdd\u8be5\u7c7b\u88abSpring\u5bb9\u5668\u7ba1\u7406");
        }
        return instance;
    }

    public String getAgentId() throws Exception {
        Throwable throwable = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            JSONObject jsonObject;
            Throwable throwable2;
            CloseableHttpResponse response;
            block25: {
                String string;
                block26: {
                    block27: {
                        HttpGet httpGet = new HttpGet(this.apiUrl + AGENT_INFO_PATH);
                        response = httpClient.execute((HttpUriRequest)httpGet);
                        throwable2 = null;
                        HttpEntity entity = response.getEntity();
                        String result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                        jsonObject = JSON.parseObject((String)result);
                        if (jsonObject.getInteger("code") != 0) break block25;
                        string = jsonObject.getJSONObject("data").getString("agentId");
                        if (response == null) break block26;
                        if (throwable2 == null) break block27;
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block26;
                    }
                    response.close();
                }
                return string;
            }
            try {
                try {
                    try {
                        throw new Exception("\u83b7\u53d6\u4ee3\u7406\u4fe1\u606f\u5931\u8d25: " + jsonObject.getString("msg"));
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (response != null) {
                        if (throwable2 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            response.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    public String addEmbedTask(String agentId, String userInfor, String inPath, String outPath, boolean isCopyData, String code, String distributor, String distributionOperator, String remark) throws Exception {
        Throwable throwable = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            JSONObject jsonObject;
            Throwable throwable2;
            CloseableHttpResponse response;
            block30: {
                String string;
                block31: {
                    block32: {
                        HttpPost httpPost = new HttpPost(this.baseUrl + ADD_EMBED_TASK_PATH);
                        httpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("userInfor", userInfor);
                        params.put("inPath", inPath);
                        params.put("agentId", agentId);
                        params.put("isCopyData", isCopyData);
                        if (outPath != null && !outPath.isEmpty()) {
                            params.put("outPath", outPath);
                        }
                        if (code != null && !code.isEmpty()) {
                            params.put("code", code);
                        }
                        if (distributor != null && !distributor.isEmpty()) {
                            params.put("distributor", distributor);
                        }
                        if (distributionOperator != null && !distributionOperator.isEmpty()) {
                            params.put("distributionOperator", distributionOperator);
                        }
                        if (remark != null && !remark.isEmpty()) {
                            params.put("remark", remark);
                        }
                        httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(params), StandardCharsets.UTF_8));
                        response = httpClient.execute((HttpUriRequest)httpPost);
                        throwable2 = null;
                        HttpEntity entity = response.getEntity();
                        String result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                        jsonObject = JSON.parseObject((String)result);
                        if (jsonObject.getInteger("code") != 0) break block30;
                        string = jsonObject.getJSONObject("data").getString("taskId");
                        if (response == null) break block31;
                        if (throwable2 == null) break block32;
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block31;
                    }
                    response.close();
                }
                return string;
            }
            try {
                try {
                    try {
                        throw new Exception("\u6dfb\u52a0\u6c34\u5370\u5d4c\u5165\u4efb\u52a1\u5931\u8d25: " + jsonObject.getString("msg"));
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (response != null) {
                        if (throwable2 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            response.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    public String addDetectTask(String agentId, String inPath) throws Exception {
        Throwable throwable = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            JSONObject jsonObject;
            Throwable throwable2;
            CloseableHttpResponse response;
            block25: {
                String string;
                block26: {
                    block27: {
                        HttpPost httpPost = new HttpPost(this.baseUrl + ADD_DETECT_TASK_PATH);
                        httpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("inPath", inPath);
                        params.put("agentId", agentId);
                        httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(params), StandardCharsets.UTF_8));
                        response = httpClient.execute((HttpUriRequest)httpPost);
                        throwable2 = null;
                        HttpEntity entity = response.getEntity();
                        String result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                        jsonObject = JSON.parseObject((String)result);
                        if (jsonObject.getInteger("code") != 0) break block25;
                        string = jsonObject.getJSONObject("data").getString("taskId");
                        if (response == null) break block26;
                        if (throwable2 == null) break block27;
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block26;
                    }
                    response.close();
                }
                return string;
            }
            try {
                try {
                    try {
                        throw new Exception("\u6dfb\u52a0\u6c34\u5370\u68c0\u6d4b\u4efb\u52a1\u5931\u8d25: " + jsonObject.getString("msg"));
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (response != null) {
                        if (throwable2 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            response.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    public JSONObject getTaskDetail(String taskId) throws Exception {
        Throwable throwable = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            JSONObject jsonObject;
            Throwable throwable2;
            CloseableHttpResponse response;
            block25: {
                JSONObject jSONObject;
                block26: {
                    block27: {
                        HttpGet httpGet = new HttpGet(this.baseUrl + GET_TASK_DETAIL_PATH + taskId);
                        response = httpClient.execute((HttpUriRequest)httpGet);
                        throwable2 = null;
                        HttpEntity entity = response.getEntity();
                        String result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                        jsonObject = JSON.parseObject((String)result);
                        if (jsonObject.getInteger("code") != 0) break block25;
                        jSONObject = jsonObject.getJSONObject("data");
                        if (response == null) break block26;
                        if (throwable2 == null) break block27;
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block26;
                    }
                    response.close();
                }
                return jSONObject;
            }
            try {
                try {
                    try {
                        throw new Exception("\u67e5\u8be2\u4efb\u52a1\u8be6\u60c5\u5931\u8d25: " + jsonObject.getString("msg"));
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (response != null) {
                        if (throwable2 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            response.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    public JSONObject getTaskResult(String taskId, int pageNum, int pageSize) throws Exception {
        Throwable throwable = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            JSONObject jsonObject;
            Throwable throwable2;
            CloseableHttpResponse response;
            block25: {
                JSONObject jSONObject;
                block26: {
                    block27: {
                        String url = this.baseUrl + GET_TASK_RESULT_PATH + taskId + "&pageNum=" + pageNum + "&pageSize=" + pageSize;
                        HttpGet httpGet = new HttpGet(url);
                        response = httpClient.execute((HttpUriRequest)httpGet);
                        throwable2 = null;
                        HttpEntity entity = response.getEntity();
                        String result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                        jsonObject = JSON.parseObject((String)result);
                        if (jsonObject.getInteger("code") != 0) break block25;
                        jSONObject = jsonObject.getJSONObject("data");
                        if (response == null) break block26;
                        if (throwable2 == null) break block27;
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block26;
                    }
                    response.close();
                }
                return jSONObject;
            }
            try {
                try {
                    try {
                        throw new Exception("\u67e5\u8be2\u4efb\u52a1\u7ed3\u679c\u5931\u8d25: " + jsonObject.getString("msg"));
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (response != null) {
                        if (throwable2 != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            response.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    public static void main(String[] args) {
        try {
            WatermarkTaskClient client = WatermarkTaskClient.getInstance();
            String agentId = client.getAgentId();
            System.out.println("\u83b7\u53d6\u5230\u7684\u4ee3\u7406ID: " + agentId);
            String embedTaskId = client.addEmbedTask(agentId, "\u6d4b\u8bd5\u7528\u6237", "D:\\\u6d4b\u8bd5\u6570\u636e\\api", "D:\\\u6d4b\u8bd5\u6570\u636e\\out\\20241106_153000", true, "FD20241106001", "\u9886\u53d6\u4ebaA", "\u5206\u53d1\u4ebaB", "\u6d4b\u8bd5\u6c34\u5370\u5d4c\u5165");
            System.out.println("\u6c34\u5370\u5d4c\u5165\u4efb\u52a1ID: " + embedTaskId);
            Thread.sleep(5000L);
            JSONObject embedTaskDetail = client.getTaskDetail(embedTaskId);
            System.out.println("\u5d4c\u5165\u4efb\u52a1\u72b6\u6001: " + embedTaskDetail.getString("status"));
            String detectTaskId = client.addDetectTask(agentId, "D:\\\u6d4b\u8bd5\u6570\u636e\\out\\20241106_153000");
            System.out.println("\u6c34\u5370\u68c0\u6d4b\u4efb\u52a1ID: " + detectTaskId);
            Thread.sleep(5000L);
            JSONObject detectResult = client.getTaskResult(detectTaskId, 1, 10);
            System.out.println("\u68c0\u6d4b\u4efb\u52a1\u7ed3\u679c\u603b\u6570: " + detectResult.getInteger("total"));
            System.out.println("\u68c0\u6d4b\u4efb\u52a1\u7ed3\u679c\u5217\u8868: " + detectResult.getJSONArray("rows").toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

