CREATE TABLE tb_share_datadelivery_item (
    f_id varchar(64) NOT NULL,
    f_number varchar(64) NOT NULL,
    f_updatetime timestamp(0) DEFAULT NULL,
    f_createtime timestamp(0) DEFAULT NULL,
    f_dataname varchar(128),
    f_datasize float8 DEFAULT NULL,
    f_datatype varchar(128) DEFAULT NULL,
    f_datastage varchar(32),
    f_remark varchar(1024),
    f_savepath varchar(2048),
    f_status int2,
    f_gs varchar(255),
    f_xmin numeric(15,6),
    f_ymin numeric(15,6),
    f_xmax numeric(15,6),
    f_ymax numeric(15,6),
    f_boundary text,
    f_cjsb varchar(128),
    f_prj varchar(255),
    f_gcjz varchar(50),
    f_kjfbl varchar(50),
    f_srs text,
    f_aqjb varchar(50),
    f_sjjb varchar(50),
    f_gxpc int8,
    f_sjfwks timestamp(6),
    f_sjfwjs timestamp(6),
    f_fgfw int2,
    f_quantity numeric(64) DEFAULT NULL,
    f_quantityunit varchar(64),
    f_formid varchar(64)
);

COMMENT ON COLUMN tb_share_datadelivery_item.f_number IS '汇交单编号';
COMMENT ON COLUMN tb_share_datadelivery_item.f_updatetime IS '更新时间';
COMMENT ON COLUMN tb_share_datadelivery_item.f_createtime IS '创建时间';
COMMENT ON COLUMN tb_share_datadelivery_item.f_dataname IS '数据名称';
COMMENT ON COLUMN tb_share_datadelivery_item.f_datasize IS '数据量（GB）';
COMMENT ON COLUMN tb_share_datadelivery_item.f_datastage IS '数据阶段';
COMMENT ON COLUMN tb_share_datadelivery_item.f_remark IS '备注';
COMMENT ON COLUMN tb_share_datadelivery_item.f_savepath IS '存盘';
COMMENT ON COLUMN tb_share_datadelivery_item.f_status IS '是否可用个，0不可用；1可用';
COMMENT ON COLUMN tb_share_datadelivery_item.f_gs IS '数据格式';
COMMENT ON COLUMN tb_share_datadelivery_item.f_xmin IS '数据范围X最小值';
COMMENT ON COLUMN tb_share_datadelivery_item.f_ymin IS '数据范围Y最小值';
COMMENT ON COLUMN tb_share_datadelivery_item.f_xmax IS '数据范围X最大值';
COMMENT ON COLUMN tb_share_datadelivery_item.f_ymax IS '数据范围Y最大值';
COMMENT ON COLUMN tb_share_datadelivery_item.f_boundary IS '数据范围';
COMMENT ON COLUMN tb_share_datadelivery_item.f_cjsb IS '采集设备';
COMMENT ON COLUMN tb_share_datadelivery_item.f_prj IS '投影信息';
COMMENT ON COLUMN tb_share_datadelivery_item.f_gcjz IS '高程基准';
COMMENT ON COLUMN tb_share_datadelivery_item.f_kjfbl IS '空间分辨率';
COMMENT ON COLUMN tb_share_datadelivery_item.f_srs IS '坐标系';
COMMENT ON COLUMN tb_share_datadelivery_item.f_aqjb IS '安全级别';
COMMENT ON COLUMN tb_share_datadelivery_item.f_sjjb IS '数据级别';
COMMENT ON COLUMN tb_share_datadelivery_item.f_gxpc IS '更新频次';
COMMENT ON COLUMN tb_share_datadelivery_item.f_sjfwks IS '数据时间范围（开始时间）';
COMMENT ON COLUMN tb_share_datadelivery_item.f_sjfwjs IS '数据时间范围（结束时间）';
COMMENT ON COLUMN tb_share_datadelivery_item.f_fgfw IS '覆盖范围（1全球 2.全国 3.全省 4.市 5县）';
COMMENT ON COLUMN tb_share_datadelivery_item.f_quantity IS '数据量（手动输入）';
COMMENT ON COLUMN tb_share_datadelivery_item.f_quantityunit IS '数据量单位（手动输入）';
COMMENT ON COLUMN tb_share_datadelivery_item.f_formid IS '分发表单id';
COMMENT ON COLUMN tb_share_datadelivery_item.f_datatype IS '数据类型';
-- ----------------------------
-- Uniques structure for table tb_share_datadelivery_item
-- ----------------------------
ALTER TABLE tb_share_datadelivery_item ADD CONSTRAINT uk_tb_share_datadelivery_item_f_number UNIQUE (f_number);

-- ----------------------------
-- Primary Key structure for table tb_share_datadelivery_item
-- ----------------------------
ALTER TABLE tb_share_datadelivery_item ADD CONSTRAINT pk_tb_share_datadelivery_item PRIMARY KEY (f_id);


ALTER TABLE tb_share_datadelivery
    ADD COLUMN f_lylx varchar(50);

COMMENT ON COLUMN tb_share_datadelivery.f_lylx IS '来源类型';