-- 工具集方案表
CREATE TABLE IF NOT EXISTS tb_zyfx_toolcenter_scheme (
    f_id VARCHAR(64) NOT NULL,
    f_name VARCHAR(200) NOT NULL,
    f_key VARCHAR(100),
    f_sort INT DEFAULT 0,
    f_createtime TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    f_updatetime TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    f_isdefault INT DEFAULT 0,
    f_remark VARCHAR(500),
    CONSTRAINT pk_toolcenter_scheme PRIMARY KEY (f_id)
);

CREATE INDEX idx_toolcenter_scheme_key ON tb_zyfx_toolcenter_scheme(f_key);
CREATE INDEX idx_toolcenter_scheme_sort ON tb_zyfx_toolcenter_scheme(f_sort);

COMMENT ON TABLE tb_zyfx_toolcenter_scheme IS '工具集方案表';
COMMENT ON COLUMN tb_zyfx_toolcenter_scheme.f_id IS '主键ID';
COMMENT ON COLUMN tb_zyfx_toolcenter_scheme.f_name IS '方案名称';
COMMENT ON COLUMN tb_zyfx_toolcenter_scheme.f_key IS '方案关键字';
COMMENT ON COLUMN tb_zyfx_toolcenter_scheme.f_sort IS '排序';
COMMENT ON COLUMN tb_zyfx_toolcenter_scheme.f_createtime IS '创建时间';
COMMENT ON COLUMN tb_zyfx_toolcenter_scheme.f_updatetime IS '更新时间';
COMMENT ON COLUMN tb_zyfx_toolcenter_scheme.f_isdefault IS '是否默认方案(0否 1是)';
COMMENT ON COLUMN tb_zyfx_toolcenter_scheme.f_remark IS '备注';

-- 工具集分组表
CREATE TABLE IF NOT EXISTS tb_zyfx_toolcenter_group (
    f_id VARCHAR(64) NOT NULL,
    f_name VARCHAR(200) NOT NULL,
    f_scheme_id VARCHAR(64) NOT NULL,
    f_sort INT DEFAULT 0,
    f_createtime TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    f_updatetime TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    f_remark VARCHAR(500),
    CONSTRAINT pk_toolcenter_group PRIMARY KEY (f_id),
    CONSTRAINT fk_group_scheme FOREIGN KEY (f_scheme_id) REFERENCES tb_zyfx_toolcenter_scheme(f_id) ON DELETE CASCADE
);

CREATE INDEX idx_toolcenter_group_scheme ON tb_zyfx_toolcenter_group(f_scheme_id);
CREATE INDEX idx_toolcenter_group_sort ON tb_zyfx_toolcenter_group(f_sort);

COMMENT ON TABLE tb_zyfx_toolcenter_group IS '工具集分组表';
COMMENT ON COLUMN tb_zyfx_toolcenter_group.f_id IS '主键ID';
COMMENT ON COLUMN tb_zyfx_toolcenter_group.f_name IS '分组名称';
COMMENT ON COLUMN tb_zyfx_toolcenter_group.f_scheme_id IS '所属方案ID';
COMMENT ON COLUMN tb_zyfx_toolcenter_group.f_sort IS '排序';
COMMENT ON COLUMN tb_zyfx_toolcenter_group.f_createtime IS '创建时间';
COMMENT ON COLUMN tb_zyfx_toolcenter_group.f_updatetime IS '更新时间';
COMMENT ON COLUMN tb_zyfx_toolcenter_group.f_remark IS '备注';

-- 工具集分组关联表
CREATE TABLE IF NOT EXISTS tb_zyfx_toolcenter_group_rel (
    f_id VARCHAR(64) NOT NULL,
    f_group_id VARCHAR(64) NOT NULL,
    f_toolset_id VARCHAR(64) NOT NULL,
    f_sort INT DEFAULT 0,
    f_createtime TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT pk_toolcenter_group_rel PRIMARY KEY (f_id),
    CONSTRAINT uk_group_toolset UNIQUE (f_group_id, f_toolset_id),
    CONSTRAINT fk_rel_group FOREIGN KEY (f_group_id) REFERENCES tb_zyfx_toolcenter_group(f_id) ON DELETE CASCADE,
    CONSTRAINT fk_rel_toolset FOREIGN KEY (f_toolset_id) REFERENCES tb_zyfx_toolset(f_id) ON DELETE CASCADE
);

CREATE INDEX idx_toolcenter_rel_group ON tb_zyfx_toolcenter_group_rel(f_group_id);
CREATE INDEX idx_toolcenter_rel_toolset ON tb_zyfx_toolcenter_group_rel(f_toolset_id);

COMMENT ON TABLE tb_zyfx_toolcenter_group_rel IS '工具集分组关联表';
COMMENT ON COLUMN tb_zyfx_toolcenter_group_rel.f_id IS '主键ID';
COMMENT ON COLUMN tb_zyfx_toolcenter_group_rel.f_group_id IS '分组ID';
COMMENT ON COLUMN tb_zyfx_toolcenter_group_rel.f_toolset_id IS '工具集ID';
COMMENT ON COLUMN tb_zyfx_toolcenter_group_rel.f_sort IS '排序';
COMMENT ON COLUMN tb_zyfx_toolcenter_group_rel.f_createtime IS '创建时间';
