/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sx.biz.dzzh.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemDTO;
import com.geoway.adf.dms.datasource.service.DistrictService;
import com.geoway.ns.sx.biz.dzzh.dto.CamCameraDeviceDto;
import com.geoway.ns.sx.biz.dzzh.enums.CamDeviceSpServiceEnum;
import com.geoway.ns.sx.biz.dzzh.mapper.CamCameraPoMapper;
import com.geoway.ns.sx.biz.dzzh.seo.CameraDeviceSeo;
import com.geoway.ns.sx.biz.dzzh.vo.CameraDeviceSearchVo;
import com.geoway.ns.sx.biz.dzzh.vo.CameraDeviceVo;
import com.geoway.ns.sys.dto.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/camera/info"})
@Api(tags={"\u5730\u707e\u89c6\u9891\u8bbe\u5907"})
public class CameraDeviceController {
    @Autowired
    private CamCameraPoMapper camCameraPoMapper;
    @Autowired
    private DistrictService districtService;
    @Value(value="${sx.disaster.videomonitor.template: http://10.0.0.61:9377/camera-ws/index.html#/videoPage/{} }")
    private String sxttVideomonitorTemplate;
    @Value(value="${sx.disaster.dzVideomonitor.template: https://workplatform.sxch.com.cn:9110/dzzh/#/videoPage/{} }")
    private String dzVideomonitorTemplate;

    @RequestMapping(value={"/deviceInfo"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u89c6\u9891\u8bbe\u5907\u8be6\u60c5")
    public RestResult<CameraDeviceVo> deviceInfo(String cameraId) {
        CamCameraDeviceDto dto = this.camCameraPoMapper.getCameraDeviceByCameraId(cameraId);
        CameraDeviceVo vo = new CameraDeviceVo();
        BeanUtils.copyProperties((Object)dto, (Object)vo);
        if (Objects.equals(vo.getSpService(), CamDeviceSpServiceEnum.\u5c71\u897f\u7701\u94c1\u5854.getCode())) {
            vo.setVideomonitorUrl(this.sxttVideomonitorTemplate.replace("{}", vo.getCameraId()));
        } else if (Objects.equals(vo.getSpService(), CamDeviceSpServiceEnum.\u5730\u707e\u6444\u50cf\u5934.getCode())) {
            vo.setVideomonitorUrl(this.dzVideomonitorTemplate.replace("{}", vo.getCameraId()));
        }
        return RestResult.success((Object)vo);
    }

    @RequestMapping(value={"/devicePage"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u89c6\u9891\u8bbe\u5907\u5206\u9875")
    public RestResult<IPage<CameraDeviceVo>> devicePage(CameraDeviceSearchVo searchVo) {
        CameraDeviceSeo seo = new CameraDeviceSeo();
        seo.setKeyword(searchVo.getDeviceName());
        if (StrUtil.isNotBlank((CharSequence)searchVo.getRegionCode())) {
            DistrictItemDTO item = this.districtService.getDistrictItemDetail(null, searchVo.getRegionCode());
            Integer level = (int)item.getLevelIndex();
            String regionLike = "000";
            if (level == 1) {
                regionLike = item.getCode().substring(0, 2);
            } else if (level == 2) {
                regionLike = item.getCode().substring(0, 4);
            } else if (level == 3) {
                regionLike = item.getCode().substring(0, 6);
            } else if (level == 4) {
                regionLike = item.getCode().substring(0, 8);
            } else if (level == 5) {
                regionLike = item.getCode().substring(0, 10);
            }
            seo.setRegionCodeLike(regionLike);
        } else {
            seo.setDistance(searchVo.getDistance());
            seo.setLatitude(searchVo.getLatitude());
            seo.setLongitude(searchVo.getLongitude());
        }
        IPage<CamCameraDeviceDto> devicePage = this.camCameraPoMapper.listCameraDevicePage((IPage<CamCameraDeviceDto>)Page.of((long)1L, (long)1000L), seo);
        List records = devicePage.getRecords().stream().map(po -> {
            CameraDeviceVo vo = new CameraDeviceVo();
            BeanUtils.copyProperties((Object)po, (Object)vo);
            if (Objects.equals(vo.getSpService(), CamDeviceSpServiceEnum.\u5c71\u897f\u7701\u94c1\u5854.getCode())) {
                vo.setVideomonitorUrl(this.sxttVideomonitorTemplate.replace("{}", vo.getCameraId()));
            } else if (Objects.equals(vo.getSpService(), CamDeviceSpServiceEnum.\u5730\u707e\u6444\u50cf\u5934.getCode())) {
                vo.setVideomonitorUrl(this.dzVideomonitorTemplate.replace("{}", vo.getCameraId()));
            }
            return vo;
        }).collect(Collectors.toList());
        Page listVoPager = new Page();
        listVoPager.setTotal(devicePage.getTotal());
        listVoPager.setRecords(records);
        return RestResult.success((Object)listVoPager);
    }
}

