/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sx.biz.dzzh.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemDTO;
import com.geoway.ns.sx.biz.dzzh.config.DisasterDZZHConfig;
import com.geoway.ns.sx.biz.dzzh.dto.CamDeviceDto;
import com.geoway.ns.sx.biz.dzzh.entity.CamCameraPo;
import com.geoway.ns.sx.biz.dzzh.entity.DataUpInfo;
import com.geoway.ns.sx.biz.dzzh.entity.MetRecord;
import com.geoway.ns.sx.biz.dzzh.entity.SensorPo;
import com.geoway.ns.sx.biz.dzzh.entity.YhdRecord;
import com.geoway.ns.sx.biz.dzzh.enums.CamDeviceSpServiceEnum;
import com.geoway.ns.sx.biz.dzzh.enums.MonitoringSensorTypeEnum;
import com.geoway.ns.sx.biz.dzzh.enums.StatusValidEnum;
import com.geoway.ns.sx.biz.dzzh.mapper.CamCameraPoMapper;
import com.geoway.ns.sx.biz.dzzh.mapper.CamDevicePoMapper;
import com.geoway.ns.sx.biz.dzzh.mapper.DataUpInfoMapper;
import com.geoway.ns.sx.biz.dzzh.mapper.MetRecordMapper;
import com.geoway.ns.sx.biz.dzzh.mapper.SensorPoMapper;
import com.geoway.ns.sx.biz.dzzh.mo.AreaWarningHandleCountMo;
import com.geoway.ns.sx.biz.dzzh.mo.HiddenPointMo;
import com.geoway.ns.sx.biz.dzzh.mo.MeteorologicalMo;
import com.geoway.ns.sx.biz.dzzh.mo.VideoCountMo;
import com.geoway.ns.sx.biz.dzzh.mo.WarningEventMo;
import com.geoway.ns.sx.biz.dzzh.seo.CamDeviceSeo;
import com.geoway.ns.sx.biz.dzzh.seo.CameraDisasterDeviceSeo;
import com.geoway.ns.sx.biz.dzzh.seo.HiddenPointSeo;
import com.geoway.ns.sx.biz.dzzh.seo.MeteorologicalSeo;
import com.geoway.ns.sx.biz.dzzh.seo.WarningEventMoSeo;
import com.geoway.ns.sx.biz.dzzh.seo.YhdRecordSeo;
import com.geoway.ns.sx.biz.dzzh.service.CamDeviceRegionService;
import com.geoway.ns.sx.biz.dzzh.service.CamDeviceService;
import com.geoway.ns.sx.biz.dzzh.service.DzzhQueryService;
import com.geoway.ns.sx.biz.dzzh.service.MeteorologicalService;
import com.geoway.ns.sx.biz.dzzh.service.WarningEventService;
import com.geoway.ns.sx.biz.dzzh.vo.CameraDeviceSearchVo;
import com.geoway.ns.sx.biz.dzzh.vo.HiddenPointSearchVo;
import com.geoway.ns.sx.biz.dzzh.vo.HiddenPointVo;
import com.geoway.ns.sx.biz.dzzh.vo.MetRecordVo;
import com.geoway.ns.sx.biz.dzzh.vo.MeteorologicalSearchVo;
import com.geoway.ns.sx.biz.dzzh.vo.MeteorologicalWarningCountVo;
import com.geoway.ns.sx.biz.dzzh.vo.MonitoringSensorTypeVo;
import com.geoway.ns.sx.biz.dzzh.vo.ProvinceVo;
import com.geoway.ns.sx.biz.dzzh.vo.RainWarningCountVo;
import com.geoway.ns.sx.biz.dzzh.vo.VideoCountSeo;
import com.geoway.ns.sx.biz.dzzh.vo.VideoCountVo;
import com.geoway.ns.sx.biz.dzzh.vo.WarningEventSearchVo;
import com.geoway.ns.sx.biz.dzzh.vo.WarningEventVo;
import com.geoway.ns.sys.dto.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/dzzh/warningEvent"})
@Api(tags={"\u5730\u707e\u76d1\u6d4b\u9884\u8b66"})
public class DzzhMonitorController {
    @Autowired
    private WarningEventService warningEventService;
    @Autowired
    private CamDeviceRegionService camDeviceRegionService;
    @Autowired
    private MeteorologicalService meteorologicalService;
    @Autowired
    private CamDeviceService camDeviceService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    DzzhQueryService dzzhQueryService;
    @Autowired
    DataUpInfoMapper dataUpInfoMapper;
    @Autowired
    MetRecordMapper metRecordMapper;
    @Autowired
    SensorPoMapper sensorPoMapper;
    @Autowired
    private CamCameraPoMapper camCameraPoMapper;
    @Autowired
    private CamDevicePoMapper camDevicePoMapper;
    @Value(value="${sx.disaster.meteorological.url: http://218.26.7.100:3003/yjyb/business/custom/extend/N{ttlKey}0{}/result/getWarnRes?time={timeStr}}")
    private String meteorologicalUrl;
    ExecutorService executorService = Executors.newFixedThreadPool(4);
    private final DisasterDZZHConfig dzConfig;

    public DzzhMonitorController(DisasterDZZHConfig dzConfig) {
        this.dzConfig = dzConfig;
    }

    @RequestMapping(value={"/warningNewPage"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u6700\u65b0\u76d1\u6d4b\u9884\u8b66\u4fe1\u606f")
    public RestResult<IPage<WarningEventMo>> warningNewPage(WarningEventSearchVo warningEventMoSeo) throws Exception {
        WarningEventMoSeo seo = new WarningEventMoSeo();
        if (null != warningEventMoSeo.getAreaCode()) {
            String codeFormat = this.areaCodeFormat(warningEventMoSeo.getAreaCode());
            seo.setAreaCode(codeFormat);
        }
        if (null != warningEventMoSeo.getHiddenName()) {
            seo.setHiddenName(warningEventMoSeo.getHiddenName());
        }
        if (null != warningEventMoSeo.getHiddenPoint()) {
            seo.setHiddenPoint(warningEventMoSeo.getHiddenPoint());
        }
        if (null != warningEventMoSeo.getRain()) {
            seo.setIsRain(warningEventMoSeo.getRain());
        }
        if (null != warningEventMoSeo.getSensorId()) {
            seo.setSensorId(warningEventMoSeo.getSensorId());
        }
        if (null != warningEventMoSeo.getWarningCode()) {
            seo.setWarningCode(warningEventMoSeo.getWarningCode());
        }
        if (null != warningEventMoSeo.getWarningStatus()) {
            seo.setWarningStatus(warningEventMoSeo.getWarningStatus());
        }
        DateTime startTime = DateUtil.beginOfDay((Date)new Date());
        seo.setStartTime((Date)startTime);
        IPage<WarningEventMo> pageList = this.warningEventService.getNewestWarningEvents(seo, warningEventMoSeo.getCurrentPage(), warningEventMoSeo.getPageSize());
        return RestResult.success(pageList);
    }

    @RequestMapping(value={"/warningNewList"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u4eca\u65e5\u6700\u65b0\u76d1\u6d4b\u9884\u8b66\u4fe1\u606f(\u663e\u793a\u5230\u5730\u56fe)")
    public RestResult<List<WarningEventVo>> deviceWarningNewList(WarningEventSearchVo warningEventMoSeo) throws Exception {
        WarningEventMoSeo seo = new WarningEventMoSeo();
        if (null != warningEventMoSeo.getAreaCode()) {
            String codeFormat = this.areaCodeFormat(warningEventMoSeo.getAreaCode());
            seo.setAreaCode(codeFormat);
        }
        if (null != warningEventMoSeo.getHiddenName()) {
            seo.setHiddenName(warningEventMoSeo.getHiddenName());
        }
        if (null != warningEventMoSeo.getHiddenPoint()) {
            seo.setHiddenPoint(warningEventMoSeo.getHiddenPoint());
        }
        if (null != warningEventMoSeo.getRain()) {
            seo.setIsRain(warningEventMoSeo.getRain());
        }
        if (null != warningEventMoSeo.getSensorId()) {
            seo.setSensorId(warningEventMoSeo.getSensorId());
        }
        if (null != warningEventMoSeo.getWarningCode()) {
            seo.setWarningCode(warningEventMoSeo.getWarningCode());
        }
        if (null != warningEventMoSeo.getWarningStatus()) {
            seo.setWarningStatus(warningEventMoSeo.getWarningStatus());
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isNotBlank((CharSequence)warningEventMoSeo.getStartTime())) {
            LocalDate localDate = LocalDate.parse(warningEventMoSeo.getStartTime(), formatter);
            Date startDate = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
            LocalDate nextDay = localDate.plusDays(1L);
            Date endDate = Date.from(nextDay.atStartOfDay(ZoneId.systemDefault()).toInstant());
            seo.setStartTime(startDate);
            seo.setEndTime(endDate);
        }
        ArrayList list = new ArrayList();
        int page = 0;
        int pageSize = 25;
        boolean flag = true;
        while (flag) {
            IPage<WarningEventMo> pageList;
            List rows;
            if ((rows = (pageList = this.warningEventService.getNewestWarningEvents(seo, ++page, pageSize)).getRecords()).size() != 0) {
                rows.forEach(warningEventMo -> {
                    WarningEventVo warningEventVo = new WarningEventVo();
                    BeanUtils.copyProperties((Object)warningEventMo, (Object)warningEventVo);
                    list.add(warningEventVo);
                });
                continue;
            }
            flag = false;
        }
        return RestResult.success(list);
    }

    @RequestMapping(value={"/rainWarningCount"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u96e8\u91cf\u9884\u8b66\u6570\u91cf")
    public RestResult<RainWarningCountVo> rainWarningCount(@RequestParam(value="areaCode") String areaCode) throws Exception {
        String codeFormat = this.areaCodeFormat(areaCode);
        List<AreaWarningHandleCountMo> rainWarningCountList = this.warningEventService.getWarningCount(codeFormat);
        RainWarningCountVo rainWarningCountVo = new RainWarningCountVo();
        rainWarningCountList.forEach(rc -> {
            String condition;
            switch (condition = rc.getCode() + "," + rc.getType()) {
                case "C1,rain": {
                    rainWarningCountVo.setBlueCount(rc.getCount().intValue());
                    break;
                }
                case "C2,rain": {
                    rainWarningCountVo.setYellowCount(rc.getCount().intValue());
                    break;
                }
                case "C3,rain": {
                    rainWarningCountVo.setOrangeCount(rc.getCount().intValue());
                    break;
                }
                case "C4,rain": {
                    rainWarningCountVo.setRedCount(rc.getCount().intValue());
                    break;
                }
            }
        });
        return RestResult.success((Object)rainWarningCountVo);
    }

    @RequestMapping(value={"/meteorologicalWarningCount"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u6c14\u8c61\u9884\u8b66\u6570\u91cf")
    public RestResult<List<MetRecordVo>> meteorologicalWarningCount(MeteorologicalSearchVo searchVo) throws Exception {
        String ttlKey = searchVo.getRegionId();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date now = new Date();
        final String nowStr = sdf.format(now);
        List<DataUpInfo> items = this.dataUpInfoMapper.queryByType("met-info");
        final Long totalCount = 0L;
        LocalDate today = LocalDate.now();
        LocalDate yesterday = today.minusDays(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String yesterdayStr = yesterday.format(formatter);
        String url = this.meteorologicalUrl.replace("{ttlKey}", ttlKey).replace("{timeStr}", yesterdayStr);
        String resStr = this.dzConfig.getJson(url, null);
        JSONObject jsonObject = JSONObject.parseObject((String)resStr);
        JSONArray data = jsonObject.getJSONArray("data");
        JSONObject jsonObject1 = data.getJSONObject(0);
        final JSONArray records = jsonObject1.getJSONArray("yhdList");
        ArrayList<MetRecordVo> list = new ArrayList<MetRecordVo>();
        for (int i = 0; i < records.size(); ++i) {
            String gbCode = records.getJSONObject(i).getString("gbCode");
            String code = records.getJSONObject(i).getString("code");
            String town = records.getJSONObject(i).get((Object)"town") != null ? records.getJSONObject(i).getString("town") : "";
            String city = records.getJSONObject(i).get((Object)"city") != null ? records.getJSONObject(i).getString("city") : "";
            String xqdj = records.getJSONObject(i).get((Object)"xqdj") != null ? records.getJSONObject(i).getString("xqdj") : "";
            String monitor = records.getJSONObject(i).get((Object)"monitor") != null ? records.getJSONObject(i).getString("monitor") : "";
            String type = records.getJSONObject(i).get((Object)"type") != null ? records.getJSONObject(i).getString("type") : "";
            String wxrk = records.getJSONObject(i).get((Object)"wxrk") != null ? records.getJSONObject(i).getString("wxrk") : "";
            String province = records.getJSONObject(i).get((Object)"province") != null ? records.getJSONObject(i).getString("province") : "";
            String phone = records.getJSONObject(i).get((Object)"phone") != null ? records.getJSONObject(i).getString("phone") : "";
            String wxcc = records.getJSONObject(i).get((Object)"wxcc") != null ? records.getJSONObject(i).getString("wxcc") : "";
            String grade = records.getJSONObject(i).get((Object)"grade") != null ? records.getJSONObject(i).getString("grade") : "";
            String longitude = records.getJSONObject(i).get((Object)"x") != null ? records.getJSONObject(i).getString("x") : "";
            String latitude = records.getJSONObject(i).get((Object)"y") != null ? records.getJSONObject(i).getString("y") : "";
            String location = records.getJSONObject(i).get((Object)"location") != null ? records.getJSONObject(i).getString("location") : "";
            String wxhs = records.getJSONObject(i).get((Object)"wxhs") != null ? records.getJSONObject(i).getString("wxhs") : "";
            String gmdj = records.getJSONObject(i).get((Object)"gmdj") != null ? records.getJSONObject(i).getString("gmdj") : "";
            String village = records.getJSONObject(i).get((Object)"village") != null ? records.getJSONObject(i).getString("village") : "";
            MetRecordVo mRecord = new MetRecordVo();
            mRecord.setMetid(gbCode);
            mRecord.setMetcode(code);
            mRecord.setMettown(town);
            mRecord.setMetcity(city);
            mRecord.setMetxqdj(xqdj);
            mRecord.setMetmonitor(monitor);
            mRecord.setMettype(type);
            mRecord.setMetwxrk(wxrk);
            mRecord.setMetprovince(province);
            mRecord.setMetphone(phone);
            mRecord.setMetwxcc(wxcc);
            mRecord.setMetgrade(grade);
            mRecord.setLon(longitude);
            mRecord.setLat(latitude);
            mRecord.setMetlocation(location);
            mRecord.setMetwxhs(wxhs);
            mRecord.setMetgmdj(gmdj);
            mRecord.setMetvillage(village);
            mRecord.setMetuptime(nowStr);
            list.add(mRecord);
        }
        if (items.size() == 0 || items.size() > 0 && !items.get(0).getTime().equalsIgnoreCase(nowStr)) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    DataUpInfo daupN = new DataUpInfo();
                    String crId = UUID.randomUUID().toString();
                    daupN.setId(crId);
                    daupN.setType("met-info");
                    daupN.setTime(nowStr);
                    daupN.setCount(totalCount);
                    daupN.setState(0);
                    DzzhMonitorController.this.dataUpInfoMapper.insert(daupN);
                    try {
                        String lsSql = "";
                        for (int i = 0; i < records.size(); ++i) {
                            try {
                                String gbCode = records.getJSONObject(i).getString("gbCode");
                                MetRecord metRecord = (MetRecord)DzzhMonitorController.this.metRecordMapper.selectById((Serializable)((Object)gbCode));
                                if (metRecord != null) continue;
                                String code = records.getJSONObject(i).getString("code");
                                String town = records.getJSONObject(i).get((Object)"town") != null ? records.getJSONObject(i).getString("town") : "";
                                String city = records.getJSONObject(i).get((Object)"city") != null ? records.getJSONObject(i).getString("city") : "";
                                String xqdj = records.getJSONObject(i).get((Object)"xqdj") != null ? records.getJSONObject(i).getString("xqdj") : "";
                                String monitor = records.getJSONObject(i).get((Object)"monitor") != null ? records.getJSONObject(i).getString("monitor") : "";
                                String type = records.getJSONObject(i).get((Object)"type") != null ? records.getJSONObject(i).getString("type") : "";
                                String wxrk = records.getJSONObject(i).get((Object)"wxrk") != null ? records.getJSONObject(i).getString("wxrk") : "";
                                String province = records.getJSONObject(i).get((Object)"province") != null ? records.getJSONObject(i).getString("province") : "";
                                String phone = records.getJSONObject(i).get((Object)"phone") != null ? records.getJSONObject(i).getString("phone") : "";
                                String wxcc = records.getJSONObject(i).get((Object)"wxcc") != null ? records.getJSONObject(i).getString("wxcc") : "";
                                String grade = records.getJSONObject(i).get((Object)"grade") != null ? records.getJSONObject(i).getString("grade") : "";
                                String longitude = records.getJSONObject(i).get((Object)"x") != null ? records.getJSONObject(i).getString("x") : "";
                                String latitude = records.getJSONObject(i).get((Object)"y") != null ? records.getJSONObject(i).getString("y") : "";
                                String location = records.getJSONObject(i).get((Object)"location") != null ? records.getJSONObject(i).getString("location") : "";
                                String wxhs = records.getJSONObject(i).get((Object)"wxhs") != null ? records.getJSONObject(i).getString("wxhs") : "";
                                String gmdj = records.getJSONObject(i).get((Object)"gmdj") != null ? records.getJSONObject(i).getString("gmdj") : "";
                                String village = records.getJSONObject(i).get((Object)"village") != null ? records.getJSONObject(i).getString("village") : "";
                                MetRecord mRecord = new MetRecord();
                                mRecord.setMetid(gbCode);
                                mRecord.setMetcode(code);
                                mRecord.setMettown(town);
                                mRecord.setMetcity(city);
                                mRecord.setMetxqdj(xqdj);
                                mRecord.setMetmonitor(monitor);
                                mRecord.setMettype(type);
                                mRecord.setMetwxrk(wxrk);
                                mRecord.setMetprovince(province);
                                mRecord.setMetphone(phone);
                                mRecord.setMetwxcc(wxcc);
                                mRecord.setMetgrade(grade);
                                mRecord.setLongitude(longitude);
                                mRecord.setLatitude(latitude);
                                mRecord.setMetlocation(location);
                                mRecord.setMetwxhs(wxhs);
                                mRecord.setMetgmdj(gmdj);
                                mRecord.setMetvillage(village);
                                mRecord.setMetuptime(nowStr);
                                DzzhMonitorController.this.metRecordMapper.insert(mRecord);
                            }
                            catch (Exception ex) {
                                System.out.println(ex.getMessage());
                            }
                            JSONObject jSONObject = records.getJSONObject(i);
                        }
                    }
                    catch (Exception eex) {
                        System.out.println(eex.getMessage());
                    }
                    DzzhMonitorController.this.dataUpInfoMapper.updateState(1, crId);
                }
            });
        }
        return RestResult.success(list);
    }

    @RequestMapping(value={"/monitorWarningCount"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u76d1\u6d4b\u9884\u8b66\u6570\u91cf")
    public RestResult<MeteorologicalWarningCountVo> monitorWarningCount(@RequestParam(value="areaCode") String areaCode) {
        String codeFormat = this.areaCodeFormat(areaCode);
        List<AreaWarningHandleCountMo> warningEventMoList = this.warningEventService.getWarningCount(codeFormat);
        MeteorologicalWarningCountVo meteorologicalWarningCountVo = new MeteorologicalWarningCountVo();
        warningEventMoList.forEach(we -> {
            String condition;
            switch (condition = we.getCode() + "," + we.getType()) {
                case "C1,device": {
                    meteorologicalWarningCountVo.setBlueCount(we.getCount().intValue());
                    break;
                }
                case "C2,device": {
                    meteorologicalWarningCountVo.setYellowCount(we.getCount().intValue());
                    break;
                }
                case "C3,device": {
                    meteorologicalWarningCountVo.setOrangeCount(we.getCount().intValue());
                    break;
                }
                case "C4,device": {
                    meteorologicalWarningCountVo.setRedCount(we.getCount().intValue());
                    break;
                }
                case "0,status": {
                    meteorologicalWarningCountVo.setWaitHandleCount(we.getCount().intValue());
                    break;
                }
                case "3,status": {
                    meteorologicalWarningCountVo.setStartCheckCount(we.getCount().intValue());
                    break;
                }
                case "4,status": {
                    meteorologicalWarningCountVo.setWaitAuditCount(we.getCount().intValue());
                    break;
                }
                case "5,status": {
                    meteorologicalWarningCountVo.setAuditCountReturn(we.getCount().intValue());
                    break;
                }
                case "6,status": {
                    meteorologicalWarningCountVo.setAuditPassCount(we.getCount().intValue());
                    break;
                }
            }
        });
        return RestResult.success((Object)meteorologicalWarningCountVo);
    }

    @RequestMapping(value={"/monitorSensorType"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u76d1\u6d4b\uff08\u4f20\u611f\u5668\uff09\u7c7b\u578b")
    public RestResult<List<MonitoringSensorTypeVo>> monitorWarningCount() {
        List<MonitoringSensorTypeVo> allSensorInfoEntities = this.getAllSensorInfoEntities();
        return RestResult.success(allSensorInfoEntities);
    }

    private String areaCodeFormat(String areaCode) {
        String areaCodeFormat = this.camDeviceRegionService.areaCodeFormat(areaCode);
        return areaCodeFormat;
    }

    public static List<MonitoringSensorTypeVo> getAllSensorInfoEntities() {
        ArrayList<MonitoringSensorTypeVo> monitoringSensorTypeVos = new ArrayList<MonitoringSensorTypeVo>();
        for (MonitoringSensorTypeEnum sensorType : MonitoringSensorTypeEnum.values()) {
            monitoringSensorTypeVos.add(sensorType.getSensorInfoVO());
        }
        return monitoringSensorTypeVos;
    }

    @RequestMapping(value={"/meteorologicalLocationInfo"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u6c14\u8c61\u9884\u8b66\u6240\u6709\u4fe1\u606f-\u5730\u56fe\u4f7f\u7528")
    public RestResult<?> meteorologicalLocationInfo(MeteorologicalSearchVo searchVo) {
        String redisKey = "meteorological:" + searchVo.getRegionId();
        HashMap<String, List<MeteorologicalMo>> cacheMap = (HashMap<String, List<MeteorologicalMo>>)this.redisTemplate.opsForValue().get((Object)redisKey);
        if (cacheMap == null || cacheMap.isEmpty()) {
            HashMap<String, List<MeteorologicalMo>> map = new HashMap<String, List<MeteorologicalMo>>();
            MeteorologicalSeo seo = new MeteorologicalSeo();
            BeanUtils.copyProperties((Object)searchVo, (Object)seo);
            seo.setGrade1(true);
            List<MeteorologicalMo> red = this.meteorologicalService.getMeteorologicalLocationInfoByRegionId(seo);
            seo.setGrade1(false);
            seo.setGrade2(true);
            List<MeteorologicalMo> orange = this.meteorologicalService.getMeteorologicalLocationInfoByRegionId(seo);
            seo.setGrade2(false);
            seo.setGrade3(true);
            List<MeteorologicalMo> yellow = this.meteorologicalService.getMeteorologicalLocationInfoByRegionId(seo);
            seo.setGrade3(false);
            seo.setGrade4(true);
            List<MeteorologicalMo> blue = this.meteorologicalService.getMeteorologicalLocationInfoByRegionId(seo);
            map.put("red", red);
            map.put("orange", orange);
            map.put("yellow", yellow);
            map.put("blue", blue);
            this.redisTemplate.opsForValue().set((Object)redisKey, map, 24L, TimeUnit.HOURS);
            cacheMap = map;
        }
        return RestResult.success((Object)cacheMap);
    }

    @Deprecated
    @RequestMapping(value={"/hiddenPointList"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u9690\u60a3\u70b9\u5217\u8868\u6570\u636e(\u5730\u56fe)")
    public RestResult<ProvinceVo> hiddenPointList(HiddenPointSearchVo hiddenPointSearchVo) {
        StringBuilder paramSb = new StringBuilder();
        HiddenPointSeo seo = new HiddenPointSeo();
        if (null != hiddenPointSearchVo.getAreaCode()) {
            String codeFormat = this.areaCodeFormat(hiddenPointSearchVo.getAreaCode());
            seo.setAreaCode(codeFormat);
            paramSb.append(codeFormat);
        }
        if (null != hiddenPointSearchVo.getHiddenPoint()) {
            seo.setHiddenPoint(hiddenPointSearchVo.getHiddenPoint());
            paramSb.append(hiddenPointSearchVo.getHiddenPoint());
        }
        if (null != hiddenPointSearchVo.getHiddenPointName()) {
            seo.setHiddenPointName(hiddenPointSearchVo.getHiddenPointName());
            paramSb.append(hiddenPointSearchVo.getHiddenPointName());
        }
        if (null != hiddenPointSearchVo.getHiddenPointType()) {
            seo.setHiddenPointType(hiddenPointSearchVo.getHiddenPointType());
            paramSb.append(hiddenPointSearchVo.getHiddenPointType());
        }
        String redisKey = "hiddenPointList:" + paramSb;
        ArrayList<HiddenPointVo> nlist = new ArrayList<HiddenPointVo>();
        ProvinceVo provinceVo = (ProvinceVo)this.redisTemplate.opsForValue().get((Object)redisKey);
        if (null == provinceVo) {
            List<HiddenPointMo> rows = this.warningEventService.getHiddenPointList(seo);
            rows.stream().forEach(hiddenPoint -> {
                HiddenPointVo hiddenPointVo = new HiddenPointVo();
                BeanUtils.copyProperties((Object)hiddenPoint, (Object)hiddenPointVo);
                nlist.add(hiddenPointVo);
            });
            provinceVo = this.buildTree(nlist);
            this.redisTemplate.opsForValue().set((Object)redisKey, (Object)provinceVo, 24L, TimeUnit.HOURS);
        }
        return RestResult.success((Object)provinceVo);
    }

    @RequestMapping(value={"/jcsbCount"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u76d1\u6d4b\u8bbe\u5907\u603b\u6570")
    public RestResult<?> jcsbCount(String xzqdm) throws Exception {
        Long count = this.dzzhQueryService.getJcsbCount();
        return RestResult.success((Object)count);
    }

    @RequestMapping(value={"/cgqCount"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u4f20\u611f\u5668\u603b\u6570")
    public RestResult<?> cgqCount() throws Exception {
        Long count = this.dzzhQueryService.getCgqCount();
        return RestResult.success((Object)count);
    }

    @RequestMapping(value={"/queryAllJcsbs"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u76d1\u6d4b\u8bbe\u5907\u805a\u5408\u7edf\u8ba1\u4fe1\u606f")
    public RestResult<?> queryAllJcsbs() throws Exception {
        List<Map<String, Object>> results = this.dzzhQueryService.queryAllJcsbs();
        return RestResult.success(results);
    }

    @RequestMapping(value={"/queryAllCgqs"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u4f20\u611f\u5668\u805a\u5408\u7edf\u8ba1\u4fe1\u606f")
    public RestResult<?> queryAllCgqs() throws Exception {
        List<Map<String, Object>> results = this.dzzhQueryService.queryAllCgqs();
        return RestResult.success(results);
    }

    @RequestMapping(value={"/hiddenPointListNew"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u9690\u60a3\u70b9\u7edf\u8ba1\u4fe1\u606f")
    public RestResult<?> hiddenPointListNew(String areaCode) throws Exception {
        Map<String, Object> results = this.dzzhQueryService.hiddenPointListNew(areaCode);
        return RestResult.success(results);
    }

    @RequestMapping(value={"/hiddenPointTypeNew"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u9690\u60a3\u70b9\u7edf\u8ba1\u4fe1\u606f")
    public RestResult<?> hiddenPointTypeNew(String areaCode) throws Exception {
        Map<String, Object> results = this.dzzhQueryService.hiddenPointTypeNew(areaCode);
        return RestResult.success(results);
    }

    @RequestMapping(value={"/getDetailById"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u56fe\u6591\u8be6\u7ec6\u4fe1\u606f")
    public RestResult<?> getDetailById(String id, String type) throws Exception {
        Map<String, Object> result = this.dzzhQueryService.getDetailById(id, type);
        return RestResult.success(result);
    }

    @RequestMapping(value={"/videoCount"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u5730\u707e\u63a2\u5934\u6570\u91cf")
    public RestResult<?> videoCount(VideoCountSeo videoCountSeo) {
        VideoCountVo videoCount = new VideoCountVo();
        String spService = CamDeviceSpServiceEnum.\u5730\u707e\u6444\u50cf\u5934.value();
        String statusValid = StatusValidEnum.\u6709\u6548.value();
        if (null != videoCountSeo.getSpService()) {
            spService = videoCountSeo.getSpService();
        }
        VideoCountMo videoCountMo = this.camDeviceService.getVideoCount(spService, statusValid);
        BeanUtils.copyProperties((Object)videoCountMo, (Object)videoCount);
        return RestResult.success((Object)videoCount);
    }

    @RequestMapping(value={"/devicePage"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u5730\u707e\u63a2\u5934\u6570\u91cf")
    public RestResult<IPage<SensorPo>> devicePage2(CameraDeviceSearchVo searchVo) {
        CameraDisasterDeviceSeo seo = new CameraDisasterDeviceSeo();
        BeanUtils.copyProperties((Object)searchVo, (Object)seo);
        if (null != searchVo.getRegionCode()) {
            List<DistrictItemDTO> deviceRegionByRegionCode = this.camDeviceRegionService.getRegionByRegionCode(searchVo.getRegionCode());
            ArrayList<String> regionIds = new ArrayList<String>();
            for (DistrictItemDTO regionDto : deviceRegionByRegionCode) {
                regionIds.add(regionDto.getCode());
            }
            seo.setRegionIds(regionIds);
        }
        IPage<SensorPo> devicePage = this.sensorPoMapper.getDeviceList((IPage<SensorPo>)Page.of((long)1L, (long)1000L), seo);
        return RestResult.success(devicePage);
    }

    @RequestMapping(value={"/getDeviceTtList"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u5730\u707e\u63a2\u5934\u6570\u91cf")
    public RestResult<IPage<CamDeviceDto>> getDeviceTtList(CameraDeviceSearchVo searchVo) {
        CamDeviceSeo camDeviceSeo = new CamDeviceSeo();
        camDeviceSeo.setStatusValid("valid");
        IPage<CamDeviceDto> devicePage = this.camDevicePoMapper.searchListPage((IPage<CamDeviceDto>)Page.of((long)1L, (long)10000L), camDeviceSeo);
        return RestResult.success(devicePage);
    }

    @RequestMapping(value={"/getCamCameraInfo"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u5730\u707e\u63a2\u5934\u6444\u50cf\u5934\u8be6\u60c5\u6570\u636e")
    public RestResult<?> getCamCameraInfo(String deviceId) {
        List<CamCameraPo> list = this.camCameraPoMapper.getCamerasByDeviceId(deviceId);
        return RestResult.success(list);
    }

    public ProvinceVo buildTree(List<HiddenPointVo> hiddenPointList) {
        String provinceName = "\u5c71\u897f\u7701";
        ProvinceVo province = new ProvinceVo(provinceName);
        return province;
    }

    @RequestMapping(value={"/yhdRecordPage"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u9690\u60a3\u70b9\u4fe1\u606f")
    public RestResult<?> yhdRecordPage(YhdRecordSeo yhdRecordSeo) {
        try {
            IPage<YhdRecord> yhdRecordGiPager = this.warningEventService.yhdRecordPage(yhdRecordSeo);
            return RestResult.success(yhdRecordGiPager);
        }
        catch (Exception e) {
            return RestResult.error((String)e.getMessage());
        }
    }
}

