/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.sx.biz.dzzh.service.impl;

import com.geoway.ns.sx.biz.dzzh.entity.CamCameraPo;
import com.geoway.ns.sx.biz.dzzh.entity.CamDevicePo;
import com.geoway.ns.sx.biz.dzzh.entity.HiddenPointPo;
import com.geoway.ns.sx.biz.dzzh.entity.SensorPo;
import com.geoway.ns.sx.biz.dzzh.entity.SensorSyncPo;
import com.geoway.ns.sx.biz.dzzh.enums.CamDeviceOnlineEnum;
import com.geoway.ns.sx.biz.dzzh.enums.CamDeviceSpServiceEnum;
import com.geoway.ns.sx.biz.dzzh.enums.SersorOnlineStatusEnum;
import com.geoway.ns.sx.biz.dzzh.enums.StatusValidEnum;
import com.geoway.ns.sx.biz.dzzh.mapper.CamCameraPoMapper;
import com.geoway.ns.sx.biz.dzzh.mapper.CamDevicePoMapper;
import com.geoway.ns.sx.biz.dzzh.mapper.HiddenPointPoMapper;
import com.geoway.ns.sx.biz.dzzh.mapper.SensorPoMapper;
import com.geoway.ns.sx.biz.dzzh.mapper.SensorSyncPoMapper;
import com.geoway.ns.sx.biz.dzzh.mo.DeviceAndSenorMo;
import com.geoway.ns.sx.biz.dzzh.mo.DeviceInfoMo;
import com.geoway.ns.sx.biz.dzzh.mo.HiddenPointMo;
import com.geoway.ns.sx.biz.dzzh.mo.PageMo;
import com.geoway.ns.sx.biz.dzzh.mo.SensorInfoMo;
import com.geoway.ns.sx.biz.dzzh.mo.SensorMo;
import com.geoway.ns.sx.biz.dzzh.seo.HiddenPointSeo;
import com.geoway.ns.sx.biz.dzzh.service.SensorTaskService;
import com.geoway.ns.sx.biz.dzzh.service.WarningEventService;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SensorTaskServiceImpl
implements SensorTaskService {
    @Autowired
    private WarningEventService warningEventService;
    @Autowired
    private SensorPoMapper sensorPoMapper;
    @Autowired
    private SensorSyncPoMapper sensorSyncPoMapper;
    @Autowired
    private CamDevicePoMapper camDevicePoMapper;
    @Autowired
    private CamCameraPoMapper camCameraPoMapper;
    @Autowired
    private HiddenPointPoMapper hiddenPointPoMapper;

    @Override
    public void syncSensor() {
        long total = 100L;
        int page = 1;
        int pageSize = 25;
        HashSet<String> updateIds = new HashSet<String>();
        SensorSyncPo sensorSyncPo = new SensorSyncPo();
        sensorSyncPo.setTimeCreate(new Date());
        StringBuffer syncData = new StringBuffer();
        boolean cont = true;
        boolean complate = true;
        while (cont) {
            PageMo<SensorMo> pageList;
            List<SensorMo> list;
            if ((list = (pageList = this.warningEventService.getSensorList(++page, pageSize, true)).getRows()) == null || list.size() <= 0) {
                cont = false;
                break;
            }
            for (SensorMo mo : list) {
                DeviceAndSenorMo senorDetail = null;
                try {
                    senorDetail = this.warningEventService.getSensorDetails(mo.getSensorId());
                    syncData.append(senorDetail.getJsonData());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    complate = false;
                }
                String updateId = this.addOrUpdateSensors(mo, senorDetail);
                updateIds.add(updateId);
            }
            total = pageList.getTotal();
        }
        sensorSyncPo.setSyncInfo("total:" + total);
        sensorSyncPo.setSyncData(syncData.toString());
        sensorSyncPo.setTimeEnd(new Date());
        this.sensorSyncPoMapper.insert(sensorSyncPo);
        HashSet<String> camDeviceUpdateIds = this.addOrUpdateSensorsToCamDevice(updateIds);
        HashSet<String> cameraUpdateIds = this.addOrUpdateCamera(updateIds);
        if (!updateIds.isEmpty() && complate) {
            this.sensorPoMapper.updateStatusByIds(updateIds);
        }
        if (!camDeviceUpdateIds.isEmpty()) {
            this.camDevicePoMapper.updateSensorStatusByIds(camDeviceUpdateIds);
        }
        if (!cameraUpdateIds.isEmpty()) {
            this.camCameraPoMapper.updateCameraStatusByIds(cameraUpdateIds);
        }
    }

    @Override
    public void syncHiddenPoint() {
        HiddenPointSeo seo = new HiddenPointSeo();
        HashSet<String> updateIds = new HashSet<String>();
        List<HiddenPointMo> rows = this.warningEventService.getHiddenPointList(seo);
        rows.stream().forEach(hiddenPoint -> {
            HiddenPointPo hiddenPointPo = new HiddenPointPo();
            BeanUtils.copyProperties((Object)hiddenPoint, (Object)hiddenPointPo);
            hiddenPointPo.setCreateTime(new Date());
            hiddenPointPo.setStatus(StatusValidEnum.\u6709\u6548.value());
            String changeId = this.addOrUpdatePointInfo(hiddenPointPo);
            updateIds.add(changeId);
        });
        if (updateIds.size() > 0) {
            this.hiddenPointPoMapper.changeStatusByIds(updateIds);
        }
    }

    private String addOrUpdatePointInfo(HiddenPointPo hiddenPointPo) {
        if (this.hiddenPointPoMapper.selectById((Serializable)((Object)hiddenPointPo.getHiddenPoint())) != null) {
            this.hiddenPointPoMapper.updateById(hiddenPointPo);
        } else {
            this.hiddenPointPoMapper.insert(hiddenPointPo);
        }
        return hiddenPointPo.getHiddenPoint();
    }

    private String addOrUpdateSensors(SensorMo sersorMo, DeviceAndSenorMo mo) {
        DeviceInfoMo deviceInfoMo = mo.getDeviceInfoMo();
        SensorInfoMo sensorInfoMo = mo.getSensorInfoMo();
        String sensorId = sensorInfoMo.getSensorId();
        Integer isOnlie = sersorMo.getIsSensorOnline();
        SensorPo sensorPo = new SensorPo();
        sensorPo.setSensorId(sensorId);
        sensorPo.setLat(sensorInfoMo.getLat());
        sensorPo.setLon(sensorInfoMo.getLon());
        sensorPo.setOnlineStatus(isOnlie);
        sensorPo.setSensorType(sensorInfoMo.getSensorType());
        sensorPo.setVideoSensorCode(sensorInfoMo.getVideoSensorCode());
        sensorPo.setDeviceId(deviceInfoMo.getDeviceId());
        sensorPo.setDeviceName(deviceInfoMo.getDeviceName());
        sensorPo.setAreaCode(deviceInfoMo.getAreaCode());
        sensorPo.setDeviceManufacture(deviceInfoMo.getManufacture());
        sensorPo.setStatus(StatusValidEnum.\u6709\u6548.value());
        if (this.sensorPoMapper.selectById((Serializable)((Object)sensorId)) == null) {
            this.sensorPoMapper.insert(sensorPo);
        } else {
            this.sensorPoMapper.updateById(sensorPo);
        }
        return sensorId;
    }

    private HashSet<String> addOrUpdateSensorsToCamDevice(HashSet<String> updateIds) {
        List<SensorPo> sensorPoList = this.sensorPoMapper.getSensorListBySensorIds(updateIds);
        HashSet<String> camDeviceUpdateIds = new HashSet<String>();
        sensorPoList.stream().forEach(sensorPo -> {
            CamDevicePo devicePo = (CamDevicePo)this.camDevicePoMapper.selectById((Serializable)((Object)sensorPo.getVideoSensorCode()));
            if (null != devicePo) {
                this.mappingSensorCamDevice((SensorPo)sensorPo, devicePo);
                this.camDevicePoMapper.updateById(devicePo);
                camDeviceUpdateIds.add(devicePo.getDeviceId());
            } else {
                CamDevicePo camDevicePo = new CamDevicePo();
                this.mappingSensorCamDevice((SensorPo)sensorPo, devicePo);
                camDevicePo.setDeviceId(sensorPo.getVideoSensorCode());
                this.camDevicePoMapper.insert(camDevicePo);
                camDeviceUpdateIds.add(sensorPo.getVideoSensorCode());
            }
        });
        return camDeviceUpdateIds;
    }

    private HashSet<String> addOrUpdateCamera(HashSet<String> updateIds) {
        List<SensorPo> sensorPoList = this.sensorPoMapper.getSensorListBySensorIds(updateIds);
        HashSet<String> camCameraUpdateIds = new HashSet<String>();
        sensorPoList.stream().forEach(sensorPo -> {
            CamCameraPo camCameraPo = (CamCameraPo)this.camCameraPoMapper.selectById((Serializable)((Object)sensorPo.getVideoSensorCode()));
            if (null != camCameraPo) {
                this.mappingSensorCamCamera((SensorPo)sensorPo, camCameraPo);
                this.camCameraPoMapper.updateById(camCameraPo);
                camCameraUpdateIds.add(camCameraPo.getCameraId());
            } else {
                CamCameraPo cameraPo = new CamCameraPo();
                this.mappingSensorCamCamera((SensorPo)sensorPo, camCameraPo);
                this.camCameraPoMapper.insert(cameraPo);
                camCameraUpdateIds.add(sensorPo.getVideoSensorCode());
            }
        });
        return camCameraUpdateIds;
    }

    private void mappingSensorCamCamera(SensorPo sensorPo, CamCameraPo camCameraPo) {
        if (null == camCameraPo.getCameraId()) {
            camCameraPo.setCameraId(sensorPo.getVideoSensorCode());
        }
        camCameraPo.setCameraName(sensorPo.getDeviceName());
        camCameraPo.setSpCameraId(sensorPo.getVideoSensorCode());
        camCameraPo.setStatusValid(StatusValidEnum.\u6709\u6548.value());
        camCameraPo.setDeviceId(sensorPo.getVideoSensorCode());
    }

    private void mappingSensorCamDevice(SensorPo sensorPo, CamDevicePo camDevicePo) {
        camDevicePo.setLatitude(sensorPo.getLat().toString());
        camDevicePo.setLongitude(sensorPo.getLon().toString());
        camDevicePo.setSpDeviceId(sensorPo.getVideoSensorCode());
        Integer onlineStatus = sensorPo.getOnlineStatus();
        if (onlineStatus.equals(SersorOnlineStatusEnum.\u5728\u7ebf.value())) {
            camDevicePo.setOnline(CamDeviceOnlineEnum.\u5728\u7ebf.value());
        } else {
            camDevicePo.setOnline(CamDeviceOnlineEnum.\u79bb\u7ebf.value());
        }
        camDevicePo.setDeviceName(sensorPo.getDeviceName());
        camDevicePo.setOwnerOrg(sensorPo.getAreaCode());
        camDevicePo.setRegionCode(sensorPo.getAreaCode());
        camDevicePo.setSpDevice(sensorPo.getDeviceManufacture());
        camDevicePo.setSpService(CamDeviceSpServiceEnum.\u5730\u707e\u6444\u50cf\u5934.value());
        camDevicePo.setStatusValid(StatusValidEnum.\u6709\u6548.value());
        camDevicePo.setRemark(sensorPo.getSensorId());
    }
}

