-- 创建用户信息表
DROP table if exists tb_user_info;
CREATE TABLE tb_user_info (
	f_id varchar(64) NOT NULL, -- 用户id
	f_name varchar(255) NULL, -- 用户名
	f_org_id varchar(64) NULL, -- 部门id
	f_org_name varchar(255) NULL, -- 部门名称
	f_region_code varchar(32) NULL, -- 行政区代码（地市级）
	f_region_name varchar(255) NULL, -- 行政区名称
	CONSTRAINT tb_user_info_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE tb_user_info IS '用户基本信息（部门，行政区）';

COMMENT ON COLUMN tb_user_info.f_id IS '用户id';
COMMENT ON COLUMN tb_user_info.f_name IS '用户名';
COMMENT ON COLUMN tb_user_info.f_org_id IS '部门id';
COMMENT ON COLUMN tb_user_info.f_org_name IS '部门名称';
COMMENT ON COLUMN tb_user_info.f_region_code IS '行政区代码（地市级）';
COMMENT ON COLUMN tb_user_info.f_region_name IS '行政区名称';