/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ue.common.util;

import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.swing.DesktopUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileTool {
    private static final Logger log = LoggerFactory.getLogger(FileTool.class);

    public static boolean uploadFile(MultipartFile file, String filepath) {
        try {
            if (!FileUtil.exist((String)filepath)) {
                FileUtil.touch((String)filepath);
            }
            file.transferTo(FileUtil.file((String)filepath));
            return true;
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u6587\u4ef6{}\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u662f{}", (Object)filepath, (Object)e.toString());
            return false;
        }
    }

    public static String getMultipartFileExtName(MultipartFile file) {
        String extName = "." + FileUtil.getSuffix((String)file.getOriginalFilename());
        return extName;
    }

    public static byte[] getThumbnail(byte[] image, int width, int height) {
        BufferedImage buffer = ImgUtil.read((InputStream)new ByteArrayInputStream(image));
        Image img = ImgUtil.scale((Image)buffer, (int)width, (int)height);
        return ImgUtil.toBytes((Image)img, (String)"png");
    }

    public static boolean openDirDesktop(String path) {
        if (!FileUtil.exist((String)path)) {
            log.error("\u6587\u4ef6\u5939{}\u4e0d\u5b58\u5728", (Object)path);
            return false;
        }
        try {
            DesktopUtil.open((File)new File(path));
        }
        catch (Exception e) {
            log.error("\u6253\u5f00\u6587\u4ef6\u5939\u9519\u8bef", (Throwable)e);
            return false;
        }
        return true;
    }
}

