/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ue.common.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.geoway.ue.common.constant.ResultCode;
import com.geoway.ue.common.util.Path;
import com.geoway.ue.common.util.ZipTool;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.servlet.HandlerMapping;
import springfox.documentation.builders.ResponseBuilder;
import springfox.documentation.service.Response;

public class HttpTool {
    private static final Logger log = LoggerFactory.getLogger(HttpTool.class);
    private static final String IP_UNKNOWN = "unknown";
    private static final String IP_LOCAL = "127.0.0.1";
    private static final int IP_LEN = 15;

    public static String getHttpHeaderParam(org.springframework.http.server.reactive.ServerHttpRequest request, String key) {
        HttpHeaders httpHeaders = request.getHeaders();
        String param = httpHeaders.getFirst(key);
        if (ObjectUtil.isEmpty((Object)param)) {
            param = (String)request.getQueryParams().getFirst((Object)key);
        }
        return param;
    }

    public static String getRealIpAddress(HttpServletRequest request) {
        String ip;
        block7: {
            block6: {
                ip = request.getHeader("X-Forwarded-For");
                if (ip != null && ip.length() != 0 && !IP_UNKNOWN.equalsIgnoreCase(ip)) break block6;
                if (ip == null || ip.length() == 0 || IP_UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("Proxy-Client-IP");
                }
                if (ip == null || ip.length() == 0 || IP_UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("WL-Proxy-Client-IP");
                }
                if (ip == null || ip.length() == 0 || IP_UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_CLIENT_IP");
                }
                if (ip == null || ip.length() == 0 || IP_UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_X_FORWARDED_FOR");
                }
                if (ip != null && ip.length() != 0 && !IP_UNKNOWN.equalsIgnoreCase(ip)) break block7;
                ip = request.getRemoteAddr();
                break block7;
            }
            if (ip.length() > 15) {
                String[] ips = ip.split(",");
                for (int index = 0; index < ips.length; ++index) {
                    String strIp = ips[index];
                    if (IP_UNKNOWN.equalsIgnoreCase(strIp)) continue;
                    ip = strIp;
                    break;
                }
            }
        }
        return ip;
    }

    public static String getPathVariables(HttpServletRequest request, String key) {
        Map pathVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        return (String)pathVariables.get(key);
    }

    public static String getRealIpAddress(ServerHttpRequest request) {
        int index;
        HttpHeaders headers = request.getHeaders();
        String ipAddress = headers.getFirst("X-Original-Forwarded-For");
        if (ipAddress == null || ipAddress.isEmpty() || IP_UNKNOWN.equalsIgnoreCase(ipAddress)) {
            ipAddress = headers.getFirst("X-Forwarded-For");
        }
        if (ipAddress == null || ipAddress.isEmpty() || IP_UNKNOWN.equalsIgnoreCase(ipAddress)) {
            ipAddress = headers.getFirst("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.isEmpty() || IP_UNKNOWN.equalsIgnoreCase(ipAddress)) {
            ipAddress = headers.getFirst("WL-Proxy-Client-IP");
        }
        if ((ipAddress == null || ipAddress.isEmpty() || IP_UNKNOWN.equalsIgnoreCase(ipAddress)) && IP_LOCAL.equals(ipAddress = Optional.of(request.getRemoteAddress()).map(address -> address.getAddress().getHostAddress()).orElse(""))) {
            try {
                InetAddress inet = InetAddress.getLocalHost();
                ipAddress = inet.getHostAddress();
            }
            catch (UnknownHostException e) {
                log.error("UnknownHostException", (Throwable)e);
            }
        }
        if (ipAddress != null && ipAddress.length() > 15 && (index = ipAddress.indexOf(",")) > 0) {
            ipAddress = ipAddress.substring(0, index);
        }
        return ipAddress;
    }

    public static <T> HttpEntity<T> packHttpEntity(T data, MediaType contentType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(contentType == null ? MediaType.APPLICATION_JSON : contentType);
        return new HttpEntity(data, (MultiValueMap)headers);
    }

    public static <T> HttpEntity<MultiValueMap<String, Object>> packHttpEntity(T data) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        if (data != null) {
            Map map = BeanUtil.beanToMap(data, (boolean)false, (boolean)true);
            map.forEach((arg_0, arg_1) -> ((MultiValueMap)param).add(arg_0, arg_1));
        }
        log.error(new JSONObject((Object)param).toStringPretty());
        return new HttpEntity((Object)param, (MultiValueMap)headers);
    }

    public static boolean downloadZip(String href, String path, String key, boolean unzip) {
        try {
            String[] params;
            String name;
            long s1 = System.currentTimeMillis();
            URL url = new URL(href);
            URLConnection conn = url.openConnection();
            String content = conn.getHeaderField("Content-Disposition");
            String fileName = IdUtil.nanoId().concat(".zip");
            if (ObjectUtil.isNotEmpty((Object)content) && ObjectUtil.isNotEmpty((Object)(name = (String)Arrays.stream(params = content.split(";")).filter(param -> StrUtil.startWithIgnoreCase((CharSequence)param, (CharSequence)key)).findFirst().orElse(null)))) {
                fileName = name.replace(key, "");
            }
            FileUtil.writeFromStream((InputStream)conn.getInputStream(), (String)Path.mergePath(path, fileName));
            long s2 = System.currentTimeMillis();
            log.info("\u4e0b\u8f7d\u8017\u65f6" + (s2 - s1));
            if (unzip) {
                ZipTool.unzip(Path.mergePath(path, fileName), path);
                FileUtil.del((String)Path.mergePath(path, fileName));
                long s3 = System.currentTimeMillis();
                log.info("\u89e3\u538b\u8017\u65f6" + (s3 - s2));
            }
        }
        catch (Exception e) {
            log.error("url={}\u4e0b\u8f7dzip\u5305\u5931\u8d25", (Object)href, (Object)e);
            FileUtil.del((String)path);
            return false;
        }
        return true;
    }

    public static List<Response> globalSwaggerResponses(Integer ... codes) {
        ArrayList<Response> responses = new ArrayList<Response>();
        Arrays.stream(ResultCode.values()).forEach(res -> {
            if (!ObjectUtil.isNotNull((Object)codes) || ObjectUtil.contains((Object)codes, (Object)res.getCode())) {
                responses.add(new ResponseBuilder().code(String.valueOf(res.getCode())).description(res.getDesc()).build());
            }
        });
        return responses;
    }
}

