/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ue.common.util;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ZipUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IInArchive;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;
import net.sf.sevenzipjbinding.simple.ISimpleInArchive;
import net.sf.sevenzipjbinding.simple.ISimpleInArchiveItem;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipTool {
    private static final Logger log = LoggerFactory.getLogger(ZipTool.class);

    public static void unzip(String zip, String path) {
        if (zip.toLowerCase().endsWith(".zip")) {
            ZipUtil.unzip((String)zip, (String)path);
        } else if (zip.toLowerCase().endsWith(".rar")) {
            ZipTool.unRar(zip, path);
        } else if (zip.toLowerCase().endsWith(".7z")) {
            ZipTool.un7z(zip, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String unRar(String rarFile, String outPath) {
        RandomAccessFile randomAccessFile = null;
        IInArchive inArchive = null;
        try {
            randomAccessFile = new RandomAccessFile(rarFile, "r");
            inArchive = SevenZip.openInArchive(null, (IInStream)new RandomAccessFileInStream(randomAccessFile));
            ISimpleInArchive simpleInArchive = inArchive.getSimpleInterface();
            for (ISimpleInArchiveItem item : simpleInArchive.getArchiveItems()) {
                int[] hash = new int[]{0};
                if (item.isFolder()) continue;
                long[] sizeArray = new long[1];
                File outFile = new File(outPath + File.separator + item.getPath());
                File parent = outFile.getParentFile();
                if (!parent.exists() && !parent.mkdirs()) continue;
                ExtractOperationResult result = item.extractSlow(data -> {
                    try {
                        IoUtil.write((OutputStream)new FileOutputStream(outFile, true), (boolean)true, (byte[])data);
                    }
                    catch (Exception e) {
                        log.error("\u89e3\u538b\u5f02\u5e38", (Throwable)e);
                    }
                    hash[0] = hash[0] ^ Arrays.hashCode(data);
                    sizeArray[0] = sizeArray[0] + (long)data.length;
                    return data.length;
                });
                if (result == ExtractOperationResult.OK) {
                    log.info("\u6210\u529f\u89e3\u538b\u6587\u4ef6{}", (Object)rarFile);
                    continue;
                }
                String string = "rar error";
                return string;
            }
        }
        catch (Exception e) {
            log.error("unRar error", (Throwable)e);
            ISimpleInArchiveItem[] iSimpleInArchiveItemArray = e.getMessage();
            return iSimpleInArchiveItemArray;
        }
        finally {
            try {
                inArchive.close();
                randomAccessFile.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void un7z(String z7zFilePath, String outPath) {
        SevenZFile zIn = null;
        try {
            File file = new File(z7zFilePath);
            zIn = new SevenZFile(file);
            SevenZArchiveEntry entry = null;
            File newFile = null;
            while ((entry = zIn.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                newFile = new File(outPath, entry.getName());
                if (!newFile.exists()) {
                    new File(newFile.getParent()).mkdirs();
                }
                FileOutputStream out = new FileOutputStream(newFile);
                BufferedOutputStream bos = new BufferedOutputStream(out);
                int len = -1;
                byte[] buf = new byte[(int)entry.getSize()];
                while ((len = zIn.read(buf)) != -1) {
                    bos.write(buf, 0, len);
                }
                bos.flush();
                bos.close();
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (zIn != null) {
                    zIn.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

