/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ue.signal.handler;

import com.geoway.ue.common.constant.ResultCode;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class RestErrorHandler
extends DefaultResponseErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(RestErrorHandler.class);

    public boolean hasError(ClientHttpResponse response) throws IOException {
        int rawStatusCode = response.getRawStatusCode();
        HttpStatus statusCode = HttpStatus.resolve((int)rawStatusCode);
        return statusCode != null ? super.hasError(statusCode) : this.hasError(rawStatusCode);
    }

    protected boolean hasError(int unknownStatusCode) {
        ResultCode resultCode = ResultCode.byCode((int)unknownStatusCode);
        return resultCode != null;
    }
}

