/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ue.signal.handler;

import com.geoway.ue.signal.annotation.UeLog;
import com.geoway.ue.signal.service.LogRecordService;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Order(value=1)
@Component
public class UeLogAspectHandler {
    private static final Logger log = LoggerFactory.getLogger(UeLogAspectHandler.class);
    @Autowired(required=false)
    private HttpServletRequest request;
    @Autowired(required=false)
    private LogRecordService logService;

    @PostConstruct
    public void init() {
        log.info("Initializing Bean UeLogAspectHandler");
    }

    @Pointcut(value="@annotation(com.geoway.ue.signal.annotation.UeLog)")
    public void ueLogAspect() {
    }

    @AfterReturning(pointcut="ueLogAspect()", returning="result")
    public void afterUeLogAspect(JoinPoint point, Object result) {
        this.saveUeLog(point, result, null);
    }

    @AfterThrowing(pointcut="ueLogAspect()", throwing="e")
    public void afterUeLogThrowing(JoinPoint point, Exception e) {
        this.saveUeLog(point, null, e);
    }

    private void saveUeLog(JoinPoint point, Object result, Exception throwable) {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        Object[] args = point.getArgs();
        UeLog type = method.getAnnotation(UeLog.class);
        if (this.logService != null) {
            this.logService.saveUeLog(type, args, result, throwable, this.request);
        }
    }
}

