/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ue.signal.handler;

import cn.hutool.core.util.StrUtil;
import com.geoway.ue.signal.handler.UeManageHandler;
import com.geoway.ue.signal.service.UeDeployService;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.AbstractWebSocketHandler;

@Component
public class UeSignalWsHandler
extends AbstractWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(UeSignalWsHandler.class);
    @Resource
    private UeManageHandler manageService;
    @Autowired(required=false)
    private UeDeployService deployService;

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        Map attrs = session.getAttributes();
        this.manageService.sceneConnected(attrs.get("serviceId"), session);
        if (this.deployService != null) {
            this.deployService.startSceneCallback(attrs.get("serviceId"), this.manageService.getWsRemoteAddress(session));
        }
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        Map attrs = session.getAttributes();
        this.manageService.sceneDisconnect(attrs.get("serviceId"), session);
        if (this.deployService != null) {
            this.deployService.stopSceneCallback(attrs.get("serviceId"), this.manageService.getWsRemoteAddress(session));
        }
    }

    public void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        String payload = (String)message.getPayload();
        Map attrs = session.getAttributes();
        log.info("\u670d\u52a1\u5668\u6536\u5230\u6765\u81ea\u3010{}\u3011\u4e0a\u7684\u573a\u666f{}\u7684\u6d88\u606f\uff1a{}", new Object[]{session.getRemoteAddress(), attrs.get("serviceId"), StrUtil.sub((CharSequence)payload, (int)0, (int)100)});
        this.manageService.receiveSignalMessage(attrs.get("serviceId"), payload);
    }
}

