/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ue.signal.handler;

import cn.hutool.core.util.StrUtil;
import com.geoway.ue.signal.handler.UeManageHandler;
import com.geoway.ue.signal.service.UeDeployService;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.AbstractWebSocketHandler;

@Component
public class UeWebWsHandler
extends AbstractWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(UeWebWsHandler.class);
    @Resource
    private UeManageHandler manageService;
    @Autowired(required=false)
    private UeDeployService deployService;

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        Map attrs = session.getAttributes();
        this.manageService.connectScene(attrs.get("serviceId"), session);
        if (this.deployService != null) {
            String address = this.manageService.getWsRemoteAddress(session);
            this.deployService.openUeScene(address, attrs.get("serviceId"));
        }
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        Map attrs = session.getAttributes();
        this.manageService.disconnectScene(attrs.get("serviceId"), session);
    }

    public void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        String payload = (String)message.getPayload();
        Map attrs = session.getAttributes();
        Long playerId = this.manageService.getPlayerBySession(session.getId());
        log.info("\u6536\u5230\u6765\u81ea\u6d4f\u89c8\u5668\u3010{}\u3011\u8bbf\u95ee\u573a\u666f{}\u7684\u6d88\u606f\uff1a{}", new Object[]{session.getRemoteAddress(), attrs.get("serviceId"), StrUtil.sub((CharSequence)payload, (int)0, (int)100)});
        this.manageService.receiveWebMessage(attrs.get("serviceId"), playerId, payload);
    }
}

