/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ue.signal.service;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.ue.common.constant.ResultCode;
import com.geoway.ue.common.data.UeScene;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.util.HttpTool;
import com.geoway.ue.signal.dto.property.UeSignalProperties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class AgentRestService {
    @Resource
    private RestTemplate signalRest;
    @Resource
    private UeSignalProperties signalConfig;
    private String stopUeSceneUrl;
    private String startUeSceneUrl;
    private String removeUeSceneUrl;
    private String createUeSceneUrl;
    private String restartAgentUrl;
    private final String URL_FMT = "http://%s:%s/%s";

    @PostConstruct
    public void initUri() {
        this.createUeSceneUrl = this.signalConfig.getAgentServerUrl();
        this.removeUeSceneUrl = this.signalConfig.getAgentServerUrl();
        this.stopUeSceneUrl = this.signalConfig.getAgentServerUrl().concat("/stop");
        this.startUeSceneUrl = this.signalConfig.getAgentServerUrl().concat("/start");
        this.restartAgentUrl = this.signalConfig.getAgentServerUrl().concat("/app");
    }

    public ResultCode createUeScene(String address, UeScene scene) {
        String url = String.format("http://%s:%s/%s", address, this.signalConfig.getAgentServerPort(), this.createUeSceneUrl);
        ResponseEntity res = this.signalRest.postForEntity(url, (Object)HttpTool.packHttpEntity((Object)scene), BaseResponse.class, new Object[]{scene.getServiceId()});
        if (ObjectUtil.notEqual((Object)HttpStatus.OK, (Object)res.getStatusCode())) {
            return ResultCode.byCode((int)res.getStatusCodeValue());
        }
        return null;
    }

    public ResultCode removeUeScene(String address, String serviceId) {
        String url = String.format("http://%s:%s/%s", address, this.signalConfig.getAgentServerPort(), this.removeUeSceneUrl);
        this.signalRest.delete(url, new Object[]{serviceId});
        return null;
    }

    public ResultCode startUeScene(String address, String serviceId) {
        String url = String.format("http://%s:%s/%s", address, this.signalConfig.getAgentServerPort(), this.startUeSceneUrl);
        ResponseEntity res = this.signalRest.postForEntity(url, null, BaseResponse.class, new Object[]{serviceId});
        if (ObjectUtil.notEqual((Object)HttpStatus.OK, (Object)res.getStatusCode())) {
            return ResultCode.byCode((int)res.getStatusCodeValue());
        }
        return null;
    }

    public ResultCode stopUeScene(String address, String serviceId) {
        String url = String.format("http://%s:%s/%s", address, this.signalConfig.getAgentServerPort(), this.stopUeSceneUrl);
        ResponseEntity res = this.signalRest.postForEntity(url, (Object)HttpTool.packHttpEntity(null, null), BaseResponse.class, new Object[]{serviceId});
        if (ObjectUtil.notEqual((Object)HttpStatus.OK, (Object)res.getStatusCode())) {
            return ResultCode.byCode((int)res.getStatusCodeValue());
        }
        return null;
    }

    public ResultCode restartAgentApp(String address) {
        String url = String.format("http://%s:%s/%s", address, this.signalConfig.getAgentServerPort(), this.restartAgentUrl);
        ResponseEntity res = this.signalRest.postForEntity(url, null, BaseResponse.class, new Object[]{"restart"});
        return null;
    }
}

