/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ue.signal.service;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.ue.common.constant.ResultCode;
import com.geoway.ue.common.data.UeScene;
import com.geoway.ue.signal.annotation.UeLog;
import com.geoway.ue.signal.enums.UeLogType;
import com.geoway.ue.signal.handler.UeManageHandler;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UeDeployService {
    private static final Logger log = LoggerFactory.getLogger(UeDeployService.class);
    @Resource
    private UeManageHandler ueManage;

    public abstract void startSceneCallback(Object var1, String var2);

    public abstract void stopSceneCallback(Object var1, String var2);

    public ResultCode createUeScene(String address, UeScene scene) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{address, scene, scene.getServiceId()})) {
            return this.ueManage.createUeScene(address, scene.getServiceId(), scene);
        }
        return ResultCode.C10001;
    }

    public ResultCode startUeScene(String address, String serviceId) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{address, serviceId})) {
            return this.ueManage.startUeScene(address, serviceId);
        }
        return ResultCode.C10001;
    }

    public ResultCode stopUeScene(String address, String serviceId) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{address, serviceId})) {
            return this.ueManage.stopUeScene(address, serviceId);
        }
        return ResultCode.C10001;
    }

    public ResultCode removeUeScene(String address, String serviceId) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{address, serviceId})) {
            return this.ueManage.removeUeScene(address, serviceId);
        }
        return ResultCode.C10001;
    }

    @UeLog(eventType=UeLogType.browse)
    public ResultCode openUeScene(String address, Object serviceId) {
        log.debug("{}\u6d4f\u89c8\u8bbf\u95ee\u573a\u666f\u670d\u52a1serviceId={}", (Object)address, serviceId);
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{address, serviceId})) {
            return null;
        }
        return ResultCode.C500;
    }
}

