/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ue.signal.config;

import com.geoway.ue.signal.handler.UeAgentWsHandler;
import com.geoway.ue.signal.handler.UeSignalWsHandler;
import com.geoway.ue.signal.handler.UeWebWsHandler;
import com.geoway.ue.signal.handler.WsHandShakeHandler;
import javax.annotation.Resource;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Configuration
@EnableWebSocket
public class WebSocketConfig
implements WebSocketConfigurer {
    public static final String WEB = "web";
    public static final String AGENT = "agent";
    public static final String SIGNAL = "signal";
    @Resource
    private UeWebWsHandler ueWebWs;
    @Resource
    private UeAgentWsHandler ueAgentWs;
    @Resource
    private UeSignalWsHandler ueSignalWs;

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        registry.addHandler((WebSocketHandler)this.ueSignalWs, new String[]{"/signal/{serviceId}"}).addInterceptors(new HandshakeInterceptor[]{new WsHandShakeHandler(SIGNAL)}).setAllowedOriginPatterns(new String[]{"*"});
        registry.addHandler((WebSocketHandler)this.ueWebWs, new String[]{"/web/{serviceId}"}).addInterceptors(new HandshakeInterceptor[]{new WsHandShakeHandler(WEB)}).setAllowedOriginPatterns(new String[]{"*"});
        registry.addHandler((WebSocketHandler)this.ueAgentWs, new String[]{"/agent"}).addInterceptors(new HandshakeInterceptor[]{new WsHandShakeHandler(AGENT)}).setAllowedOriginPatterns(new String[]{"*"});
    }
}

