/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ue.signal.controller;

import com.geoway.ue.common.constant.ResultCode;
import com.geoway.ue.common.data.UeScene;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.signal.handler.UeManageHandler;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"UE\u4fe1\u4ee4\u670d\u52a1\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/signal/v1"})
public class UeSignalController {
    private static final Logger log = LoggerFactory.getLogger(UeSignalController.class);
    @Resource
    private UeManageHandler ueManage;

    @ApiOperation(value="\u521b\u5efaUE\u573a\u666f\u670d\u52a1")
    @ApiOperationSupport(order=1001)
    @ApiImplicitParams(value={@ApiImplicitParam(name="serviceId", value="\u670d\u52a1\u6807\u8bc6", paramType="path", dataType="String", required=true), @ApiImplicitParam(name="sceneId", required=true), @ApiImplicitParam(name="address", required=true), @ApiImplicitParam(name="name", required=true), @ApiImplicitParam(name="version", required=true)})
    @PostMapping(value={"/create/{serviceId}"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<BaseResponse> createUeSceneService(@PathVariable(value="serviceId") String serviceId, UeScene data) {
        log.debug("\u521b\u5efaUE\u573a\u666f\u670d\u52a1");
        ResultCode res = this.ueManage.createUeScene(data.getAddress(), serviceId, data);
        return res == null ? BaseResponse.ok() : BaseResponse.error((ResultCode)res);
    }

    @ApiOperation(value="\u79fb\u9664UE\u573a\u666f\u670d\u52a1")
    @ApiOperationSupport(order=1002)
    @ApiImplicitParams(value={@ApiImplicitParam(name="serviceId", value="\u670d\u52a1\u6807\u8bc6", paramType="path", dataType="String", required=true), @ApiImplicitParam(name="address", value="\u8282\u70b9IP\u5730\u5740", paramType="path", dataType="String", required=true)})
    @DeleteMapping(value={"/remove/{serviceId}"})
    public ResponseEntity<BaseResponse> removeUeSceneService(@PathVariable(value="serviceId") String serviceId, @RequestParam String address) {
        log.debug("\u79fb\u9664UE\u573a\u666f\u670d\u52a1");
        ResultCode res = this.ueManage.removeUeScene(address, serviceId);
        return res == null ? BaseResponse.ok() : BaseResponse.error((ResultCode)res);
    }

    @ApiOperation(value="\u542f\u52a8UE\u573a\u666f\u670d\u52a1")
    @ApiOperationSupport(order=1003)
    @ApiImplicitParams(value={@ApiImplicitParam(name="serviceId", value="\u670d\u52a1\u6807\u8bc6", paramType="path", dataType="String", required=true), @ApiImplicitParam(name="address", value="\u8282\u70b9IP\u5730\u5740", paramType="path", dataType="String", required=true)})
    @PostMapping(value={"/start/{serviceId}"})
    public ResponseEntity<BaseResponse> startUeSceneService(@PathVariable(value="serviceId") String serviceId, @RequestParam String address) {
        log.debug("\u542f\u52a8UE\u573a\u666f\u670d\u52a1");
        ResultCode res = this.ueManage.startUeScene(address, serviceId);
        return res == null ? BaseResponse.ok() : BaseResponse.error((ResultCode)res);
    }

    @ApiOperation(value="\u505c\u6b62UE\u573a\u666f\u670d\u52a1")
    @ApiOperationSupport(order=1004)
    @ApiImplicitParams(value={@ApiImplicitParam(name="serviceId", value="\u670d\u52a1\u6807\u8bc6", paramType="path", dataType="String", required=true), @ApiImplicitParam(name="address", value="\u8282\u70b9IP\u5730\u5740", paramType="path", dataType="String", required=true)})
    @PostMapping(value={"/stop/{serviceId}"})
    public ResponseEntity<BaseResponse> stopUeSceneService(@PathVariable(value="serviceId") String serviceId, @RequestParam String address) {
        log.debug("\u505c\u6b62UE\u573a\u666f\u670d\u52a1");
        ResultCode res = this.ueManage.stopUeScene(address, serviceId);
        return res == null ? BaseResponse.ok() : BaseResponse.error((ResultCode)res);
    }

    @ApiOperation(value="\u91cd\u542fAgent\u5e94\u7528")
    @ApiOperationSupport(order=1005)
    @ApiImplicitParam(name="address", value="\u8282\u70b9IP\u5730\u5740", paramType="path", dataType="String", required=true)
    @PostMapping(value={"/restart/agent"})
    public ResponseEntity<BaseResponse> restartAgentApp(@RequestParam String address) {
        log.debug("\u505c\u6b62UE\u573a\u666f\u670d\u52a1");
        ResultCode res = this.ueManage.restartAgentApp(address);
        return res == null ? BaseResponse.ok() : BaseResponse.error((ResultCode)res);
    }
}

