/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ue.signal.handler;

import com.geoway.ue.signal.handler.UeManageHandler;
import com.geoway.ue.signal.service.UeAgentService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.AbstractWebSocketHandler;

@Component
public class UeAgentWsHandler
extends AbstractWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(UeAgentWsHandler.class);
    @Autowired(required=false)
    private UeAgentService agentService;
    @Resource
    private UeManageHandler manageService;

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        String address = this.manageService.getWsRemoteAddress(session);
        log.info("agent\u3010{}\u3011\u8fde\u63a5\u6210\u529f,sessionId={}", (Object)address, (Object)session.getId());
        this.manageService.nodeConnected(session);
        if (this.agentService != null) {
            this.agentService.nodeConnected(address);
        }
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        String address = this.manageService.getWsRemoteAddress(session);
        log.info("agent\u3010{}\u3011\u9000\u51fa\u8fde\u63a5,sessionId={}", (Object)address, (Object)session.getId());
        this.manageService.nodeDisconnected(session);
        if (this.agentService != null) {
            this.agentService.nodeDisconnected(address);
        }
    }

    public void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        String payload = (String)message.getPayload();
        String address = this.manageService.getWsRemoteAddress(session);
        log.info("\u670d\u52a1\u5668\u6536\u5230\u6765\u81eaagent\u3010{}\u3011\u7684\u6d88\u606f\uff1a{}", (Object)address, (Object)payload);
        this.manageService.receiveAgentMessage(address, payload);
    }
}

