/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ue.signal.handler;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.ue.common.constant.ResultCode;
import com.geoway.ue.common.data.UeScene;
import com.geoway.ue.common.data.msg.BaseMessage;
import com.geoway.ue.common.data.msg.CommonMsg;
import com.geoway.ue.common.util.Path;
import com.geoway.ue.signal.dto.msg.signal.Config;
import com.geoway.ue.signal.dto.msg.signal.PlayCount;
import com.geoway.ue.signal.dto.msg.signal.PlayerConnected;
import com.geoway.ue.signal.dto.msg.signal.PlayerDisconnected;
import com.geoway.ue.signal.dto.property.UeSignalProperties;
import com.geoway.ue.signal.enums.AgentMsg;
import com.geoway.ue.signal.enums.ApiProtocol;
import com.geoway.ue.signal.enums.UeMsg;
import com.geoway.ue.signal.enums.WebMsg;
import com.geoway.ue.signal.handler.message.AbstractMessageHandler;
import com.geoway.ue.signal.service.AgentRestService;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

@Component
public class UeManageHandler {
    private static final Logger log = LoggerFactory.getLogger(UeManageHandler.class);
    @Resource
    private AgentRestService agentRest;
    @Resource
    private UeSignalProperties signalConfig;
    private final Map<String, WebSocketSession> SIGNAL_SESSION = new ConcurrentHashMap<String, WebSocketSession>();
    private final Map<String, WebSocketSession> WEB_SESSION = new ConcurrentHashMap<String, WebSocketSession>();
    private final Map<String, WebSocketSession> AGENT_SESSION = new ConcurrentHashMap<String, WebSocketSession>();
    private final Map<String, String> AGENT_IP = new ConcurrentHashMap<String, String>();
    private final Map<String, Long> WEB_PLAYER = new ConcurrentHashMap<String, Long>();
    private final Map<Object, String> SCENE_SIGNAL = new ConcurrentHashMap<Object, String>();
    private final Map<Object, CopyOnWriteArrayList<String>> SCENE_WEB = new ConcurrentHashMap<Object, CopyOnWriteArrayList<String>>();
    private final AtomicLong play = new AtomicLong(0L);

    @PostConstruct
    public void init() {
        log.info("Initializing Bean UeManageHandler");
    }

    public void sceneConnected(Object serviceId, WebSocketSession session) {
        String sessionId = session.getId();
        this.SIGNAL_SESSION.put(sessionId, session);
        this.SCENE_SIGNAL.put(serviceId, sessionId);
        this.sendSignalMessage(serviceId, sessionId, new Config());
        String agentIp = this.getWsRemoteAddress(session);
        CommonMsg status = new CommonMsg();
        status.setType(AgentMsg.STATUS.type);
        status.setMessage((Object)new UeScene((String)serviceId, Integer.valueOf(1)));
        this.sendAgentMessageByIp(agentIp, JSONUtil.toJsonStr((Object)status));
    }

    public void connectScene(Object serviceId, WebSocketSession session) {
        String signal = this.SCENE_SIGNAL.get(serviceId);
        if (ObjectUtil.isEmpty((Object)signal)) {
            log.error("\u672a\u627e\u5230\u573a\u666f{}\u5bf9\u5e94\u7684\u6e32\u67d3\u8282\u70b9", serviceId);
            return;
        }
        Long playerId = this.play.incrementAndGet();
        String sessionId = session.getId();
        this.WEB_SESSION.put(sessionId, session);
        this.WEB_PLAYER.put(sessionId, playerId);
        CopyOnWriteArrayList<String> list = this.SCENE_WEB.get(serviceId);
        if (ObjectUtil.isEmpty(list)) {
            list = new CopyOnWriteArrayList();
        }
        list.add(sessionId);
        this.SCENE_WEB.put(serviceId, list);
        this.sendWebMessage(serviceId, sessionId, new Config());
        this.sendWebMessage(serviceId, sessionId, new PlayCount(list.size() - 1));
        this.sendSignalMessage(serviceId, signal, new PlayerConnected(playerId.toString(), true, false));
    }

    public void nodeConnected(WebSocketSession session) {
        String address = this.getWsRemoteAddress(session);
        String exist = this.AGENT_IP.get(address);
        if (ObjectUtil.isEmpty((Object)exist)) {
            this.AGENT_SESSION.put(session.getId(), session);
            this.AGENT_IP.put(address, session.getId());
        } else {
            try {
                session.close(CloseStatus.NOT_ACCEPTABLE);
            }
            catch (Exception e) {
                log.error("\u5173\u95edagent={}\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\u662f\uff1a{}", (Object)address, (Object)e.getMessage());
            }
        }
    }

    public void sceneDisconnect(Object serviceId, WebSocketSession session) {
        String sessionId = session.getId();
        this.SIGNAL_SESSION.remove(sessionId);
        CopyOnWriteArrayList<String> list = this.SCENE_WEB.get(serviceId);
        if (ObjectUtil.isNotEmpty(list)) {
            list.forEach(webWs -> this.removeWebSession(serviceId, (String)webWs));
        }
        String agentIp = this.getWsRemoteAddress(session);
        CommonMsg status = new CommonMsg();
        status.setType(AgentMsg.STATUS.type);
        status.setMessage((Object)new UeScene((String)serviceId, Integer.valueOf(0)));
        this.sendAgentMessageByIp(agentIp, JSONUtil.toJsonStr((Object)status));
    }

    public void disconnectScene(Object serviceId, WebSocketSession session) {
        String signal = this.SCENE_SIGNAL.get(serviceId);
        if (ObjectUtil.isEmpty((Object)signal)) {
            log.error("\u672a\u627e\u5230\u573a\u666f{}\u5bf9\u5e94\u7684\u6e32\u67d3\u8282\u70b9", serviceId);
            return;
        }
        String sessionId = session.getId();
        Long playerId = this.WEB_PLAYER.get(sessionId);
        CopyOnWriteArrayList<String> list = this.SCENE_WEB.get(serviceId);
        if (ObjectUtil.isNotEmpty(list)) {
            list.remove(sessionId);
        }
        this.WEB_SESSION.remove(sessionId);
        this.WEB_PLAYER.remove(sessionId);
        if (playerId != null) {
            this.sendSignalMessage(serviceId, signal, new PlayerDisconnected(playerId.toString()));
        }
    }

    public void nodeDisconnected(WebSocketSession session) {
        String address = this.getWsRemoteAddress(session);
        String exist = this.AGENT_IP.get(address);
        if (ObjectUtil.isNotEmpty((Object)exist)) {
            this.AGENT_IP.remove(address);
            this.AGENT_SESSION.remove(session.getId());
        }
    }

    public void closePlayScene(String playerId) {
        String sessionId = null;
        for (Map.Entry<String, Long> entry : this.WEB_PLAYER.entrySet()) {
            if (!ObjectUtil.equal((Object)playerId, (Object)entry.getValue().toString())) continue;
            sessionId = entry.getKey();
        }
        if (ObjectUtil.isNotEmpty(sessionId)) {
            WebSocketSession session = this.WEB_SESSION.get(sessionId);
            try {
                session.close(CloseStatus.SERVER_ERROR);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void sendSignalMessage(Object serviceId, String sessionId, String message) {
        WebSocketSession ws = this.SIGNAL_SESSION.get(sessionId);
        try {
            if (ObjectUtil.isEmpty((Object)ws)) {
                log.error("\u672a\u627e\u5230\u5bf9\u5e94\u573a\u666f{}\u50cf\u7d20\u63a8\u6d41\u8fde\u63a5", serviceId);
            } else if (!ws.isOpen()) {
                log.error("\u3010{}\u3011\u5bf9\u5e94\u573a\u666f{}\u50cf\u7d20\u63a8\u6d41\u8fde\u63a5\u5df2\u5173\u95ed", (Object)ws.getRemoteAddress(), serviceId);
            } else {
                log.info("\u53d1\u9001\u81f3\u3010{}\u3011\u4e0a\u7684\u573a\u666f{}\u7684\u6d88\u606f\uff1a{}", new Object[]{ws.getRemoteAddress(), serviceId, message});
                ws.sendMessage((WebSocketMessage)new TextMessage((CharSequence)message));
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u81f3\u3010{}\u3011\u4e0a\u7684\u573a\u666f{}\u5931\u8d25", new Object[]{ws.getRemoteAddress(), serviceId, e});
        }
    }

    public void sendSignalMessage(Object serviceId, String sessionId, BaseMessage message) {
        this.sendSignalMessage(serviceId, sessionId, message.toJSONStr());
    }

    public void sendWebMessage(Object serviceId, String sessionId, String message) {
        WebSocketSession ws = this.WEB_SESSION.get(sessionId);
        try {
            if (ObjectUtil.isEmpty((Object)ws)) {
                log.error("\u672a\u627e\u5230\u573a\u666f{}\u5bf9\u5e94\u7684\u6d4f\u89c8\u5668\u8bbf\u95ee", serviceId);
            } else if (!ws.isOpen()) {
                log.error("\u573a\u666f{}\u5bf9\u5e94\u3010{}\u3011\u6d4f\u89c8\u5668\u8fde\u63a5\u5df2\u5173\u95ed", serviceId, (Object)ws.getRemoteAddress());
            } else {
                log.info("\u53d1\u9001\u573a\u666f{}\u81f3\u6d4f\u89c8\u5668\u3010{}\u3011\u7684\u6d88\u606f\uff1a{}", new Object[]{serviceId, ws.getRemoteAddress(), message});
                ws.sendMessage((WebSocketMessage)new TextMessage((CharSequence)message));
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u573a\u666f{}\u6d88\u606f\u81f3\u6d4f\u89c8\u5668\u3010{}\u3011\u4e0a\u5931\u8d25", new Object[]{serviceId, ws.getRemoteAddress(), e});
        }
    }

    public void sendWebMessage(Object serviceId, String sessionId, BaseMessage message) {
        this.sendWebMessage(serviceId, sessionId, message.toJSONStr());
    }

    public void sendSignalMessageByScene(Object serviceId, String message) {
        String sessionId = this.SCENE_SIGNAL.get(serviceId);
        if (ObjectUtil.isNotEmpty((Object)sessionId)) {
            this.sendSignalMessage(serviceId, sessionId, message);
        } else {
            log.error("\u672a\u627e\u5230{}\u573a\u666f\u5bf9\u5e94\u7684\u50cf\u7d20\u63a8\u6d41\u670d\u52a1\u5668", serviceId);
        }
    }

    public void sendWebMessageByScene(Object serviceId, String message) {
        CopyOnWriteArrayList<String> list = this.SCENE_WEB.get(serviceId);
        if (ObjectUtil.isNotEmpty(list)) {
            list.forEach(webWs -> this.sendWebMessage(serviceId, (String)webWs, message));
        } else {
            log.error("\u672a\u627e\u5230{}\u573a\u666f\u5bf9\u5e94\u7684\u50cf\u7d20\u63a8\u6d41\u670d\u52a1\u5668", serviceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendAgentMessageByIp(Object address, String message) {
        WebSocketSession ws;
        String sessionId = this.AGENT_IP.get((String)address);
        if (ObjectUtil.isNotEmpty((Object)sessionId) && ObjectUtil.isNotNull((Object)(ws = this.AGENT_SESSION.get(sessionId)))) {
            WebSocketSession webSocketSession = ws;
            synchronized (webSocketSession) {
                if (ws.isOpen()) {
                    try {
                        ws.sendMessage((WebSocketMessage)new TextMessage((CharSequence)message));
                        return true;
                    }
                    catch (IOException e) {
                        log.error("\u53d1\u9001\u6d88\u606f{}\u81f3agent\u3010{}\u3011\u5931\u8d25", new Object[]{message, address, e});
                    }
                }
            }
            return false;
        }
        log.error("\u672a\u627e\u5230\u3010{}\u3011\u5bf9\u5e94\u7684\u8fde\u63a5\u4fe1\u606f", address);
        return false;
    }

    public void receiveSignalMessage(Object serviceId, String message) {
        BaseMessage msg = (BaseMessage)JSONUtil.toBean((String)message, BaseMessage.class);
        AbstractMessageHandler handler = UeMsg.byType((String)msg.getType()).handler;
        handler.doHandle(serviceId, message);
    }

    public void receiveWebMessage(Object serviceId, Long playerId, String message) {
        BaseMessage msg = (BaseMessage)JSONUtil.toBean((String)message, BaseMessage.class);
        JSONObject json = JSONUtil.parseObj((String)message);
        json.putOnce("playerId", (Object)playerId);
        AbstractMessageHandler handler = WebMsg.byType((String)msg.getType()).handler;
        handler.doHandle(serviceId, json.toString());
    }

    public void receiveAgentMessage(String address, String message) {
        BaseMessage msg = (BaseMessage)JSONUtil.toBean((String)message, BaseMessage.class);
        AbstractMessageHandler handler = AgentMsg.byType((String)msg.getType()).handler;
        handler.doHandle(address, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWebSession(Object serviceId, String sessionId) {
        try {
            WebSocketSession ws = this.WEB_SESSION.get(sessionId);
            if (ObjectUtil.isNotNull((Object)ws) && ws.isOpen()) {
                log.info("\u79fb\u9664\u573a\u666f{}\u7684\u8fde\u63a5\u5ba2\u6237\u7aef\u3010{}\u3011", serviceId, (Object)ws.getRemoteAddress());
                ws.close(CloseStatus.SERVER_ERROR);
            }
        }
        catch (Exception e) {
            log.error("\u79fb\u9664\u6d4f\u89c8\u5668ws\u8fde\u63a5\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.SCENE_WEB.get(serviceId).remove(sessionId);
            this.WEB_SESSION.remove(sessionId);
            this.WEB_PLAYER.remove(sessionId);
        }
    }

    public Long getPlayerBySession(String sessionId) {
        return this.WEB_PLAYER.get(sessionId);
    }

    public String getServerUrlByIp(Object address) {
        String sessionId = this.AGENT_IP.get((String)address);
        if (ObjectUtil.isNotEmpty((Object)sessionId)) {
            WebSocketSession ws = this.AGENT_SESSION.get(sessionId);
            if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{ws, ws.getUri()})) {
                String prefix = "http://";
                if (ObjectUtil.equal((Object)"wss", (Object)ws.getUri().getScheme())) {
                    prefix = "https://";
                }
                return prefix.concat(ws.getUri().getAuthority());
            }
        } else {
            String prefix = ObjectUtil.equal((Object)((Object)this.signalConfig.getApiProtocol()), (Object)((Object)ApiProtocol.http)) ? ApiProtocol.http.name() : ApiProtocol.https.name();
            return prefix.concat("://").concat((String)address);
        }
        return null;
    }

    public String getWsRemoteAddress(WebSocketSession session) {
        return session.getRemoteAddress().getAddress().getHostAddress();
    }

    public ResultCode createUeScene(String address, String serviceId, UeScene scene) {
        if (!ObjectUtil.isAllNotEmpty((Object[])new Object[]{address, scene, serviceId})) {
            return ResultCode.C10001;
        }
        scene.setServiceId(serviceId);
        String server = this.getServerUrlByIp(address);
        if (server == null) {
            log.error("\u670d\u52a1\u7aef\u4fe1\u606f\u672a\u77e5\uff0c\u65e0\u6cd5\u62fc\u63a5ue\u573a\u666f\u4e0b\u8f7d\u5730\u5740");
            return ResultCode.C10014;
        }
        scene.setHref(Path.mergePath((String[])new String[]{server, this.signalConfig.getUeDownloadUrl(), scene.getSceneId(), scene.getVersion()}));
        if (!ObjectUtil.contains(Arrays.asList(ApiProtocol.ws, ApiProtocol.wss), (Object)((Object)this.signalConfig.getApiProtocol()))) {
            return this.agentRest.createUeScene(address, scene);
        }
        CommonMsg create = new CommonMsg();
        create.setType(AgentMsg.CREATE.type);
        create.setMessage((Object)scene);
        this.sendAgentMessageByIp(address, JSONUtil.toJsonStr((Object)create));
        return null;
    }

    public ResultCode removeUeScene(String address, String serviceId) {
        if (!ObjectUtil.isAllNotEmpty((Object[])new Object[]{address, serviceId})) {
            return ResultCode.C10001;
        }
        String server = this.getServerUrlByIp(address);
        if (server == null) {
            log.error("\u670d\u52a1\u7aef\u4fe1\u606f\u672a\u77e5\uff0c\u65e0\u6cd5\u62fc\u63a5ue\u573a\u666f\u4e0b\u8f7d\u5730\u5740");
            return ResultCode.C10014;
        }
        if (!ObjectUtil.contains(Arrays.asList(ApiProtocol.ws, ApiProtocol.wss), (Object)((Object)this.signalConfig.getApiProtocol()))) {
            return this.agentRest.removeUeScene(address, serviceId);
        }
        CommonMsg remove = new CommonMsg();
        remove.setType(AgentMsg.REMOVE.type);
        remove.setMessage((Object)new UeScene(serviceId));
        this.sendAgentMessageByIp(address, JSONUtil.toJsonStr((Object)remove));
        return null;
    }

    public ResultCode startUeScene(String address, String serviceId) {
        if (!ObjectUtil.isAllNotEmpty((Object[])new Object[]{address, serviceId})) {
            return ResultCode.C10001;
        }
        String server = this.getServerUrlByIp(address);
        if (server == null) {
            log.error("\u670d\u52a1\u7aef\u4fe1\u606f\u672a\u77e5\uff0c\u65e0\u6cd5\u62fc\u63a5ue\u573a\u666f\u4e0b\u8f7d\u5730\u5740");
            return ResultCode.C10014;
        }
        if (!ObjectUtil.contains(Arrays.asList(ApiProtocol.ws, ApiProtocol.wss), (Object)((Object)this.signalConfig.getApiProtocol()))) {
            return this.agentRest.startUeScene(address, serviceId);
        }
        CommonMsg start = new CommonMsg();
        start.setType(AgentMsg.START.type);
        start.setMessage((Object)new UeScene(serviceId));
        this.sendAgentMessageByIp(address, JSONUtil.toJsonStr((Object)start));
        return null;
    }

    public ResultCode stopUeScene(String address, String serviceId) {
        if (!ObjectUtil.isAllNotEmpty((Object[])new Object[]{address, serviceId})) {
            return ResultCode.C10001;
        }
        String server = this.getServerUrlByIp(address);
        if (server == null) {
            log.error("\u670d\u52a1\u7aef\u4fe1\u606f\u672a\u77e5\uff0c\u65e0\u6cd5\u62fc\u63a5ue\u573a\u666f\u7ba1\u7406\u5730\u5740");
            return ResultCode.C10014;
        }
        if (!ObjectUtil.contains(Arrays.asList(ApiProtocol.ws, ApiProtocol.wss), (Object)((Object)this.signalConfig.getApiProtocol()))) {
            return this.agentRest.stopUeScene(address, serviceId);
        }
        CommonMsg stop = new CommonMsg();
        stop.setType(AgentMsg.STOP.type);
        stop.setMessage((Object)new UeScene(serviceId));
        this.sendAgentMessageByIp(address, JSONUtil.toJsonStr((Object)stop));
        return null;
    }

    public ResultCode restartAgentApp(String address) {
        if (ObjectUtil.isEmpty((Object)address)) {
            return ResultCode.C10001;
        }
        String server = this.getServerUrlByIp(address);
        if (server == null) {
            log.error("\u670d\u52a1\u7aef\u4fe1\u606f\u672a\u77e5\uff0c\u65e0\u6cd5\u62fc\u63a5ue\u573a\u666f\u7ba1\u7406\u5730\u5740");
            return ResultCode.C10014;
        }
        return this.agentRest.restartAgentApp(address);
    }
}

