/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ue.signal.handler;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.ue.common.util.HttpTool;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

public class WsHandShakeHandler
implements HandshakeInterceptor {
    private static final Logger log = LoggerFactory.getLogger(WsHandShakeHandler.class);
    private String type;

    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) throws Exception {
        if (request instanceof ServletServerHttpRequest) {
            ServletServerHttpRequest serverHttpRequest = (ServletServerHttpRequest)request;
            String requestIp = HttpTool.getRealIpAddress((ServerHttpRequest)request);
            if (ObjectUtil.equal((Object)"agent", (Object)this.type)) {
                log.info("agent\u3010{}\u3011\u6b63\u5728\u8fde\u63a5......", (Object)requestIp);
                return true;
            }
            String serviceId = HttpTool.getPathVariables((HttpServletRequest)serverHttpRequest.getServletRequest(), (String)"serviceId");
            attributes.put("serviceId", serviceId);
            if (ObjectUtil.equal((Object)"web", (Object)this.type)) {
                log.info("{}\u6d4f\u89c8\u5668\u3010{}\u3011\u8bbf\u95ee\u573a\u666f{}", new Object[]{this.type, requestIp, serviceId});
            } else {
                log.info("\u3010{}\u3011\u4e0a\u573a\u666f{}\u8fde\u63a5{}\u670d\u52a1\u5668", new Object[]{requestIp, serviceId, this.type});
            }
            return true;
        }
        return false;
    }

    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception exception) {
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WsHandShakeHandler)) {
            return false;
        }
        WsHandShakeHandler other = (WsHandShakeHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WsHandShakeHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "WsHandShakeHandler(type=" + this.getType() + ")";
    }

    public WsHandShakeHandler() {
    }

    public WsHandShakeHandler(String type) {
        this.type = type;
    }
}

