/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.spatial;

import com.geoway.vtile.spatial.grid.Constants;
import java.util.HashMap;
import java.util.Map;

public class CRSConstants {
    public static final String CRS_UNIT_DEGREE = "degree";
    public static final String CRS_UNIT_METER = "meter";
    public static final String CRS_UNIT_PIXEL = "pixel";
    public static Map<Integer, String> CrsSridMap = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1843673371450522526L;
        {
            this.put(4326, "GCS_WGS_1984");
            this.put(4490, "GCS_China_Geodetic_Coordinate_System_2000");
            this.put(4214, "GCS_Beijing_1954");
            this.put(4610, "GCS_Xian_1980");
            this.put(4555, "GCS_New_Beijing");
            this.put(3857, "WGS_1984_Web_Mercator_Auxiliary_Sphere");
            this.put(900913, "WGS_1984_Web_Mercator_Auxiliary_Sphere");
            this.put(0, "\u672a\u5b9a\u4e49\u5750\u6807\u7cfb");
            this.put(4491, "CGCS2000 / Gauss-Kruger zone 13");
            this.put(4492, "CGCS2000 / Gauss-Kruger zone 14");
            this.put(4493, "CGCS2000 / Gauss-Kruger zone 15");
            this.put(4494, "CGCS2000 / Gauss-Kruger zone 16");
            this.put(4495, "CGCS2000 / Gauss-Kruger zone 17");
            this.put(4496, "CGCS2000 / Gauss-Kruger zone 18");
            this.put(4497, "CGCS2000 / Gauss-Kruger zone 19");
            this.put(4498, "CGCS2000 / Gauss-Kruger zone 20");
            this.put(4499, "CGCS2000 / Gauss-Kruger zone 21");
            this.put(4500, "CGCS2000 / Gauss-Kruger zone 22");
            this.put(4501, "CGCS2000 / Gauss-Kruger zone 23");
            this.put(4502, "CGCS2000 / Gauss-Kruger CM 75E");
            this.put(4503, "CGCS2000 / Gauss-Kruger CM 81E");
            this.put(4504, "CGCS2000 / Gauss-Kruger CM 87E");
            this.put(4505, "CGCS2000 / Gauss-Kruger CM 93E");
            this.put(4506, "CGCS2000 / Gauss-Kruger CM 99E");
            this.put(4507, "CGCS2000 / Gauss-Kruger CM 105E");
            this.put(4508, "CGCS2000 / Gauss-Kruger CM 111E");
            this.put(4509, "CGCS2000 / Gauss-Kruger CM 117E");
            this.put(4510, "CGCS2000 / Gauss-Kruger CM 123E");
            this.put(4511, "CGCS2000 / Gauss-Kruger CM 129E");
            this.put(4512, "CGCS2000 / Gauss-Kruger CM 135E");
            this.put(4513, "CGCS2000 / 3-degree Gauss-Kruger zone 25");
            this.put(4514, "CGCS2000 / 3-degree Gauss-Kruger zone 26");
            this.put(4515, "CGCS2000 / 3-degree Gauss-Kruger zone 27");
            this.put(4516, "CGCS2000 / 3-degree Gauss-Kruger zone 28");
            this.put(4517, "CGCS2000 / 3-degree Gauss-Kruger zone 29");
            this.put(4518, "CGCS2000 / 3-degree Gauss-Kruger zone 30");
            this.put(4519, "CGCS2000 / 3-degree Gauss-Kruger zone 31");
            this.put(4520, "CGCS2000 / 3-degree Gauss-Kruger zone 32");
            this.put(4521, "CGCS2000 / 3-degree Gauss-Kruger zone 33");
            this.put(4522, "CGCS2000 / 3-degree Gauss-Kruger zone 34");
            this.put(4523, "CGCS2000 / 3-degree Gauss-Kruger zone 35");
            this.put(4524, "CGCS2000 / 3-degree Gauss-Kruger zone 36");
            this.put(4525, "CGCS2000 / 3-degree Gauss-Kruger zone 37");
            this.put(4526, "CGCS2000 / 3-degree Gauss-Kruger zone 38");
            this.put(4527, "CGCS2000 / 3-degree Gauss-Kruger zone 39");
            this.put(4528, "CGCS2000 / 3-degree Gauss-Kruger zone 40");
            this.put(4529, "CGCS2000 / 3-degree Gauss-Kruger zone 41");
            this.put(4530, "CGCS2000 / 3-degree Gauss-Kruger zone 42");
            this.put(4531, "CGCS2000 / 3-degree Gauss-Kruger zone 43");
            this.put(4532, "CGCS2000 / 3-degree Gauss-Kruger zone 44");
            this.put(4533, "CGCS2000 / 3-degree Gauss-Kruger zone 45");
        }
    };

    public static String getCRSUnit(Integer srid) {
        if (3857 == srid || 900913 == srid || 4491 <= srid && srid <= 4554) {
            return CRS_UNIT_METER;
        }
        switch (srid) {
            case 0: 
            case 4214: 
            case 4326: 
            case 4490: 
            case 4610: {
                return CRS_UNIT_DEGREE;
            }
        }
        return CRS_UNIT_METER;
    }

    public static Constants.GRID_UNIT getGridUnit(Integer srid) {
        String strUnit = CRSConstants.getCRSUnit(srid);
        return Constants.GRID_UNIT.valueOf(strUnit);
    }

    public static String getCRSNameBySrid(Integer srid) {
        if (CrsSridMap.containsKey(srid)) {
            return CrsSridMap.get(srid);
        }
        throw new IllegalArgumentException("Unknown Coordinate System ID: " + srid);
    }

    public static boolean isValidCRS(Integer srid) {
        return CrsSridMap.containsKey(srid);
    }
}

