/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.spatial.grid.extent.impl;

import com.geoway.vtile.spatial.Point;
import com.geoway.vtile.spatial.grid.extent.Extent;

public abstract class AbstractExtent {
    public double bottom;
    public double left;
    public double right;
    public double top;
    protected String wkt;
    protected String BBOX;
    public Integer bufferSize;

    public AbstractExtent(String BBOX) {
        String[] boxs = BBOX.split(",");
        this.BBOX = BBOX;
        double left = Double.valueOf(boxs[0]);
        double bottom = Double.valueOf(boxs[1]);
        double right = Double.valueOf(boxs[2]);
        double top = Double.valueOf(boxs[3]);
        this.init(left, bottom, right, top);
    }

    public AbstractExtent(double left, double bottom, double right, double top) {
        this.BBOX = "" + left + ',' + bottom + ',' + right + ',' + top;
        this.init(left, bottom, right, top);
    }

    private void init(double left, double bottom, double right, double top) {
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.top = top;
        this.wkt = this.doWkt(left, bottom, right, top);
    }

    public double getBottom() {
        return this.bottom;
    }

    public double getLeft() {
        return this.left;
    }

    public double getRight() {
        return this.right;
    }

    public double getTop() {
        return this.top;
    }

    public String getBBOX() {
        return this.BBOX;
    }

    public String getWkt() {
        return this.wkt;
    }

    protected String doWkt(double left, double bottom, double right, double top) {
        String wkt = "POLYGON ((" + left + ' ' + bottom + ',' + right + ' ' + bottom + ',' + right + ' ' + top + ',' + left + ' ' + top + ',' + left + ' ' + bottom + ')' + ')';
        return wkt;
    }

    public double[] bbox() {
        return new double[]{this.left, this.bottom, this.right, this.top};
    }

    public Integer getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
    }

    public Extent.Extent4Point getBBoxCoordinates() {
        Extent.Extent4Point extent4Point = new Extent.Extent4Point(new Point(this.left, this.bottom), new Point(this.left, this.top), new Point(this.right, this.top), new Point(this.right, this.bottom));
        return extent4Point;
    }
}

