/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.spatial.grid.impl;

import com.geoway.vtile.spatial.grid.Constants;
import com.geoway.vtile.spatial.grid.QuadtreeGrid;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.spatial.grid.impl.AbstractGrid;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public abstract class QuadtreeImpl
extends AbstractGrid
implements QuadtreeGrid {
    private static double EMTPY = Double.NaN;

    protected void init(Integer base, int beginLevel, Constants.GRID_UNIT unit) {
        this.base = base;
        this.unit = unit;
        switch (unit) {
            case degree: {
                this.minX = -180.0;
                this.minY = -90.0;
                this.maxX = 180.0;
                this.maxY = 90.0;
                break;
            }
            case meter: {
                this.minX = -2.0037508E7;
                this.minY = -2.0037508E7;
                this.maxX = 2.0037508E7;
                this.maxY = 2.0037508E7;
            }
        }
        this.beginLevel = beginLevel;
        int unitpixel = (int)(this.maxY - this.minY);
        this.resolutionLevelBegin = (double)unitpixel / (double)this.base;
    }

    @Override
    public Double getResolution(int level) {
        return this.resolutionLevelBegin / Math.pow(2.0, level - this.beginLevel);
    }

    public GridExtent isGridExtent(String bbox) {
        return null;
    }

    public String toJson() {
        return null;
    }

    private Set<Long> polyRingCover(double[][] points, int level) {
        double y;
        double[][] newPoly = new double[points.length][];
        double resolution = this.getResolution(level);
        for (int index = 0; index < newPoly.length; ++index) {
            double[] doubleArr = points[index];
            double[] parent = new double[]{-1.0, -1.0};
            DoubleBuffer buffer = DoubleBuffer.allocate(doubleArr.length);
            for (int i = 0; i < doubleArr.length / 2; ++i) {
                double x = doubleArr[i * 2];
                y = doubleArr[i * 2 + 1];
                double _x = (int)((x - this.getMinX()) / resolution);
                double _y = (int)((this.getMaxY() - y) / resolution);
                if (parent[0] == -1.0 && parent[1] == -1.0) {
                    parent[0] = _x;
                    parent[1] = _y;
                    buffer.put(_x);
                    buffer.put(_y);
                    continue;
                }
                if (parent[0] == _x && parent[1] == _y) continue;
                parent[0] = _x;
                parent[1] = _y;
                buffer.put(_x);
                buffer.put(_y);
            }
            buffer.flip();
            double[] newCoordinates = new double[buffer.limit()];
            buffer.get(newCoordinates, 0, newCoordinates.length);
            newPoly[index] = newCoordinates;
        }
        double minY = EMTPY;
        double maxY = EMTPY;
        for (int pathIndex = 0; pathIndex < newPoly.length; ++pathIndex) {
            double[] subPoints = newPoly[pathIndex];
            for (int i = 0; i < subPoints.length / 2; ++i) {
                y = subPoints[i * 2 + 1];
                if (minY == EMTPY) {
                    minY = y;
                }
                if (maxY == EMTPY) {
                    maxY = y;
                }
                if (y >= maxY) {
                    maxY = y;
                }
                if (!(y < minY)) continue;
                minY = y;
            }
        }
        double gridExtendMaxY = maxY;
        double minX = 0.0;
        double maxX = (int)((this.getMaxX() - this.getMinX()) / resolution);
        HashSet<Long> scanXY = new HashSet<Long>();
        for (double scanlineY = minY; scanlineY <= gridExtendMaxY; scanlineY += 1.0) {
            long a1 = System.currentTimeMillis();
            Object scanline = null;
            scanline = new double[][]{{minX, scanlineY}, {maxX, scanlineY}};
            int Y = (int)(scanlineY / (double)this.getBase());
            ArrayList<Double> scanlineXDoubleArray = new ArrayList<Double>();
            for (int pathIndex = 0; pathIndex < newPoly.length; ++pathIndex) {
                double[] intersection;
                double[] subPoints = newPoly[pathIndex];
                if (subPoints.length <= 2) {
                    double x = (int)(subPoints[0] / (double)this.getBase());
                    double y2 = (int)subPoints[1];
                    if (y2 != scanlineY) continue;
                    scanlineXDoubleArray.add(x);
                    continue;
                }
                for (int i = 0; i < subPoints.length / 2 - 1; ++i) {
                    double[] intersection2;
                    double point1x = subPoints[i * 2];
                    double point1y = subPoints[i * 2 + 1];
                    double point2x = subPoints[i * 2 + 2];
                    double point2y = subPoints[i * 2 + 3];
                    if (point1y < scanlineY && point2y < scanlineY || point1y > scanlineY && point2y > scanlineY || (intersection2 = QuadtreeImpl.LINEINTERSECTS(scanline[0][0], scanline[0][1], scanline[1][0], scanline[1][1], point1x, point1y, point2x, point2y)) == null) continue;
                    double x = (int)(intersection2[0] / (double)this.getBase());
                    double y3 = (int)(intersection2[1] / (double)this.getBase());
                    scanlineXDoubleArray.add(x);
                }
                double point1x = subPoints[subPoints.length - 2];
                double point1y = subPoints[subPoints.length - 1];
                double point2x = subPoints[0];
                double point2y = subPoints[1];
                if (point1y < scanlineY && point2y < scanlineY || point1y > scanlineY && point2y > scanlineY || (intersection = QuadtreeImpl.LINEINTERSECTS(scanline[0][0], scanline[0][1], scanline[1][0], scanline[1][1], point1x, point1y, point2x, point2y)) == null) continue;
                double x = (int)(intersection[0] / (double)this.getBase());
                double y4 = (int)(intersection[1] / (double)this.getBase());
                scanlineXDoubleArray.add(x);
            }
            Collections.sort(scanlineXDoubleArray, new Comparator<Double>(){

                @Override
                public int compare(Double o1, Double o2) {
                    double x2;
                    double x1 = o1;
                    if (x1 >= (x2 = o2.doubleValue())) {
                        return 1;
                    }
                    return -1;
                }
            });
            for (int intersectionsIndex = 0; intersectionsIndex < scanlineXDoubleArray.size() - 1; ++intersectionsIndex) {
                if (intersectionsIndex % 2 != 0) continue;
                double intersectionXEnter = (Double)scanlineXDoubleArray.get(intersectionsIndex);
                double intersectionXExit = (Double)scanlineXDoubleArray.get(intersectionsIndex + 1);
                int exitX = (int)intersectionXExit;
                for (int enterX = (int)intersectionXEnter; enterX <= exitX; ++enterX) {
                    Long l = QuadtreeImpl.twoInt2Long(enterX, Y);
                    scanXY.add(l);
                }
            }
        }
        return scanXY;
    }

    public static long twoInt2Long(int low, int high) {
        return (long)low & 0xFFFFFFFFL | (long)high << 32 & 0xFFFFFFFF00000000L;
    }

    public static double[] LINEINTERSECTS(double line1StartX, double line1StartY, double line1EndX, double line1EndY, double line2StartX, double line2StartY, double line2EndX, double line2EndY) {
        double[] res = new double[]{Double.MAX_VALUE, Double.MAX_VALUE};
        double denominator = (line2EndY - line2StartY) * (line1EndX - line1StartX) - (line2EndX - line2StartX) * (line1EndY - line1StartY);
        if (denominator == 0.0) {
            if (res[0] != Double.MAX_VALUE && res[1] != Double.MAX_VALUE) {
                return res;
            }
            return null;
        }
        double a = line1StartY - line2StartY;
        double b = line1StartX - line2StartX;
        double numerator1 = (line2EndX - line2StartX) * a - (line2EndY - line2StartY) * b;
        double numerator2 = (line1EndX - line1StartX) * a - (line1EndY - line1StartY) * b;
        a = numerator1 / denominator;
        b = numerator2 / denominator;
        if (b >= 0.0 && b <= 1.0) {
            res[0] = line1StartX + a * (line1EndX - line1StartX);
            res[1] = line1StartY + a * (line1EndY - line1StartY);
            return res;
        }
        return null;
    }

    public static double[][] create(Geometry geom) throws Exception {
        int length = geom.getNumGeometries();
        double[][] darr = new double[length][];
        for (int i = 0; i < length; ++i) {
            Geometry sub = geom.getGeometryN(i);
            Coordinate[] cc = sub.getCoordinates();
            int cclength = cc.length;
            double[] subArr = new double[cclength * 2];
            for (int j = 0; j < cclength; ++j) {
                Coordinate c = sub.getCoordinates()[j];
                subArr[j * 2] = c.x;
                subArr[j * 2 + 1] = c.y;
            }
            darr[i] = subArr;
        }
        return darr;
    }
}

