/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.spatial.tool;

import com.geoway.vtile.commons.util.BuilderCreator;
import com.geoway.vtile.commons.util.DoubleBuilder;

public class Simplify {
    static double getSqDist(double p1X, double p1Y, double p2X, double p2Y) {
        double dx = p1X - p2X;
        double dy = p1Y - p2Y;
        return dx * dx + dy * dy;
    }

    public static DoubleBuilder simplifyRadialDist(DoubleBuilder points, double sqTolerance) {
        DoubleBuilder newPoints = BuilderCreator.createDouble();
        double prevPointX = points.get(0);
        double prevPointY = points.get(1);
        newPoints.append(prevPointX).append(prevPointY);
        double pointX = -99999.0;
        double pointY = -99999.0;
        int len = points.size() / 2;
        for (int i = 1; i < len; ++i) {
            pointX = points.get(i * 2);
            if (Simplify.getSqDist(pointX, pointY = points.get(i * 2 + 1), prevPointX, prevPointY) > sqTolerance) {
                newPoints.append(pointX);
                newPoints.append(pointY);
                prevPointX = pointX;
                prevPointY = pointY;
                continue;
            }
            double nextX = -99999.0;
            double nextY = -99999.0;
            if (i != len - 1) {
                nextX = points.get(i * 2 + 2);
                nextY = points.get(i * 2 + 3);
            } else {
                nextX = points.get(0);
                nextY = points.get(1);
            }
            if (!(Simplify.getSqDist(pointX, pointY, nextX, nextY) > sqTolerance)) continue;
            newPoints.append(pointX);
            newPoints.append(pointY);
            prevPointX = pointX;
            prevPointY = pointY;
        }
        if (prevPointX != pointX && prevPointY != pointY && (pointX != -99999.0 || pointY != -99999.0)) {
            newPoints.append(pointX);
            newPoints.append(pointY);
        }
        return newPoints;
    }

    public static DoubleBuilder simplifyDouglasPeucker(DoubleBuilder points, double sqTolerance) {
        int last = points.size() / 2 - 1;
        DoubleBuilder simplified = BuilderCreator.createDouble();
        simplified.append(points.get(0)).append(points.get(1));
        Simplify.simplifyDPStep(points, 0, last, sqTolerance, simplified);
        simplified.append(points.get(last * 2)).append(points.get(last * 2 + 1));
        return simplified;
    }

    static void simplifyDPStep(DoubleBuilder points, int first, int last, double sqTolerance, DoubleBuilder simplified) {
        double maxSqDist = sqTolerance;
        int index = 0;
        for (int i = first + 1; i < last; ++i) {
            double sqDist = Simplify.getSqSegDist(points.get(i * 2), points.get(i * 2 + 1), points.get(first * 2), points.get(first * 2 + 1), points.get(last * 2), points.get(last * 2 + 1));
            if (!(sqDist > maxSqDist)) continue;
            index = i;
            maxSqDist = sqDist;
        }
        if (maxSqDist > sqTolerance) {
            if (index - first > 1) {
                Simplify.simplifyDPStep(points, first, index, sqTolerance, simplified);
            }
            simplified.append(points.get(index * 2));
            simplified.append(points.get(index * 2 + 1));
            if (last - index > 1) {
                Simplify.simplifyDPStep(points, index, last, sqTolerance, simplified);
            }
        }
    }

    static double getSqSegDist(double pX, double pY, double p1X, double p1Y, double p2X, double p2Y) {
        double x = p1X;
        double y = p1Y;
        double dx = p2X - x;
        double dy = p2Y - y;
        if (dx != 0.0 || dy != 0.0) {
            double t = ((pX - x) * dx + (pY - y) * dy) / (dx * dx + dy * dy);
            if (t > 1.0) {
                x = p2X;
                y = p2Y;
            } else if (t > 0.0) {
                x += dx * t;
                y += dy * t;
            }
        }
        dx = pX - x;
        dy = pY - y;
        return dx * dx + dy * dy;
    }
}

