/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.pipeline;

import com.geoway.vtile.commons.pipeline.AbstractHandler;
import com.geoway.vtile.commons.pipeline.Handler;
import com.linkedin.migz.MiGzOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class GzipHandler
extends AbstractHandler
implements Handler,
AutoCloseable {
    private Integer blockSize;
    private MiGzOutputStream zipOutputStream;
    private BytesOutputStream outputStream;

    public GzipHandler(Integer threadCount, Integer blockSize, Integer compressionLevel) {
        this.blockSize = blockSize;
        this.outputStream = new BytesOutputStream(this);
        this.zipOutputStream = new MiGzOutputStream((OutputStream)this.outputStream, threadCount.intValue(), blockSize.intValue()).setCompressionLevel(compressionLevel.intValue());
    }

    @Override
    public synchronized <T> void pushData(T t) throws Exception {
        byte[] data = (byte[])t;
        try {
            this.zipOutputStream.write(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void end() throws Exception {
        this.outputStream.flush();
        this.zipOutputStream.close();
        if (this.next != null) {
            this.next.end();
        }
    }

    @Override
    public void close() throws Exception {
        this.zipOutputStream.close();
    }

    class BytesOutputStream
    extends OutputStream {
        GzipHandler handler;

        BytesOutputStream(GzipHandler handler) {
            this.handler = handler;
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public synchronized void flush() throws IOException {
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            byte[] out = new byte[len];
            System.arraycopy(b, 0, out, 0, len);
            try {
                if (this.handler.next != null) {
                    this.handler.next.pushData(out);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

